/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import java.util.LinkedHashMap;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.language.ColumnReference;
import org.teiid.language.Condition;
import org.teiid.language.Delete;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.ExpressionEvaluator;
import org.teiid.translator.mongodb.IDRef;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDBSelectVisitor;
import org.teiid.translator.mongodb.MutableDBRef;

public class MongoDBUpdateVisitor
extends MongoDBSelectVisitor {
    protected LinkedHashMap<String, Object> columnValues = new LinkedHashMap();
    private DB mongoDB;
    private BasicDBObject pull;
    private Condition condition;

    public MongoDBUpdateVisitor(MongoDBExecutionFactory executionFactory, RuntimeMetadata metadata, DB mongoDB) {
        super(executionFactory, metadata);
        this.mongoDB = mongoDB;
    }

    public void visit(Insert obj) {
        this.append((LanguageObject)obj.getTable());
        List columns = obj.getColumns();
        List values = ((ExpressionValueSource)obj.getValueSource()).getValues();
        try {
            for (int i = 0; i < columns.size(); ++i) {
                String colName = this.getColumnName((ColumnReference)columns.get(i));
                Expression expr = (Expression)values.get(i);
                this.resolveExpressionValue(obj.getTable().getName(), colName, expr);
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    private void resolveExpressionValue(String tableName, String colName, Expression expr) throws TranslatorException {
        Object value = null;
        if (expr instanceof Literal) {
            value = this.executionFactory.convertToMongoType(((Literal)expr).getValue(), this.mongoDB, colName);
        } else {
            this.exceptions.add(new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18001, new Object[0])));
        }
        this.columnValues.put(colName, value);
        this.mongoDoc.updateReferenceColumnValue(tableName, colName, value);
        if (this.mongoDoc.isPartOfForeignKey(colName)) {
            this.columnValues.put(colName, this.mongoDoc.getFKReference(colName));
        }
    }

    public void visit(Update obj) {
        this.condition = obj.getWhere();
        this.append((LanguageObject)obj.getTable());
        List changes = obj.getChanges();
        try {
            for (SetClause clause : changes) {
                String colName = this.getColumnName(clause.getSymbol());
                Expression expr = clause.getValue();
                this.resolveExpressionValue(obj.getTable().getName(), colName, expr);
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
        this.append((LanguageObject)obj.getWhere());
        if (!this.onGoingExpression.isEmpty()) {
            this.match = (DBObject)this.onGoingExpression.pop();
        }
    }

    public void visit(Delete obj) {
        this.condition = obj.getWhere();
        this.append((LanguageObject)obj.getTable());
        this.append((LanguageObject)obj.getWhere());
        if (!this.onGoingExpression.isEmpty()) {
            this.match = (DBObject)this.onGoingExpression.pop();
        }
    }

    public BasicDBObject getInsert(DB db, LinkedHashMap<String, DBObject> embeddedDocuments) {
        IDRef pk = null;
        BasicDBObject insert = new BasicDBObject();
        for (String key : this.columnValues.keySet()) {
            Object obj = this.columnValues.get(key);
            if (obj instanceof MutableDBRef) {
                obj = ((MutableDBRef)obj).getDBRef(db, true);
            }
            if (this.mongoDoc.isPartOfPrimaryKey(key)) {
                if (pk == null) {
                    pk = new IDRef();
                }
                pk.addColumn(key, obj);
                continue;
            }
            insert.append(key, obj);
        }
        if (pk != null) {
            insert.append("_id", pk.getValue());
        }
        if (this.mongoDoc.hasEmbeddedDocuments()) {
            for (String docName : this.mongoDoc.getEmbeddedDocumentNames()) {
                DBObject embedDoc = embeddedDocuments.get(docName);
                if (embedDoc == null) continue;
                insert.append(docName, (Object)embedDoc);
            }
        }
        return insert;
    }

    public BasicDBObject getUpdate(DB db, LinkedHashMap<String, DBObject> embeddedDocuments) throws TranslatorException {
        BasicDBObject update = new BasicDBObject();
        String embeddedDocumentName = null;
        if (this.mongoDoc.isMerged()) {
            embeddedDocumentName = this.mongoDoc.getTable().getName();
        }
        for (String key : this.columnValues.keySet()) {
            Object obj = this.columnValues.get(key);
            if (obj instanceof MutableDBRef) {
                MutableDBRef ref = (MutableDBRef)obj;
                if (this.mongoDoc.isMerged() && ref.getParentTable().equals(this.mongoDoc.getMergeTable().getName())) {
                    throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18007, new Object[]{ref.getParentTable(), embeddedDocumentName}));
                }
                update.append(key, (Object)ref.getDBRef(db, true));
                if (!this.mongoDoc.hasEmbeddedDocuments()) continue;
                for (MutableDBRef docKey : this.mongoDoc.getEmbeddableReferences()) {
                    if (!ref.getParentTable().equals(docKey.getEmbeddedTable())) continue;
                    DBObject embedDoc = embeddedDocuments.get(docKey.getName());
                    if (embedDoc != null) {
                        update.append(docKey.getName(), (Object)embedDoc);
                        continue;
                    }
                    update.append(docKey.getName(), null);
                }
                continue;
            }
            if (this.mongoDoc.isMerged()) {
                if (this.mongoDoc.getMergeAssosiation() == MutableDBRef.Assosiation.MANY) {
                    update.append(embeddedDocumentName + ".$." + key, obj);
                    continue;
                }
                update.append(embeddedDocumentName + "." + key, obj);
                continue;
            }
            if (MongoDBUpdateVisitor.isPartOfPrimaryKey(this.mongoDoc.getTargetTable(), key)) {
                if (this.hasCompositePrimaryKey(this.mongoDoc.getTargetTable())) {
                    update.append("_id." + key, obj);
                    continue;
                }
                update.append("_id", obj);
                continue;
            }
            update.append(key, obj);
        }
        return update;
    }

    public DBObject getPullQuery() {
        if (this.match == null) {
            return null;
        }
        if (this.pull == null) {
            this.pull = new BasicDBObject(this.mongoDoc.getTable().getName(), this.onGoingPullCriteria.pop());
        }
        return this.pull;
    }

    public BasicDBList updateMerge(DB db, BasicDBList previousRows) throws TranslatorException {
        BasicDBList updated = new BasicDBList();
        for (int i = 0; i < previousRows.size(); ++i) {
            BasicDBObject row = (BasicDBObject)previousRows.get(i);
            if (this.match != null && !ExpressionEvaluator.matches(this.condition, row)) continue;
            for (String key : this.columnValues.keySet()) {
                Object obj = this.columnValues.get(key);
                if (obj instanceof MutableDBRef) {
                    MutableDBRef ref = (MutableDBRef)obj;
                    row.put(key, (Object)ref.getDBRef(db, true));
                    continue;
                }
                row.put(key, obj);
            }
            updated.add((Object)row);
        }
        return updated;
    }
}

