/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.DB;
import com.mongodb.DBRef;
import java.util.ArrayList;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.IDRef;
import org.teiid.translator.mongodb.MongoDBPlugin;

public class MutableDBRef
implements Cloneable {
    private String parentTable;
    private IDRef id;
    private List<String> referenceColumns;
    private List<String> columns;
    private String embeddedTable;
    private Assosiation assosiation;
    private String name;
    private String idReference;
    private String referenceName;

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String name) {
        this.referenceName = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DBRef getDBRef(DB db, boolean push) {
        if (this.id != null) {
            if (this.idReference != null) {
                return new DBRef(db, push ? this.parentTable : this.embeddedTable, (Object)new DBRef(db, this.idReference, this.id.getValue()));
            }
            return new DBRef(db, push ? this.parentTable : this.embeddedTable, this.id.getValue());
        }
        return null;
    }

    public String getParentTable() {
        return this.parentTable;
    }

    public void setParentTable(String parentTable) {
        this.parentTable = parentTable;
    }

    public Object getId() throws TranslatorException {
        if (this.id == null) {
            return null;
        }
        if (this.id.pk.keySet().size() != this.columns.size()) {
            throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18014, new Object[0]));
        }
        return this.id.getValue();
    }

    public void setId(String column, Object value) {
        if (this.id == null) {
            this.id = new IDRef();
        }
        this.id.addColumn(column, value);
    }

    public List<String> getReferenceColumns() {
        return this.referenceColumns;
    }

    public void setReferenceColumns(List<String> columns) {
        this.referenceColumns = new ArrayList<String>(columns);
    }

    public String getEmbeddedTable() {
        return this.embeddedTable;
    }

    public void setEmbeddedTable(String embeddedTable) {
        this.embeddedTable = embeddedTable;
    }

    public Assosiation getAssosiation() {
        return this.assosiation;
    }

    public void setAssosiation(Assosiation assosiation) {
        this.assosiation = assosiation;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = new ArrayList<String>(columns);
    }

    public String getIdReference() {
        return this.idReference;
    }

    public void setIdReference(String idReference) {
        this.idReference = idReference;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParentTable:").append(this.parentTable);
        sb.append(" id:").append(this.id);
        sb.append(" EmbeddedTable:").append(this.embeddedTable);
        return sb.toString();
    }

    public MutableDBRef clone() {
        MutableDBRef clone = new MutableDBRef();
        clone.parentTable = this.parentTable;
        if (this.id != null) {
            clone.id = this.id.clone();
        }
        clone.referenceColumns = new ArrayList<String>(this.referenceColumns);
        clone.columns = new ArrayList<String>(this.columns);
        clone.embeddedTable = this.embeddedTable;
        clone.assosiation = this.assosiation;
        clone.name = this.name;
        clone.idReference = this.idReference;
        clone.referenceName = this.referenceName;
        return clone;
    }

    static enum Assosiation {
        ONE,
        MANY;

    }
}

