/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ws;

import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.ws.WSManagedConnectionFactory;
import org.teiid.resource.adapter.ws.WSSecurityCredential;
import org.teiid.resource.adapter.ws.WSSecurityToken;

public class TimestampProfile
extends WSSecurityToken {
    private boolean inMilli = true;
    private int ttl;

    public TimestampProfile(int ttl, boolean inMilli) {
        this.inMilli = inMilli;
        this.ttl = ttl;
        LogManager.logDetail((String)WSManagedConnectionFactory.UTIL.getString("using_timestamp_profile"), (Object[])new Object[0]);
    }

    @Override
    public void addSecurity(WSSecurityCredential credential) {
        this.setAction(credential, "Timestamp");
        credential.getRequestPropterties().put("timeToLive", this.ttl);
        credential.getRequestPropterties().put("precisionInMilliseconds", Boolean.toString(this.inMilli));
    }
}

