/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ws;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.activation.DataSource;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.Base64;
import org.teiid.core.util.StringUtil;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.ws.WSManagedConnectionFactory;
import org.teiid.resource.adapter.ws.WSSecurityCredential;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.resource.spi.BasicManagedConnectionFactory;
import org.teiid.resource.spi.ConnectionContext;
import org.teiid.translator.WSConnection;

public class WSConnectionImpl
extends BasicConnection
implements WSConnection {
    private static final String CONNECTION_TIMEOUT = "javax.xml.ws.client.connectionTimeout";
    private static final String RECEIVE_TIMEOUT = "javax.xml.ws.client.receiveTimeout";
    private WSManagedConnectionFactory mcf;
    private Service wsdlService;

    public WSConnectionImpl(WSManagedConnectionFactory mcf) {
        this.mcf = mcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Dispatch<T> createDispatch(Class<T> type, Service.Mode mode) throws IOException {
        if (this.wsdlService == null) {
            Bus bus = BusFactory.getThreadDefaultBus();
            BusFactory.setThreadDefaultBus((Bus)this.mcf.getBus());
            try {
                this.wsdlService = Service.create((URL)this.mcf.getWsdlUrl(), (QName)this.mcf.getServiceQName());
            }
            finally {
                BusFactory.setThreadDefaultBus((Bus)bus);
            }
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.CONNECTOR.WS", (int)5)) {
                LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object[])new Object[]{"Created the WSDL service for", this.mcf.getWsdl()});
            }
        }
        Dispatch dispatch = this.wsdlService.createDispatch(this.mcf.getPortQName(), type, mode);
        this.setDispatchProperties(dispatch);
        return dispatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Dispatch<T> createDispatch(String binding, String endpoint, Class<T> type, Service.Mode mode) {
        Service svc;
        Bus bus;
        ArgCheck.isNotNull((Object)binding);
        if (endpoint != null) {
            try {
                new URL(endpoint);
            }
            catch (MalformedURLException e) {
                String defaultEndpoint = this.mcf.getEndPoint();
                String defaultQueryString = null;
                String defaultFragment = null;
                if (defaultEndpoint == null) {
                    throw new WebServiceException(WSManagedConnectionFactory.UTIL.getString("null_default_endpoint"));
                }
                String[] parts = defaultEndpoint.split("\\?", 2);
                defaultEndpoint = parts[0];
                if (parts.length > 1) {
                    defaultQueryString = parts[1];
                    parts = defaultQueryString.split("#");
                    defaultQueryString = parts[0];
                    if (parts.length > 1) {
                        defaultFragment = parts[1];
                    }
                }
                endpoint = endpoint.startsWith("?") || endpoint.startsWith("/") ? defaultEndpoint + endpoint : defaultEndpoint + "/" + endpoint;
                if (defaultQueryString != null && defaultQueryString.trim().length() > 0) {
                    endpoint = WSConnection.Util.appendQueryString((String)endpoint, (String)defaultQueryString);
                }
                if (defaultFragment != null && endpoint.indexOf(35) < 0) {
                    endpoint = endpoint + '#' + defaultFragment;
                }
            }
        } else {
            endpoint = this.mcf.getEndPoint();
            if (endpoint == null) {
                throw new WebServiceException(WSManagedConnectionFactory.UTIL.getString("null_endpoint"));
            }
        }
        HttpDispatch dispatch = null;
        if ("http://www.w3.org/2004/08/wsdl/http".equals(binding) && type == DataSource.class) {
            bus = BusFactory.getThreadDefaultBus();
            BusFactory.setThreadDefaultBus((Bus)this.mcf.getBus());
            try {
                dispatch = new HttpDispatch(endpoint);
            }
            finally {
                BusFactory.setThreadDefaultBus((Bus)bus);
            }
        }
        bus = BusFactory.getThreadDefaultBus();
        BusFactory.setThreadDefaultBus((Bus)this.mcf.getBus());
        try {
            svc = Service.create((QName)this.mcf.getServiceQName());
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)bus);
        }
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.CONNECTOR.WS", (int)5)) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object[])new Object[]{"Creating a dispatch with endpoint", endpoint});
        }
        svc.addPort(this.mcf.getPortQName(), binding, endpoint);
        dispatch = svc.createDispatch(this.mcf.getPortQName(), type, mode);
        if (this.mcf.getAsSecurityType() == WSManagedConnectionFactory.SecurityType.WSSecurity) {
            WSSecurityCredential wSSecurityCredential;
            Subject subject;
            Client client = ((DispatchImpl)dispatch).getClient();
            Endpoint ep = client.getEndpoint();
            if (this.mcf.getOutInterceptors() != null) {
                for (Interceptor interceptor : this.mcf.getOutInterceptors()) {
                    ep.getOutInterceptors().add(interceptor);
                }
            }
            if ((subject = ConnectionContext.getSubject()) != null && (wSSecurityCredential = (WSSecurityCredential)ConnectionContext.getSecurityCredential((Subject)subject, WSSecurityCredential.class)) != null) {
                if (wSSecurityCredential.useSts()) {
                    dispatch.getRequestContext().put("ws-security.sts.client", wSSecurityCredential.buildStsClient(bus));
                }
                if (wSSecurityCredential.getSecurityHandler() == WSSecurityCredential.SecurityHandler.WSS4J) {
                    ep.getOutInterceptors().add(new WSS4JOutInterceptor(wSSecurityCredential.getRequestPropterties()));
                    ep.getInInterceptors().add(new WSS4JInInterceptor(wSSecurityCredential.getResponsePropterties()));
                } else if (wSSecurityCredential.getSecurityHandler() == WSSecurityCredential.SecurityHandler.WSPOLICY) {
                    dispatch.getRequestContext().putAll(wSSecurityCredential.getRequestPropterties());
                    dispatch.getResponseContext().putAll(wSSecurityCredential.getResponsePropterties());
                }
            }
        }
        this.setDispatchProperties(dispatch);
        if ("http://www.w3.org/2004/08/wsdl/http".equals(binding)) {
            HashMap<String, List<String>> httpHeaders = (HashMap<String, List<String>>)dispatch.getRequestContext().get("javax.xml.ws.http.request.headers");
            if (httpHeaders == null) {
                httpHeaders = new HashMap<String, List<String>>();
            }
            httpHeaders.put("Content-Type", Collections.singletonList("text/xml; charset=utf-8"));
            httpHeaders.put("User-Agent", Collections.singletonList("Teiid Server"));
            dispatch.getRequestContext().put("javax.xml.ws.http.request.headers", httpHeaders);
        }
        return dispatch;
    }

    private <T> void setDispatchProperties(Dispatch<T> dispatch) {
        if (this.mcf.getAsSecurityType() == WSManagedConnectionFactory.SecurityType.HTTPBasic) {
            String userName = this.mcf.getAuthUserName();
            String password = this.mcf.getAuthPassword();
            Subject subject = ConnectionContext.getSubject();
            if (subject != null) {
                userName = ConnectionContext.getUserName((Subject)subject, (BasicManagedConnectionFactory)this.mcf, (String)userName);
                password = ConnectionContext.getPassword((Subject)subject, (BasicManagedConnectionFactory)this.mcf, (String)userName, (String)password);
            }
            dispatch.getRequestContext().put("javax.xml.ws.security.auth.username", userName);
            dispatch.getRequestContext().put("javax.xml.ws.security.auth.password", password);
        }
        if (this.mcf.getRequestTimeout() != null) {
            dispatch.getRequestContext().put(RECEIVE_TIMEOUT, this.mcf.getRequestTimeout());
        }
        if (this.mcf.getConnectTimeout() != null) {
            dispatch.getRequestContext().put(CONNECTION_TIMEOUT, this.mcf.getConnectTimeout());
        }
    }

    public void close() throws ResourceException {
    }

    public URL getWsdl() {
        return this.mcf.getWsdlUrl();
    }

    public QName getServiceQName() {
        return this.mcf.getServiceQName();
    }

    public QName getPortQName() {
        return this.mcf.getPortQName();
    }

    public String getStatusMessage(int status) {
        Response.Status s = Response.Status.fromStatusCode((int)status);
        if (s != null) {
            return s.getReasonPhrase();
        }
        return null;
    }

    private static final class HttpDispatch
    implements Dispatch<DataSource> {
        private HashMap<String, Object> requestContext = new HashMap();
        private HashMap<String, Object> responseContext = new HashMap();
        private WebClient client;
        private String endpoint;

        public HttpDispatch(String endpoint) {
            this.endpoint = endpoint;
            this.client = WebClient.create((String)this.endpoint);
        }

        public DataSource invoke(DataSource msg) {
            try {
                URL url = new URL(this.endpoint);
                Map header = (Map)this.requestContext.get("javax.xml.ws.http.request.headers");
                for (Map.Entry entry : header.entrySet()) {
                    String value = StringUtil.join((List)((List)entry.getValue()), (String)",");
                    this.client.header((String)entry.getKey(), new Object[]{value});
                }
                String username = (String)this.requestContext.get("javax.xml.ws.security.auth.username");
                String password = (String)this.requestContext.get("javax.xml.ws.security.auth.password");
                if (username != null) {
                    this.client.header("Authorization", new Object[]{"Basic " + Base64.encodeBytes((byte[])(username + ':' + password).getBytes())});
                }
                InputStream payload = null;
                if (msg != null) {
                    payload = msg.getInputStream();
                }
                HTTPClientPolicy clientPolicy = WebClient.getConfig((Object)this.client).getHttpConduit().getClient();
                Long timeout = (Long)this.requestContext.get(WSConnectionImpl.RECEIVE_TIMEOUT);
                if (timeout != null) {
                    clientPolicy.setReceiveTimeout(timeout.longValue());
                }
                if ((timeout = (Long)this.requestContext.get(WSConnectionImpl.CONNECTION_TIMEOUT)) != null) {
                    clientPolicy.setConnectionTimeout(timeout.longValue());
                }
                Response response = this.client.invoke((String)this.requestContext.get("javax.xml.ws.http.request.method"), (Object)payload);
                this.responseContext.put("status-code", response.getStatus());
                this.responseContext.putAll((Map<String, Object>)response.getMetadata());
                ArrayList contentTypes = (ArrayList)this.responseContext.get("content-type");
                return new HttpDataSource(url, (InputStream)response.getEntity(), (String)contentTypes.get(0));
            }
            catch (IOException e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        public Map<String, Object> getRequestContext() {
            return this.requestContext;
        }

        public Map<String, Object> getResponseContext() {
            return this.responseContext;
        }

        public Binding getBinding() {
            throw new UnsupportedOperationException();
        }

        public EndpointReference getEndpointReference() {
            throw new UnsupportedOperationException();
        }

        public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
            throw new UnsupportedOperationException();
        }

        public javax.xml.ws.Response<DataSource> invokeAsync(DataSource msg) {
            throw new UnsupportedOperationException();
        }

        public Future<?> invokeAsync(DataSource msg, AsyncHandler<DataSource> handler) {
            throw new UnsupportedOperationException();
        }

        public void invokeOneWay(DataSource msg) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class HttpDataSource
    implements DataSource {
        private final URL url;
        private InputStream content;
        private String contentType;

        private HttpDataSource(URL url, InputStream entity, String contentType) {
            this.url = url;
            this.content = entity;
            this.contentType = contentType;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return this.url.getPath();
        }

        public InputStream getInputStream() throws IOException {
            return this.content;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

