/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ws;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.resource.adapter.ws.WSSecurityCredential;

public abstract class WSSecurityToken {
    private WSSecurityToken nextToken;
    private WSSecurityToken prevToken;

    Object getProperty(WSSecurityCredential credential, String name) {
        return credential.getRequestPropterties().get(name);
    }

    public void handleSecurity(WSSecurityCredential credential) {
        this.addSecurity(credential);
        if (this.nextToken != null) {
            this.nextToken.handleSecurity(credential);
        }
    }

    WSSecurityToken getNextToken() {
        return this.nextToken;
    }

    WSSecurityToken setNextToken(WSSecurityToken token) {
        this.nextToken = token;
        this.nextToken.prevToken = this;
        return token;
    }

    abstract void addSecurity(WSSecurityCredential var1);

    void setAction(WSSecurityCredential credential, String action) {
        String prev = (String)credential.getRequestPropterties().get("action");
        if (prev == null || prev.length() == 0) {
            credential.getRequestPropterties().put("action", action);
        } else {
            credential.getRequestPropterties().put("action", prev + " " + action);
        }
        credential.getResponsePropterties().put("action", "NoSecurity");
    }

    void handleCallback(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (this.prevToken == null) {
            throw new TeiidRuntimeException("No passwords defined for the profile");
        }
        this.prevToken.handleCallback(callbacks);
    }
}

