/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language;

import org.teiid.language.BaseLanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.MetadataReference;
import org.teiid.language.visitor.LanguageObjectVisitor;
import org.teiid.metadata.ProcedureParameter;

public class Argument
extends BaseLanguageObject
implements MetadataReference<ProcedureParameter> {
    private Direction direction;
    private Literal argumentValue;
    private ProcedureParameter metadataObject;
    private Class<?> type;

    public Argument(Direction direction, Literal value, Class<?> type, ProcedureParameter metadataObject) {
        this.direction = direction;
        this.argumentValue = value;
        this.metadataObject = metadataObject;
        this.type = type;
    }

    public Argument(Direction direction, Class<?> type, ProcedureParameter metadataObject) {
        this.direction = direction;
        this.metadataObject = metadataObject;
        this.type = type;
    }

    public Argument(Direction direction, Literal value, ProcedureParameter metadataObject) {
        this.direction = direction;
        this.argumentValue = value;
        this.metadataObject = metadataObject;
        if (value != null) {
            this.type = value.getType();
        }
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Literal getArgumentValue() {
        return this.argumentValue;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    @Override
    public void acceptVisitor(LanguageObjectVisitor visitor) {
        visitor.visit(this);
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setArgumentValue(Literal value) {
        this.argumentValue = value;
    }

    @Override
    public ProcedureParameter getMetadataObject() {
        return this.metadataObject;
    }

    public void setMetadataObject(ProcedureParameter metadataObject) {
        this.metadataObject = metadataObject;
    }

    public static enum Direction {
        IN,
        OUT,
        INOUT;

    }
}

