/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.infinispan.base;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.StringUtil;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.infinispan.base.InfinispanConnectionImpl;
import org.teiid.resource.adapter.infinispan.base.InfinispanPlugin;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.resource.spi.BasicManagedConnectionFactory;
import org.teiid.translator.object.CacheContainerWrapper;

public abstract class AbstractInfinispanManagedConnectionFactory
extends BasicManagedConnectionFactory {
    private static final long serialVersionUID = -9153717006234080627L;
    private String remoteServerList = null;
    private String configurationFileNameForLocalCache = null;
    private String hotrodClientPropertiesFile = null;
    private String cacheJndiName = null;
    private Map<String, Class<?>> typeMap = null;
    private String cacheTypes = null;
    private CacheContainerWrapper cacheContainer = null;
    private Map<String, String> pkMap;
    private String module;
    private CACHE_TYPE cacheType;

    public BasicConnectionFactory<InfinispanConnectionImpl> createConnectionFactory() throws ResourceException {
        if (this.cacheTypes == null) {
            throw new InvalidPropertyException(InfinispanPlugin.Util.getString("InfinispanManagedConnectionFactory.cacheTypeMapNotSet"));
        }
        if (this.remoteServerList == null && this.configurationFileNameForLocalCache == null && this.hotrodClientPropertiesFile == null && this.cacheJndiName == null) {
            throw new InvalidPropertyException(InfinispanPlugin.Util.getString("InfinispanManagedConnectionFactory.invalidServerConfiguration"));
        }
        this.determineCacheType();
        if (this.cacheType == null) {
            throw new InvalidPropertyException(InfinispanPlugin.Util.getString("InfinispanManagedConnectionFactory.invalidServerConfiguration"));
        }
        return new BasicConnectionFactory<InfinispanConnectionImpl>(){
            private static final long serialVersionUID = 2579916624625349535L;

            public InfinispanConnectionImpl getConnection() throws ResourceException {
                AbstractInfinispanManagedConnectionFactory.this.createCacheContainer();
                return new InfinispanConnectionImpl(AbstractInfinispanManagedConnectionFactory.this);
            }
        };
    }

    public String getCacheTypeMap() {
        return this.cacheTypes;
    }

    public void setCacheTypeMap(String cacheTypeMap) {
        this.cacheTypes = cacheTypeMap;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getModule() {
        return this.module;
    }

    public String getPkMap(String cacheName) {
        return this.pkMap.get(cacheName);
    }

    public void setPkMap(Map<String, String> mapOfPKs) {
        this.pkMap = mapOfPKs;
    }

    public Map<String, Class<?>> getCacheNameClassTypeMapping() {
        return this.typeMap;
    }

    public void setCacheNameClassTypeMapping(Map<String, Class<?>> cacheType) {
        this.typeMap = cacheType;
    }

    public Class<?> getCacheType(String cacheName) {
        return this.typeMap.get(cacheName);
    }

    public String getRemoteServerList() {
        return this.remoteServerList;
    }

    public void setRemoteServerList(String remoteServerList) {
        this.remoteServerList = remoteServerList;
    }

    public String getConfigurationFileNameForLocalCache() {
        return this.configurationFileNameForLocalCache;
    }

    public void setConfigurationFileNameForLocalCache(String configurationFileName) {
        this.configurationFileNameForLocalCache = configurationFileName;
    }

    public String getHotRodClientPropertiesFile() {
        return this.hotrodClientPropertiesFile;
    }

    public void setHotRodClientPropertiesFile(String propertieFileName) {
        this.hotrodClientPropertiesFile = propertieFileName;
    }

    public String getCacheJndiName() {
        return this.cacheJndiName;
    }

    public void setCacheJndiName(String jndiName) {
        this.cacheJndiName = jndiName;
    }

    public CacheContainerWrapper getCacheContainer() {
        return this.cacheContainer;
    }

    protected boolean isAlive() {
        return this.cacheContainer != null;
    }

    protected synchronized ClassLoader loadClasses() throws ResourceException {
        ClassLoader cl = null;
        if (this.getModule() != null) {
            try {
                List mods = StringUtil.getTokens((String)this.getModule(), (String)",");
                for (String mod : mods) {
                    Module x = Module.getContextModuleLoader().loadModule(ModuleIdentifier.create((String)mod));
                    if (cl != null) continue;
                    cl = x.getClassLoader();
                }
            }
            catch (ModuleLoadException e) {
                throw new ResourceException((Throwable)e);
            }
        } else {
            cl = ((Object)((Object)this)).getClass().getClassLoader();
        }
        List types = StringUtil.getTokens((String)this.getCacheTypeMap(), (String)",");
        HashMap pkMap = new HashMap(types.size());
        HashMap tm = new HashMap(types.size());
        for (String type : types) {
            List mapped = StringUtil.getTokens((String)type, (String)":");
            if (mapped.size() != 2) {
                throw new InvalidPropertyException(InfinispanPlugin.Util.getString("InfinispanManagedConnectionFactory.invalidCacheTypeMap"));
            }
            String cacheName = (String)mapped.get(0);
            String className = (String)mapped.get(1);
            if ((mapped = StringUtil.getTokens((String)className, (String)";")).size() > 1) {
                className = (String)mapped.get(0);
                pkMap.put(cacheName, mapped.get(1));
            }
            try {
                tm.put(cacheName, Class.forName(className, true, cl));
            }
            catch (ClassNotFoundException e) {
                throw new ResourceException((Throwable)e);
            }
        }
        this.setCacheNameClassTypeMapping(Collections.unmodifiableMap(tm));
        this.setPkMap(Collections.unmodifiableMap(pkMap));
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void createCacheContainer() throws ResourceException {
        if (this.cacheContainer != null) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            ClassLoader classLoader = this.loadClasses();
            switch (this.cacheType) {
                case LOCAL_JNDI: {
                    this.cacheContainer = this.createLocalCacheViaJNDI();
                    return;
                }
                case LOCAL_CONFIG_FILE: {
                    this.cacheContainer = this.createLocalCacheFromConfigFile();
                    return;
                }
                case REMOTE_HOT_ROD_PROPERTIES: {
                    this.cacheContainer = this.createRemoteCacheUsingHotRodClient(classLoader);
                    return;
                }
                case REMOTE_SERVER_LISTS: {
                    this.cacheContainer = this.createRemoteCacheFromServerList(classLoader);
                    return;
                }
            }
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void determineCacheType() {
        if (this.getConfigurationFileNameForLocalCache() != null) {
            this.cacheType = CACHE_TYPE.LOCAL_CONFIG_FILE;
        } else {
            String jndiName = this.getCacheJndiName();
            if (jndiName != null && jndiName.trim().length() != 0) {
                this.cacheType = CACHE_TYPE.LOCAL_JNDI;
            } else if (this.getHotRodClientPropertiesFile() != null) {
                this.cacheType = CACHE_TYPE.REMOTE_HOT_ROD_PROPERTIES;
            } else if (this.getRemoteServerList() != null && !this.getRemoteServerList().isEmpty()) {
                this.cacheType = CACHE_TYPE.REMOTE_SERVER_LISTS;
            }
        }
    }

    private CacheContainerWrapper createRemoteCacheUsingHotRodClient(ClassLoader classLoader) throws ResourceException {
        File f = new File(this.getHotRodClientPropertiesFile());
        if (!f.exists()) {
            throw new InvalidPropertyException(InfinispanPlugin.Util.getString("InfinispanManagedConnectionFactory.clientPropertiesFileDoesNotExist", new Object[]{this.getHotRodClientPropertiesFile()}));
        }
        try {
            Properties props = PropertiesUtils.load((String)f.getAbsolutePath());
            LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)"=== Using RemoteCacheManager (loaded by configuration) ===");
            return this.createRemoteCache(props, classLoader);
        }
        catch (MalformedURLException e) {
            throw new ResourceException((Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    private CacheContainerWrapper createRemoteCacheFromServerList(ClassLoader classLoader) throws ResourceException {
        Properties props = new Properties();
        props.put("infinispan.client.hotrod.server_list", this.getRemoteServerList());
        LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)"=== Using RemoteCacheManager (loaded by serverlist) ===");
        return this.createRemoteCache(props, classLoader);
    }

    protected abstract CacheContainerWrapper createRemoteCache(Properties var1, ClassLoader var2) throws ResourceException;

    private CacheContainerWrapper createLocalCacheViaJNDI() throws ResourceException {
        String jndiName = this.getCacheJndiName();
        try {
            Object cache = this.performJNDICacheLookup(jndiName);
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"=== Using CacheContainer (obtained by JNDI:", jndiName, "==="});
            return new LocalCacheWrapper((EmbeddedCacheManager)cache);
        }
        catch (ResourceException re) {
            throw re;
        }
        catch (Exception err) {
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            throw new ResourceException((Throwable)err);
        }
    }

    protected Object performJNDICacheLookup(String jndiName) throws Exception {
        InitialContext context = null;
        context = new InitialContext();
        Object cache = context.lookup(jndiName);
        if (cache == null) {
            throw new ResourceException(InfinispanPlugin.Util.getString("InfinispanManagedConnectionFactory.unableToFindCacheUsingJNDI", new Object[]{jndiName}));
        }
        return cache;
    }

    private CacheContainerWrapper createLocalCacheFromConfigFile() throws ResourceException {
        try {
            DefaultCacheManager cc = new DefaultCacheManager(this.getConfigurationFileNameForLocalCache());
            LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)"=== Using DefaultCacheManager (loaded by configuration) ===");
            return new LocalCacheWrapper((EmbeddedCacheManager)cc);
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.remoteServerList == null ? 0 : this.remoteServerList.hashCode());
        result = 31 * result + (this.configurationFileNameForLocalCache == null ? 0 : this.configurationFileNameForLocalCache.hashCode());
        result = 31 * result + (this.hotrodClientPropertiesFile == null ? 0 : this.hotrodClientPropertiesFile.hashCode());
        result = 31 * result + (this.cacheJndiName == null ? 0 : this.cacheJndiName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractInfinispanManagedConnectionFactory other = (AbstractInfinispanManagedConnectionFactory)((Object)obj);
        if (!AbstractInfinispanManagedConnectionFactory.checkEquals((Object)this.remoteServerList, (Object)other.remoteServerList)) {
            return false;
        }
        if (!AbstractInfinispanManagedConnectionFactory.checkEquals((Object)this.configurationFileNameForLocalCache, (Object)other.configurationFileNameForLocalCache)) {
            return false;
        }
        if (!AbstractInfinispanManagedConnectionFactory.checkEquals((Object)this.hotrodClientPropertiesFile, (Object)other.hotrodClientPropertiesFile)) {
            return false;
        }
        if (!AbstractInfinispanManagedConnectionFactory.checkEquals((Object)this.cacheJndiName, (Object)other.cacheJndiName)) {
            return false;
        }
        return false;
    }

    public void cleanUp() {
        this.typeMap = null;
        this.cacheContainer = null;
        this.pkMap = null;
    }

    private static enum CACHE_TYPE {
        LOCAL_CONFIG_FILE,
        LOCAL_JNDI,
        REMOTE_SERVER_LISTS,
        REMOTE_HOT_ROD_PROPERTIES;

    }

    public static class LocalCacheWrapper
    extends CacheContainerWrapper {
        EmbeddedCacheManager ecm = null;

        public LocalCacheWrapper(EmbeddedCacheManager container) {
            this.ecm = container;
        }

        public Cache getCache(String cacheName) {
            if (cacheName == null) {
                return this.ecm.getCache();
            }
            return this.ecm.getCache(cacheName);
        }

        public void cleanUp() {
            this.ecm.stop();
        }
    }
}

