/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.object.infinispan;

import java.util.List;
import org.teiid.language.Select;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.object.ObjectConnection;
import org.teiid.translator.object.ObjectExecutionFactory;
import org.teiid.translator.object.infinispan.LuceneSearch;

@Translator(name="infinispan-cache", description="The Infinispan Cache Translator")
public class InfinispanExecutionFactory
extends ObjectExecutionFactory {
    private boolean supportsLuceneSearching = false;

    public boolean isFullTextSearchingSupported() {
        return this.supportsLuceneSearching;
    }

    @TranslatorProperty(display="Support Using Lucene Searching", description="True, assumes objects have Hibernate Search annotations", advanced=true)
    public boolean supportsLuceneSearching() {
        return this.supportsLuceneSearching;
    }

    public void setSupportsLuceneSearching(boolean supportsLuceneSearching) {
        this.supportsLuceneSearching = supportsLuceneSearching;
    }

    public boolean supportsOrCriteria() {
        return this.isFullTextSearchingSupported();
    }

    public boolean supportsCompareCriteriaOrdered() {
        return this.isFullTextSearchingSupported();
    }

    public boolean supportsLikeCriteria() {
        return false;
    }

    @Override
    public List<Object> search(Select command, String cacheName, ObjectConnection connection, ExecutionContext executionContext) throws TranslatorException {
        if (this.supportsLuceneSearching()) {
            Class<?> type = connection.getType(cacheName);
            return LuceneSearch.performSearch(command, type, cacheName, connection.getCacheContainer());
        }
        return super.search(command, cacheName, connection, executionContext);
    }
}

