/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.loopback;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.logging.LogManager;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.loopback.LoopbackExecutionFactory;

public class LoopbackExecution
implements UpdateExecution,
ProcedureExecution {
    private LoopbackExecutionFactory config;
    private Command command;
    private String staticStringValue = "";
    private Random randomNumber = new Random();
    private List<Object> row;
    private List<Class<?>> types;
    private boolean waited = false;
    private int rowsReturned = 0;
    private int rowsNeeded = 1;
    private BigInteger rowNumber = BigInteger.ZERO;
    public static final Long DAY_SECONDS = 86400L;
    private static final int DATE_PERIOD = 0x22229D;

    public LoopbackExecution(Command command, LoopbackExecutionFactory config) {
        this.config = config;
        this.command = command;
        this.staticStringValue = LoopbackExecution.constructIncrementedString(config.getCharacterValuesSize());
    }

    public static String constructIncrementedString(int characterValuesSize) {
        StringBuffer alphaString = new StringBuffer();
        int genAlphaSize = characterValuesSize;
        int currentChar = 65;
        while (genAlphaSize-- != 0) {
            alphaString.append((char)currentChar);
            if (currentChar == 90) {
                currentChar = 65;
                continue;
            }
            currentChar = (char)(currentChar + 1);
        }
        return alphaString.toString();
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.config.getWaitTime() > 0 && !this.waited) {
            int randomTimeToWait = this.randomNumber.nextInt(this.config.getWaitTime());
            if ((long)randomTimeToWait > this.config.getPollIntervalInMilli()) {
                this.waited = true;
                DataNotAvailableException dnae = new DataNotAvailableException((long)randomTimeToWait);
                dnae.setStrict(true);
                throw dnae;
            }
            try {
                Thread.sleep(randomTimeToWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.waited = true;
        }
        List<Object> resultRow = this.row;
        if (this.rowsReturned < this.rowsNeeded && resultRow.size() > 0) {
            ++this.rowsReturned;
            if (this.config.getIncrementRows()) {
                this.rowNumber = this.rowNumber.add(BigInteger.ONE);
                this.generateRow();
            }
            return resultRow;
        }
        return null;
    }

    public void execute() throws TranslatorException {
        QueryExpression queryCommand;
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Loopback executing command: " + this.command});
        if (this.config.isThrowError()) {
            throw new TranslatorException("Failing because Error=true");
        }
        this.rowsNeeded = this.config.getRowCount();
        if (this.command instanceof QueryExpression && (queryCommand = (QueryExpression)this.command).getLimit() != null) {
            this.rowsNeeded = queryCommand.getLimit().getRowLimit();
        }
        this.determineOutputTypes();
        this.generateRow();
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return new int[]{0};
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        Call proc = (Call)this.command;
        int count = proc.getReturnType() != null ? 1 : 0;
        for (Argument param : proc.getArguments()) {
            if (param.getDirection() != Argument.Direction.INOUT && param.getDirection() != Argument.Direction.OUT) continue;
            ++count;
        }
        return Arrays.asList(new Object[count]);
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    private void determineOutputTypes() {
        if (this.command instanceof QueryExpression) {
            QueryExpression query = (QueryExpression)this.command;
            this.types = Arrays.asList(query.getColumnTypes());
            return;
        }
        if (this.command instanceof Call) {
            this.types = Arrays.asList(((Call)this.command).getResultSetColumnTypes());
            return;
        }
        this.types = new ArrayList(1);
        this.types.add(Integer.class);
    }

    private void generateRow() {
        ArrayList<Object> newRow = new ArrayList<Object>(this.types.size());
        String incrementedString = LoopbackExecution.incrementString(this.staticStringValue, this.rowNumber);
        for (Class<?> type : this.types) {
            if (type.equals(Integer.class)) {
                newRow.add(this.rowNumber.intValue());
                continue;
            }
            if (type.equals(Short.class)) {
                newRow.add(this.rowNumber.shortValue());
                continue;
            }
            if (type.equals(Long.class)) {
                newRow.add(this.rowNumber.longValue());
                continue;
            }
            if (type.equals(Float.class)) {
                newRow.add(Float.valueOf(this.rowNumber.floatValue() / 10.0f));
                continue;
            }
            if (type.equals(Double.class)) {
                newRow.add(this.rowNumber.doubleValue() / 10.0);
                continue;
            }
            if (type.equals(Character.class)) {
                newRow.add(Character.valueOf((char)(((this.rowNumber.byteValue() & 0xFF) + 2) % 26 + 97)));
                continue;
            }
            if (type.equals(Byte.class)) {
                newRow.add(this.rowNumber.byteValue());
                continue;
            }
            if (type.equals(Boolean.class)) {
                newRow.add(this.rowNumber.intValue() % 2 != 0);
                continue;
            }
            if (type.equals(BigInteger.class)) {
                newRow.add(this.rowNumber);
                continue;
            }
            if (type.equals(BigDecimal.class)) {
                newRow.add(new BigDecimal(this.rowNumber, 1));
                continue;
            }
            if (type.equals(Date.class)) {
                newRow.add(new Date(DAY_SECONDS * 1000L * (long)(this.rowNumber.intValue() % 0x22229D)));
                continue;
            }
            if (type.equals(Time.class)) {
                newRow.add(new Time((long)this.rowNumber.intValue() % DAY_SECONDS * 1000L));
                continue;
            }
            if (type.equals(Timestamp.class)) {
                newRow.add(new Timestamp(this.rowNumber.longValue()));
                continue;
            }
            if (type.equals(TypeFacility.RUNTIME_TYPES.CLOB)) {
                newRow.add(this.config.getTypeFacility().convertToRuntimeType((Object)incrementedString.toCharArray()));
                continue;
            }
            if (type.equals(TypeFacility.RUNTIME_TYPES.BLOB) || type.equals(TypeFacility.RUNTIME_TYPES.VARBINARY)) {
                newRow.add(this.config.getTypeFacility().convertToRuntimeType((Object)incrementedString.getBytes()));
                continue;
            }
            newRow.add(incrementedString);
        }
        this.row = newRow;
    }

    public static String incrementString(String string, BigInteger number) {
        String numberString = number.toString();
        if (number.equals(BigInteger.ZERO)) {
            return string;
        }
        return string.substring(0, string.length() - numberString.length()) + numberString;
    }
}

