/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.util.SymbolMap;

public class AliasGenerator
extends PreOrderNavigator {
    private static final String table_prefix = "g_";
    private static final String view_prefix = "v_";
    private NamingVisitor visitor = (NamingVisitor)this.getVisitor();
    private int groupIndex;
    private int viewIndex;
    private boolean stripColumnAliases;
    private Map<String, String> aliasMapping;

    public AliasGenerator(boolean aliasGroups) {
        this(aliasGroups, false);
    }

    public AliasGenerator(boolean aliasGroups, boolean stripColumnAliases) {
        super(new NamingVisitor(aliasGroups));
        this.stripColumnAliases = stripColumnAliases;
    }

    @Override
    public void visit(SetQuery obj) {
        this.visitor.createChildNamingContext(true);
        this.visitNode(obj.getRightQuery());
        this.visitor.removeChildNamingContext();
        ((NamingVisitor)this.visitor).namingContext.aliasColumns = true;
        this.visitNode(obj.getLeftQuery());
        this.visitNode(obj.getOrderBy());
    }

    @Override
    public void visit(Select obj) {
        List<Expression> selectSymbols = obj.getSymbols();
        HashMap<Expression, String> symbols = new HashMap<Expression, String>(selectSymbols.size());
        for (int i = 0; i < selectSymbols.size(); ++i) {
            Expression symbol = selectSymbols.get(i);
            this.visitNode(symbol);
            boolean needsAlias = ((NamingVisitor)this.visitor).namingContext.aliasColumns;
            String newAlias = "c_" + i;
            Expression newSymbol = SymbolMap.getExpression(symbol);
            if (newSymbol instanceof ElementSymbol) {
                if (!needsAlias) {
                    newAlias = ((ElementSymbol)newSymbol).getShortName();
                } else {
                    needsAlias &= this.needsAlias(newAlias, (ElementSymbol)newSymbol);
                }
            }
            symbols.put(symbol, newAlias);
            if (((NamingVisitor)this.visitor).namingContext.aliasColumns && needsAlias) {
                newSymbol = new AliasSymbol(Symbol.getShortName(symbol), newSymbol);
                ((AliasSymbol)newSymbol).setShortName(newAlias);
            }
            selectSymbols.set(i, newSymbol);
        }
        ((NamingVisitor)this.visitor).namingContext.currentSymbols = symbols;
    }

    private boolean needsAlias(String newAlias, ElementSymbol symbol) {
        return !(symbol.getMetadataID() instanceof TempMetadataID) || !newAlias.equalsIgnoreCase(symbol.getShortName());
    }

    @Override
    public void visit(Query obj) {
        if (obj.getOrderBy() != null || obj.getLimit() != null) {
            ((NamingVisitor)this.visitor).namingContext.aliasColumns = !this.stripColumnAliases;
        }
        this.visitNode(obj.getFrom());
        if (this.aliasMapping != null) {
            HashSet<String> newSymbols = new HashSet<String>();
            for (Map.Entry<String, String> entry : ((NamingVisitor)this.visitor).namingContext.groupNames.entrySet()) {
                if (newSymbols.add(entry.getValue())) continue;
                throw new TeiidRuntimeException((Throwable)((Object)new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID31126, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31126, new Object[]{entry.getValue()}))));
            }
        }
        this.visitNode(obj.getCriteria());
        this.visitNode(obj.getGroupBy());
        this.visitNode(obj.getHaving());
        this.visitNode(obj.getSelect());
        this.visitNode(obj.getOrderBy());
    }

    @Override
    public void visit(SubqueryFromClause obj) {
        this.visitor.createChildNamingContext(true);
        obj.getCommand().acceptVisitor(this);
        HashMap<String, String> viewGroup = new HashMap<String, String>();
        for (Map.Entry<Expression, String> entry : ((NamingVisitor)this.visitor).namingContext.currentSymbols.entrySet()) {
            viewGroup.put(Symbol.getShortName(entry.getKey()), entry.getValue());
        }
        ((NamingVisitor)this.visitor).namingContext.parent.elementMap.put(obj.getName(), viewGroup);
        this.visitor.removeChildNamingContext();
        obj.getGroupSymbol().setName(this.recontextGroup(obj.getGroupSymbol(), true));
    }

    @Override
    public void visit(UnaryFromClause obj) {
        GroupSymbol symbol = obj.getGroup();
        if (this.visitor.aliasGroups) {
            this.recontextGroup(symbol, false);
        } else {
            ((NamingVisitor)this.visitor).namingContext.groupNames.put(symbol.getName(), symbol.getNonCorrelationName());
        }
        super.visit(obj);
    }

    private String recontextGroup(GroupSymbol symbol, boolean virtual) {
        String oldAlias;
        String newAlias = null;
        newAlias = virtual ? view_prefix + this.viewIndex++ : table_prefix + this.groupIndex++;
        if (this.aliasMapping != null && symbol.getDefinition() != null && (oldAlias = this.aliasMapping.get(symbol.getName())) != null && ((newAlias = oldAlias).startsWith(table_prefix) || newAlias.startsWith(view_prefix))) {
            try {
                Integer.parseInt(newAlias.substring(2, newAlias.length()));
                throw new TeiidRuntimeException((Throwable)((Object)new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID31127, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31127, new Object[]{newAlias}))));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        ((NamingVisitor)this.visitor).namingContext.groupNames.put(symbol.getName(), newAlias);
        return newAlias;
    }

    @Override
    public void visit(ScalarSubquery obj) {
        if (obj.shouldEvaluate()) {
            return;
        }
        this.visitor.createChildNamingContext(false);
        this.visitNode(obj.getCommand());
        this.visitor.removeChildNamingContext();
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        this.visitNode(obj.getLeftExpression());
        this.visitor.createChildNamingContext(false);
        this.visitNode(obj.getCommand());
        this.visitor.removeChildNamingContext();
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        this.visitNode(obj.getExpression());
        this.visitor.createChildNamingContext(false);
        this.visitNode(obj.getCommand());
        this.visitor.removeChildNamingContext();
    }

    @Override
    public void visit(ExistsCriteria obj) {
        if (obj.shouldEvaluate()) {
            return;
        }
        this.visitor.createChildNamingContext(false);
        this.visitNode(obj.getCommand());
        this.visitor.removeChildNamingContext();
    }

    @Override
    public void visit(OrderBy obj) {
        for (int i = 0; i < obj.getVariableCount(); ++i) {
            OrderByItem item = obj.getOrderByItems().get(i);
            Expression element = item.getSymbol();
            this.visitNode(element);
            Expression expr = SymbolMap.getExpression(element);
            if (item.isUnrelated()) {
                item.setSymbol(expr);
                continue;
            }
            String name = null;
            if (((NamingVisitor)this.visitor).namingContext.currentSymbols != null) {
                name = ((NamingVisitor)this.visitor).namingContext.currentSymbols.get(element);
            }
            if (name == null) {
                name = Symbol.getShortName(element);
            }
            boolean needsAlias = ((NamingVisitor)this.visitor).namingContext.aliasColumns;
            if (name == null) continue;
            if (expr instanceof ElementSymbol) {
                needsAlias &= this.needsAlias(name, (ElementSymbol)expr);
            }
            if (needsAlias) {
                element = new AliasSymbol(Symbol.getShortName(element), expr);
            } else {
                element = expr;
                if (expr instanceof ElementSymbol && ((NamingVisitor)this.visitor).namingContext.aliasColumns) {
                    ((ElementSymbol)expr).setDisplayMode(ElementSymbol.DisplayMode.SHORT_OUTPUT_NAME);
                }
            }
            item.setSymbol(element);
            if (!(element instanceof Symbol)) continue;
            ((Symbol)((Object)element)).setShortName(name);
        }
    }

    @Override
    public void visit(Reference obj) {
        this.visitNode(obj.getExpression());
    }

    public void setAliasMapping(Map<String, String> aliasMapping) {
        this.aliasMapping = aliasMapping;
    }

    private static class NamingVisitor
    extends LanguageVisitor {
        private SQLNamingContext namingContext = new SQLNamingContext(null);
        boolean aliasGroups;

        public NamingVisitor(boolean aliasGroups) {
            this.aliasGroups = aliasGroups;
        }

        @Override
        public void visit(ElementSymbol obj) {
            GroupSymbol group = obj.getGroupSymbol();
            if (group == null) {
                return;
            }
            String newName = this.namingContext.getElementName(obj);
            if (newName != null) {
                obj.setShortName(newName);
            }
            obj.setDisplayMode(ElementSymbol.DisplayMode.FULLY_QUALIFIED);
        }

        @Override
        public void visit(GroupSymbol obj) {
            this.namingContext.renameGroup(obj, this.namingContext.getGroupName(obj.getName()));
        }

        public void createChildNamingContext(boolean aliasColumns) {
            this.namingContext = new SQLNamingContext(this.namingContext);
            this.namingContext.aliasColumns = aliasColumns;
        }

        public void removeChildNamingContext() {
            this.namingContext = this.namingContext.parent;
        }

        private class SQLNamingContext {
            SQLNamingContext parent;
            Map<String, Map<String, String>> elementMap = new HashMap<String, Map<String, String>>();
            Map<String, String> groupNames = new HashMap<String, String>();
            Map<Expression, String> currentSymbols;
            boolean aliasColumns = false;

            public SQLNamingContext(SQLNamingContext parent) {
                this.parent = parent;
            }

            public String getElementName(Expression symbol) {
                String name;
                if (!(symbol instanceof ElementSymbol)) {
                    return null;
                }
                ElementSymbol element = (ElementSymbol)symbol;
                String newGroupName = this.groupNames.get(element.getGroupSymbol().getName());
                if (newGroupName == null) {
                    if (this.parent == null) {
                        return null;
                    }
                    return this.parent.getElementName(symbol);
                }
                Map<String, String> elements = this.elementMap.get(element.getGroupSymbol().getName());
                if (elements != null && (name = elements.get(element.getShortName())) != null) {
                    this.renameGroup(element.getGroupSymbol(), newGroupName);
                    return name;
                }
                if (this.parent != null && (name = this.parent.getElementName(symbol)) != null) {
                    return name;
                }
                this.renameGroup(element.getGroupSymbol(), newGroupName);
                return null;
            }

            public void renameGroup(GroupSymbol obj, String newAlias) {
                if (NamingVisitor.this.aliasGroups) {
                    String definition = obj.getNonCorrelationName();
                    if (newAlias == null) {
                        return;
                    }
                    obj.setName(newAlias);
                    obj.setDefinition(definition);
                } else if (obj.getDefinition() != null) {
                    obj.setName(obj.getDefinition());
                    obj.setDefinition(null);
                } else {
                    obj.setOutputName(null);
                    obj.setOutputDefinition(null);
                }
            }

            private String getGroupName(String group) {
                String groupName = this.groupNames.get(group);
                if (groupName == null) {
                    if (this.parent == null) {
                        return null;
                    }
                    return this.parent.getGroupName(group);
                }
                return groupName;
            }
        }
    }
}

