/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.List;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.JoinStrategy;
import org.teiid.query.processor.relational.SourceState;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.Constant;

public class MergeJoinStrategy
extends JoinStrategy {
    private MergeState mergeState = MergeState.SCAN;
    private ScanState leftScanState = ScanState.READ;
    private ScanState rightScanState = ScanState.READ;
    private MatchState matchState = MatchState.MATCH_LEFT;
    private LoopState loopState = LoopState.EVALUATE_CRITERIA;
    private SourceState outerState;
    private SourceState innerState;
    private boolean outerMatched;
    protected SortOption sortLeft;
    protected SortOption sortRight;
    private boolean grouping;
    protected SortOption processingSortLeft;
    protected SortOption processingSortRight;

    public MergeJoinStrategy(SortOption sortLeft, SortOption sortRight, boolean grouping) {
        if (sortLeft == null) {
            sortLeft = SortOption.ALREADY_SORTED;
        }
        if (sortRight == null) {
            sortRight = SortOption.ALREADY_SORTED;
        }
        this.sortLeft = sortLeft;
        this.sortRight = sortRight;
        this.grouping = grouping;
    }

    @Override
    public MergeJoinStrategy clone() {
        return new MergeJoinStrategy(this.sortLeft, this.sortRight, this.grouping);
    }

    @Override
    public void initialize(JoinNode joinNode) {
        super.initialize(joinNode);
        this.resetMatchState();
        this.processingSortRight = this.sortRight;
        this.processingSortLeft = this.sortLeft;
    }

    protected void resetMatchState() {
        this.outerState = this.leftSource;
        this.innerState = this.rightSource;
        this.mergeState = MergeState.SCAN;
        this.matchState = MatchState.MATCH_LEFT;
        this.loopState = LoopState.EVALUATE_CRITERIA;
        this.leftScanState = ScanState.READ;
        this.rightScanState = ScanState.READ;
        this.outerMatched = false;
    }

    @Override
    public void close() {
        super.close();
        this.outerState = null;
        this.innerState = null;
    }

    @Override
    protected void process() throws TeiidComponentException, TeiidProcessingException {
        block0: while (this.mergeState != MergeState.DONE) {
            while (this.mergeState == MergeState.SCAN) {
                if (this.leftScanState == ScanState.READ) {
                    if (this.leftSource.getIterator().hasNext()) {
                        this.leftSource.getIterator().mark();
                        this.leftSource.saveNext();
                        this.leftScanState = ScanState.KEEP;
                    } else {
                        this.leftScanState = ScanState.DONE;
                        if (this.joinNode.getJoinType() != JoinType.JOIN_FULL_OUTER) {
                            this.mergeState = MergeState.DONE;
                            return;
                        }
                    }
                }
                if (this.rightScanState == ScanState.READ) {
                    if (this.rightSource.getIterator().hasNext()) {
                        this.rightSource.getIterator().mark();
                        this.rightSource.saveNext();
                        this.rightScanState = ScanState.KEEP;
                    } else {
                        this.rightScanState = ScanState.DONE;
                        if (!this.joinNode.getJoinType().isOuter()) {
                            this.mergeState = MergeState.DONE;
                            return;
                        }
                    }
                }
                int result = 0;
                if (this.leftScanState == ScanState.DONE) {
                    if (this.rightScanState == ScanState.DONE) {
                        this.mergeState = MergeState.DONE;
                        return;
                    }
                    result = -1;
                } else {
                    result = this.rightScanState == ScanState.DONE ? 1 : this.compare(this.leftSource.getCurrentTuple(), this.rightSource.getCurrentTuple(), this.leftSource.getExpressionIndexes(), this.rightSource.getExpressionIndexes());
                }
                if (result == 0) {
                    this.mergeState = MergeState.MATCH;
                    this.loopState = LoopState.EVALUATE_CRITERIA;
                    this.leftScanState = ScanState.READ;
                    this.rightScanState = ScanState.READ;
                    break;
                }
                if (result > 0) {
                    this.leftScanState = ScanState.READ;
                    if (!this.joinNode.getJoinType().isOuter()) continue;
                    this.joinNode.addBatchRow(this.outputTuple(this.leftSource.getCurrentTuple(), this.rightSource.getOuterVals()));
                    continue;
                }
                this.rightScanState = ScanState.READ;
                if (this.joinNode.getJoinType() != JoinType.JOIN_FULL_OUTER) continue;
                this.joinNode.addBatchRow(this.outputTuple(this.leftSource.getOuterVals(), this.rightSource.getCurrentTuple()));
            }
            while (this.mergeState == MergeState.MATCH) {
                if (this.loopState == LoopState.LOAD_OUTER) {
                    if (this.compareToPrevious(this.outerState)) {
                        this.outerMatched = false;
                        this.innerState.reset();
                        this.loopState = LoopState.LOAD_INNER;
                    } else {
                        if (this.matchState == MatchState.MATCH_LEFT && this.joinNode.getJoinType() == JoinType.JOIN_FULL_OUTER) {
                            this.matchState = MatchState.MATCH_RIGHT;
                            this.outerState = this.rightSource;
                            this.innerState = this.leftSource;
                            this.outerState.reset();
                            continue;
                        }
                        this.outerState = this.leftSource;
                        this.innerState = this.rightSource;
                        this.outerMatched = false;
                        this.leftSource.setMaxProbePosition();
                        this.rightSource.setMaxProbePosition();
                        this.mergeState = MergeState.SCAN;
                        this.matchState = MatchState.MATCH_LEFT;
                        continue block0;
                    }
                }
                while (this.loopState == LoopState.LOAD_INNER || this.loopState == LoopState.EVALUATE_CRITERIA) {
                    if (this.loopState == LoopState.LOAD_INNER) {
                        if (!this.compareToPrevious(this.innerState)) {
                            this.loopState = LoopState.LOAD_OUTER;
                            break;
                        }
                        this.loopState = LoopState.EVALUATE_CRITERIA;
                    }
                    if (this.loopState != LoopState.EVALUATE_CRITERIA) continue;
                    List outputTuple = this.outputTuple(this.leftSource.getCurrentTuple(), this.rightSource.getCurrentTuple());
                    boolean match = this.joinNode.matchesCriteria(outputTuple);
                    this.loopState = LoopState.LOAD_INNER;
                    if (!match) continue;
                    this.outerMatched = true;
                    if (this.matchState == MatchState.MATCH_LEFT && this.joinNode.getJoinType() != JoinType.JOIN_ANTI_SEMI) {
                        if (this.joinNode.getJoinType() == JoinType.JOIN_SEMI) {
                            this.loopState = LoopState.LOAD_OUTER;
                        }
                        this.joinNode.addBatchRow(outputTuple);
                        continue;
                    }
                    this.loopState = LoopState.LOAD_OUTER;
                    break;
                }
                if (this.outerMatched) continue;
                if (this.matchState == MatchState.MATCH_RIGHT) {
                    this.joinNode.addBatchRow(this.outputTuple(this.leftSource.getOuterVals(), this.rightSource.getCurrentTuple()));
                    continue;
                }
                if (!this.joinNode.getJoinType().isOuter()) continue;
                this.joinNode.addBatchRow(this.outputTuple(this.leftSource.getCurrentTuple(), this.rightSource.getOuterVals()));
            }
        }
    }

    protected boolean compareToPrevious(SourceState target) throws TeiidComponentException, TeiidProcessingException {
        if (!target.getIterator().hasNext()) {
            target.setMaxProbeMatch(target.getIterator().getCurrentIndex());
            return false;
        }
        List previousTuple = target.getCurrentTuple();
        target.saveNext();
        if (target.getMaxProbeMatch() >= target.getIterator().getCurrentIndex()) {
            return true;
        }
        if (previousTuple != null) {
            int compare = 1;
            if (!target.isDistinct()) {
                compare = this.compare(previousTuple, target.getCurrentTuple(), target.getExpressionIndexes(), target.getExpressionIndexes());
            }
            if (compare != 0) {
                target.setMaxProbeMatch(target.getIterator().getCurrentIndex() - 1);
                return false;
            }
        }
        target.setMaxProbeMatch(target.getIterator().getCurrentIndex());
        return true;
    }

    protected int compare(List leftProbe, List rightProbe, int[] leftExpressionIndecies, int[] rightExpressionIndecies) {
        return MergeJoinStrategy.compareTuples(leftProbe, rightProbe, leftExpressionIndecies, rightExpressionIndecies, this.grouping);
    }

    public static int compareTuples(List<?> leftProbe, List<?> rightProbe, int[] leftExpressionIndecies, int[] rightExpressionIndecies, boolean nullEquals) {
        for (int i = 0; i < leftExpressionIndecies.length; ++i) {
            Object leftValue = leftProbe.get(leftExpressionIndecies[i]);
            Object rightValue = rightProbe.get(rightExpressionIndecies[i]);
            if (rightValue == null) {
                if (nullEquals && leftValue == null) continue;
                return -1;
            }
            if (leftValue == null) {
                return 1;
            }
            int c = Constant.COMPARATOR.compare(rightValue, leftValue);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    protected void loadLeft() throws TeiidComponentException, TeiidProcessingException {
        this.leftSource.sort(this.processingSortLeft);
    }

    @Override
    protected void loadRight() throws TeiidComponentException, TeiidProcessingException {
        if (this.joinNode.getJoinType() != JoinType.JOIN_FULL_OUTER) {
            this.rightSource.setImplicitBuffer(SourceState.ImplicitBuffer.ON_MARK);
        }
        this.rightSource.sort(this.processingSortRight);
    }

    public void setProcessingSortRight(boolean processingSortRight) {
        if (processingSortRight && this.processingSortRight == SortOption.ALREADY_SORTED) {
            this.processingSortRight = SortOption.SORT;
        }
    }

    public String getName() {
        return "MERGE JOIN";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        return sb.append(this.getName()).append(" (").append((Object)this.sortLeft).append("/").append((Object)this.sortRight).append(")").toString();
    }

    public static enum SortOption {
        ALREADY_SORTED,
        SORT,
        SORT_DISTINCT,
        NOT_SORTED;

    }

    private static enum LoopState {
        LOAD_OUTER,
        LOAD_INNER,
        EVALUATE_CRITERIA;

    }

    private static enum MatchState {
        MATCH_LEFT,
        MATCH_RIGHT;

    }

    private static enum ScanState {
        READ,
        KEEP,
        DONE;

    }

    private static enum MergeState {
        SCAN,
        MATCH,
        DONE;

    }
}

