/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.language.SortSpecification;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.relational.ListNestedSortComparator;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.symbol.Expression;

public class SortUtility {
    private TupleSource source;
    private Mode mode;
    private BufferManager bufferManager;
    private String groupName;
    private List<? extends Expression> schema;
    private int schemaSize;
    private int batchSize;
    private ListNestedSortComparator comparator;
    private int targetRowCount;
    private TupleBuffer output;
    private boolean doneReading;
    private int phase = 1;
    private List<TupleBuffer> activeTupleBuffers = new ArrayList<TupleBuffer>();
    private int masterSortIndex;
    private int processed;
    private static final int INITIAL_SORT = 1;
    private static final int MERGE = 2;
    private static final int DONE = 3;
    private TupleBuffer workingBuffer;
    private long[] attempts = new long[2];
    private boolean nonBlocking;

    public SortUtility(TupleSource sourceID, List<OrderByItem> items, Mode mode, BufferManager bufferMgr, String groupName, List<? extends Expression> schema) {
        List<? extends Expression> sortElements = null;
        List<Boolean> sortTypes = null;
        ArrayList<SortSpecification.NullOrdering> nullOrderings = null;
        int distinctIndex = -1;
        if (items == null) {
            sortElements = schema;
            sortTypes = Collections.nCopies(sortElements.size(), true);
        } else {
            sortElements = new ArrayList<Expression>(items.size());
            sortTypes = new ArrayList<Boolean>(items.size());
            nullOrderings = new ArrayList<SortSpecification.NullOrdering>(items.size());
            for (OrderByItem orderByItem : items) {
                sortElements.add(orderByItem.getSymbol());
                sortTypes.add(orderByItem.isAscending());
                nullOrderings.add(orderByItem.getNullOrdering());
            }
            if (items.size() < schema.size() && mode == Mode.DUP_REMOVE_SORT) {
                ArrayList<? extends Expression> toAdd = new ArrayList<Expression>(schema);
                toAdd.removeAll(sortElements);
                sortElements.addAll(toAdd);
                sortTypes.addAll(Collections.nCopies(sortElements.size() - sortTypes.size(), true));
                nullOrderings.addAll(Collections.nCopies(sortElements.size() - nullOrderings.size(), null));
                distinctIndex = items.size() - 1;
            }
        }
        int[] cols = new int[sortElements.size()];
        ListIterator<? extends Expression> iter = sortElements.listIterator();
        while (iter.hasNext()) {
            Expression elem = iter.next();
            cols[iter.previousIndex()] = schema.indexOf(elem);
            Assertion.assertTrue((cols[iter.previousIndex()] != -1 ? 1 : 0) != 0);
        }
        this.init(sourceID, mode, bufferMgr, groupName, schema, sortTypes, nullOrderings, cols);
        if (distinctIndex != -1) {
            this.comparator.setDistinctIndex(distinctIndex);
        }
    }

    public SortUtility(TupleSource sourceID, Mode mode, BufferManager bufferMgr, String groupName, List<? extends Expression> schema, List<Boolean> sortTypes, List<SortSpecification.NullOrdering> nullOrderings, int[] cols) {
        this.init(sourceID, mode, bufferMgr, groupName, schema, sortTypes, nullOrderings, cols);
    }

    private void init(TupleSource sourceID, Mode mode, BufferManager bufferMgr, String groupName, List<? extends Expression> schema, List<Boolean> sortTypes, List<SortSpecification.NullOrdering> nullOrderings, int[] cols) {
        this.source = sourceID;
        this.mode = mode;
        this.bufferManager = bufferMgr;
        this.groupName = groupName;
        this.schema = schema;
        this.schemaSize = this.bufferManager.getSchemaSize(this.schema);
        this.batchSize = this.bufferManager.getProcessorBatchSize(this.schema);
        this.targetRowCount = Math.max(this.bufferManager.getMaxProcessingSize() / this.schemaSize, 2) * this.batchSize;
        this.comparator = new ListNestedSortComparator(cols, sortTypes);
        int distinctIndex = cols.length - 1;
        this.comparator.setDistinctIndex(distinctIndex);
        this.comparator.setNullOrdering(nullOrderings);
    }

    public SortUtility(TupleSource ts, List<? extends Expression> expressions, List<Boolean> types, Mode mode, BufferManager bufferManager, String connectionID, List schema) {
        this(ts, new OrderBy(expressions, types).getOrderByItems(), mode, bufferManager, connectionID, schema);
    }

    public TupleBuffer sort() throws TeiidComponentException, TeiidProcessingException {
        boolean success = false;
        try {
            if (this.phase == 1) {
                this.initialSort(false);
            }
            if (this.phase == 2) {
                this.mergePhase();
            }
            success = true;
            if (this.output != null) {
                TupleBuffer tupleBuffer = this.output;
                return tupleBuffer;
            }
            TupleBuffer tupleBuffer = this.activeTupleBuffers.get(0);
            return tupleBuffer;
        }
        catch (BlockedException e) {
            success = true;
            throw e;
        }
        finally {
            if (!success) {
                this.remove();
            }
        }
    }

    public List<TupleBuffer> onePassSort() throws TeiidComponentException, TeiidProcessingException {
        boolean success = false;
        assert (this.mode != Mode.DUP_REMOVE);
        try {
            if (this.phase == 1) {
                this.initialSort(true);
            }
            for (TupleBuffer tb : this.activeTupleBuffers) {
                tb.close();
            }
            success = true;
            List<TupleBuffer> i$ = this.activeTupleBuffers;
            return i$;
        }
        catch (BlockedException e) {
            success = true;
            throw e;
        }
        finally {
            if (!success) {
                this.remove();
            }
        }
    }

    private TupleBuffer createTupleBuffer() throws TeiidComponentException {
        TupleBuffer tb = this.bufferManager.createTupleBuffer(this.schema, this.groupName, BufferManager.TupleSourceType.PROCESSOR);
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Created intermediate sort buffer", tb});
        }
        tb.setForwardOnly(true);
        return tb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialSort(boolean onePass) throws TeiidComponentException, TeiidProcessingException {
        block27: {
            block7: while (!this.doneReading) {
                if (this.source != null) {
                    if (this.workingBuffer == null) {
                        this.workingBuffer = this.createTupleBuffer();
                    }
                    while (!this.doneReading) {
                        try {
                            List<?> tuple = this.source.nextTuple();
                            if (tuple == null) {
                                this.doneReading = true;
                                continue block7;
                            }
                            this.workingBuffer.addTuple(tuple);
                        }
                        catch (BlockedException e) {
                            if (!onePass && this.mode != Mode.DUP_REMOVE) {
                                throw e;
                            }
                            if (!(!onePass ? this.output != null && this.workingBuffer.getRowCount() < 2 * this.processed : this.workingBuffer.getRowCount() < this.targetRowCount)) break block7;
                            throw e;
                        }
                    }
                    continue;
                }
                this.doneReading = true;
            }
            int totalReservedBuffers = 0;
            try {
                int maxRows = this.batchSize;
                AbstractCollection workingTuples = null;
                boolean done = false;
                this.workingBuffer.close();
                this.schemaSize = Math.max(1, this.workingBuffer.getRowSizeEstimate() * this.batchSize);
                long memorySpaceNeeded = (long)this.workingBuffer.getRowCount() * (long)this.workingBuffer.getRowSizeEstimate();
                if (onePass) {
                    memorySpaceNeeded = Math.min(memorySpaceNeeded, (long)this.bufferManager.getMaxProcessingSize());
                }
                if ((long)(totalReservedBuffers = this.bufferManager.reserveBuffers(Math.min(this.bufferManager.getMaxProcessingSize(), (int)Math.min(memorySpaceNeeded, Integer.MAX_VALUE)), BufferManager.BufferReserveMode.FORCE)) != memorySpaceNeeded) {
                    int processingSublists = Math.max(2, this.bufferManager.getMaxProcessingSize() / this.schemaSize);
                    int desiredSpace = (int)Math.min(Integer.MAX_VALUE, (long)(this.workingBuffer.getRowCount() / processingSublists + this.workingBuffer.getRowCount() % processingSublists) * (long)this.workingBuffer.getRowSizeEstimate());
                    if (desiredSpace > totalReservedBuffers) {
                        totalReservedBuffers += this.bufferManager.reserveBuffers(desiredSpace - totalReservedBuffers, BufferManager.BufferReserveMode.NO_WAIT);
                    } else if (memorySpaceNeeded <= Integer.MAX_VALUE) {
                        totalReservedBuffers += this.bufferManager.reserveBuffers((int)memorySpaceNeeded - totalReservedBuffers, BufferManager.BufferReserveMode.NO_WAIT);
                    }
                    if (totalReservedBuffers > this.schemaSize) {
                        int additional = totalReservedBuffers % this.schemaSize;
                        totalReservedBuffers -= additional;
                        this.bufferManager.releaseBuffers(additional);
                    }
                }
                TupleBuffer.TupleBufferTupleSource ts = this.workingBuffer.createIndexedTupleSource(this.source != null);
                ts.setReverse(this.workingBuffer.getRowCount() > this.batchSize);
                this.processed += this.workingBuffer.getRowCount();
                maxRows = Math.max(1, totalReservedBuffers / this.schemaSize) * this.batchSize;
                workingTuples = this.mode == Mode.SORT ? new ArrayList() : new TreeSet(this.comparator);
                while (!done) {
                    while (!done && workingTuples.size() < maxRows) {
                        List<?> tuple = ts.nextTuple();
                        if (tuple == null) {
                            done = true;
                            if (!workingTuples.isEmpty()) break;
                            break block27;
                        }
                        workingTuples.add(tuple);
                    }
                    TupleBuffer sublist = this.createTupleBuffer();
                    this.activeTupleBuffers.add(sublist);
                    if (this.mode == Mode.SORT) {
                        Collections.sort((List)((Object)workingTuples), this.comparator);
                    }
                    for (List list : workingTuples) {
                        sublist.addTuple(list);
                    }
                    workingTuples.clear();
                    sublist.saveBatch();
                }
            }
            catch (BlockedException e) {
                Assertion.failed((String)"should not block during memory sublist sorting");
            }
            finally {
                this.bufferManager.releaseBuffers(totalReservedBuffers);
                if (this.workingBuffer != null) {
                    if (this.source != null) {
                        this.workingBuffer.remove();
                    }
                    this.workingBuffer = null;
                }
            }
        }
        if (this.activeTupleBuffers.isEmpty()) {
            this.activeTupleBuffers.add(this.createTupleBuffer());
        }
        this.phase = 2;
    }

    public void setWorkingBuffer(TupleBuffer workingBuffer) {
        this.workingBuffer = workingBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergePhase() throws TeiidComponentException, TeiidProcessingException {
        int total;
        int reserved;
        int toForce;
        long desiredSpace;
        block26: {
            desiredSpace = (long)this.activeTupleBuffers.size() * (long)this.schemaSize;
            toForce = (int)Math.min(desiredSpace, (long)Math.max(2 * this.schemaSize, this.bufferManager.getMaxProcessingSize()));
            reserved = 0;
            if (desiredSpace > (long)toForce) {
                try {
                    int subLists = Math.max(2, this.bufferManager.getMaxProcessingSize() / this.schemaSize);
                    int twoPass = subLists * subLists;
                    if (twoPass < this.activeTupleBuffers.size()) {
                        int needed;
                        for (needed = (int)Math.ceil(Math.pow(this.activeTupleBuffers.size(), 0.5)); this.activeTupleBuffers.size() / needed + this.activeTupleBuffers.size() % needed > needed; ++needed) {
                        }
                        if ((reserved += this.bufferManager.reserveBuffersBlocking(needed * this.schemaSize - toForce, this.attempts, false)) == 0 && twoPass * subLists < this.activeTupleBuffers.size()) {
                            for (needed = (int)Math.ceil(Math.pow(this.activeTupleBuffers.size(), 0.3333333333333333)); this.activeTupleBuffers.size() / (needed * needed) + this.activeTupleBuffers.size() % needed > needed; ++needed) {
                            }
                            reserved += this.bufferManager.reserveBuffersBlocking(needed * this.schemaSize - toForce, this.attempts, true);
                        }
                    } else if (desiredSpace < Integer.MAX_VALUE) {
                        reserved += this.bufferManager.reserveBuffersBlocking((int)desiredSpace - toForce, this.attempts, false);
                    }
                }
                catch (BlockedException be) {
                    if (this.nonBlocking) break block26;
                    throw be;
                }
            }
        }
        if ((total = reserved + toForce) > this.schemaSize) {
            toForce -= total % this.schemaSize;
        }
        reserved += this.bufferManager.reserveBuffers(toForce, BufferManager.BufferReserveMode.FORCE);
        try {
            while (this.activeTupleBuffers.size() > 1) {
                int i;
                ArrayList<SortedSublist> sublists = new ArrayList<SortedSublist>(this.activeTupleBuffers.size());
                TupleBuffer merged = this.createTupleBuffer();
                desiredSpace = (long)this.activeTupleBuffers.size() * (long)this.schemaSize;
                if (desiredSpace < (long)reserved) {
                    this.bufferManager.releaseBuffers(reserved - (int)desiredSpace);
                    reserved = (int)desiredSpace;
                }
                int maxSortIndex = Math.max(2, reserved / this.schemaSize);
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)6)) {
                    LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Merging", maxSortIndex, "sublists out of", this.activeTupleBuffers.size()});
                }
                for (i = 0; i < maxSortIndex; ++i) {
                    TupleBuffer activeID = this.activeTupleBuffers.get(i);
                    SortedSublist sortedSublist = new SortedSublist();
                    sortedSublist.its = activeID.createIndexedTupleSource();
                    sortedSublist.its.setNoBlocking(true);
                    sortedSublist.index = i;
                    if (activeID == this.output) {
                        sortedSublist.limit = this.output.getRowCount();
                    }
                    this.incrementWorkingTuple(sublists, sortedSublist);
                }
                while (sublists.size() > 0) {
                    SortedSublist sortedSublist = (SortedSublist)sublists.remove(sublists.size() - 1);
                    merged.addTuple(sortedSublist.tuple);
                    if (this.output != null && this.masterSortIndex < maxSortIndex && sortedSublist.index != this.masterSortIndex) {
                        this.output.addTuple(sortedSublist.tuple);
                    }
                    this.incrementWorkingTuple(sublists, sortedSublist);
                }
                for (i = 0; i < maxSortIndex; ++i) {
                    TupleBuffer id = this.activeTupleBuffers.remove(0);
                    if (id == this.output) continue;
                    id.remove();
                }
                merged.saveBatch();
                this.activeTupleBuffers.add(merged);
                this.masterSortIndex -= maxSortIndex;
                if (this.masterSortIndex >= 0) continue;
                this.masterSortIndex = this.activeTupleBuffers.size() - 1;
            }
        }
        finally {
            this.bufferManager.releaseBuffers(reserved);
        }
        if (this.doneReading) {
            if (this.output != null) {
                this.output.close();
                TupleBuffer last = this.activeTupleBuffers.remove(0);
                if (this.output != last) {
                    last.remove();
                }
            } else {
                this.activeTupleBuffers.get(0).close();
                this.activeTupleBuffers.get(0).setForwardOnly(false);
            }
            this.phase = 3;
            return;
        }
        Assertion.assertTrue((this.mode == Mode.DUP_REMOVE ? 1 : 0) != 0);
        if (this.output == null) {
            this.output = this.activeTupleBuffers.get(0);
            this.output.setForwardOnly(false);
        }
        this.phase = 1;
    }

    private void incrementWorkingTuple(ArrayList<SortedSublist> subLists, SortedSublist sortedSublist) throws TeiidComponentException, TeiidProcessingException {
        while (true) {
            sortedSublist.tuple = null;
            if (sortedSublist.limit < sortedSublist.its.getCurrentIndex()) {
                return;
            }
            sortedSublist.tuple = sortedSublist.its.nextTuple();
            if (sortedSublist.tuple == null) {
                return;
            }
            int index = Collections.binarySearch(subLists, sortedSublist);
            if (index < 0) {
                subLists.add(-index - 1, sortedSublist);
                return;
            }
            if (this.mode == Mode.SORT) {
                subLists.add(index, sortedSublist);
                return;
            }
            if (this.mode != Mode.DUP_REMOVE || this.output == null || sortedSublist.index != this.masterSortIndex) continue;
            SortedSublist dup = subLists.get(index);
            subLists.set(index, sortedSublist);
            sortedSublist = dup;
        }
    }

    public boolean isDistinct() {
        return this.comparator.isDistinct();
    }

    public void remove() {
        if (this.workingBuffer != null && this.source != null) {
            this.workingBuffer.remove();
            this.workingBuffer = null;
        }
        if (!this.activeTupleBuffers.isEmpty()) {
            for (int i = 0; i < this.activeTupleBuffers.size(); ++i) {
                TupleBuffer tb = this.activeTupleBuffers.get(i);
                if (tb == this.output || i == 0 && this.phase == 3) continue;
                tb.remove();
            }
            this.activeTupleBuffers.clear();
        }
        this.output = null;
    }

    public void setNonBlocking(boolean b) {
        this.nonBlocking = b;
    }

    private class SortedSublist
    implements Comparable<SortedSublist> {
        List<?> tuple;
        int index;
        TupleBuffer.TupleBufferTupleSource its;
        int limit = Integer.MAX_VALUE;

        private SortedSublist() {
        }

        @Override
        public int compareTo(SortedSublist o) {
            return -SortUtility.this.comparator.compare(this.tuple, o.tuple);
        }

        public String toString() {
            return this.index + " " + this.tuple;
        }
    }

    public static enum Mode {
        SORT,
        DUP_REMOVE,
        DUP_REMOVE_SORT;

    }
}

