/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class JSONObject
implements Expression {
    private List<DerivedColumn> args;

    public JSONObject(List<DerivedColumn> args) {
        this.args = args;
    }

    public List<DerivedColumn> getArgs() {
        return this.args;
    }

    @Override
    public Class<?> getType() {
        return DataTypeManager.DefaultDataClasses.CLOB;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public JSONObject clone() {
        JSONObject clone = new JSONObject(LanguageObject.Util.deepClone(this.args, DerivedColumn.class));
        return clone;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)this.args.hashCode(), (Object[])new Object[0]);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JSONObject)) {
            return false;
        }
        JSONObject other = (JSONObject)obj;
        return this.args.equals(other.args);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

