/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class TextLine
implements Expression {
    public static final String nl = System.getProperty("line.separator");
    private Character delimiter;
    private Character quote;
    private boolean includeHeader;
    private List<DerivedColumn> expressions;
    private String encoding;
    private String lineEnding = nl;

    public Character getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Character getQuote() {
        return this.quote;
    }

    public void setQuote(Character quote) {
        this.quote = quote;
    }

    public boolean isIncludeHeader() {
        return this.includeHeader;
    }

    public void setIncludeHeader(boolean includeHeader) {
        this.includeHeader = includeHeader;
    }

    public List<DerivedColumn> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<DerivedColumn> expressions) {
        this.expressions = expressions;
    }

    public String getLineEnding() {
        return this.lineEnding;
    }

    public void setLineEnding(String lineEnding) {
        this.lineEnding = lineEnding;
    }

    @Override
    public Class<?> getType() {
        return String[].class;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public TextLine clone() {
        TextLine clone = new TextLine();
        clone.expressions = LanguageObject.Util.deepClone(this.expressions, DerivedColumn.class);
        clone.delimiter = this.delimiter;
        clone.quote = this.quote;
        clone.includeHeader = this.includeHeader;
        clone.encoding = this.encoding;
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TextLine)) {
            return false;
        }
        TextLine other = (TextLine)obj;
        return EquivalenceUtil.areEqual(this.expressions, other.expressions) && EquivalenceUtil.areEqual((Object)this.delimiter, (Object)other.delimiter) && EquivalenceUtil.areEqual((Object)this.quote, (Object)other.quote) && this.includeHeader == other.includeHeader && EquivalenceUtil.areEqual((Object)this.encoding, (Object)other.encoding);
    }

    public int hashCode() {
        return HashCodeUtil.expHashCode((int)0, this.expressions);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public static <T> String[] evaluate(List<T> values, ValueExtractor<T> valueExtractor, TextLine textLine) throws TransformationException {
        Character delimeter = textLine.getDelimiter();
        if (delimeter == null) {
            delimeter = Character.valueOf(',');
        }
        String delim = String.valueOf(delimeter.charValue());
        Character quote = textLine.getQuote();
        String quoteStr = null;
        quoteStr = quote == null ? "\"" : String.valueOf(quote);
        String doubleQuote = quoteStr + quoteStr;
        ArrayList<String> result = new ArrayList<String>();
        Iterator<T> iterator = values.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            String text = (String)DataTypeManager.transformValue((Object)valueExtractor.getValue(t), (Class)DataTypeManager.DefaultDataClasses.STRING);
            if (text == null) continue;
            result.add(quoteStr);
            result.add(StringUtil.replaceAll((String)text, (String)quoteStr, (String)doubleQuote));
            result.add(quoteStr);
            if (!iterator.hasNext()) continue;
            result.add(delim);
        }
        result.add(textLine.getLineEnding());
        return result.toArray(new String[result.size()]);
    }

    public static interface ValueExtractor<T> {
        public Object getValue(T var1);
    }
}

