/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;

public class ElementCollectorVisitor
extends LanguageVisitor {
    private Collection<? super ElementSymbol> elements;
    private boolean aggsOnly;

    public ElementCollectorVisitor(Collection<? super ElementSymbol> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0021"));
        }
        this.elements = elements;
    }

    @Override
    public void visit(ElementSymbol obj) {
        if (!this.aggsOnly || obj.isAggregate()) {
            this.elements.add(obj);
        }
    }

    @Override
    public void visit(MultipleElementSymbol obj) {
        List<ElementSymbol> elementSymbols = obj.getElementSymbols();
        if (elementSymbols != null) {
            for (int i = 0; i < elementSymbols.size(); ++i) {
                this.visit(elementSymbols.get(i));
            }
        }
    }

    public static final void getElements(LanguageObject obj, Collection<? super ElementSymbol> elements) {
        if (obj == null) {
            return;
        }
        ElementCollectorVisitor visitor = new ElementCollectorVisitor(elements);
        PreOrderNavigator.doVisit(obj, visitor);
    }

    public static final void getElements(Collection<? extends LanguageObject> objs, Collection<ElementSymbol> elements) {
        if (objs == null) {
            return;
        }
        ElementCollectorVisitor visitor = new ElementCollectorVisitor(elements);
        for (LanguageObject languageObject : objs) {
            PreOrderNavigator.doVisit(languageObject, visitor);
        }
    }

    public static final Collection<ElementSymbol> getElements(LanguageObject obj, boolean removeDuplicates) {
        return ElementCollectorVisitor.getElements(obj, removeDuplicates, false);
    }

    public static final Collection<ElementSymbol> getElements(LanguageObject obj, boolean removeDuplicates, boolean useDeepIteration) {
        return ElementCollectorVisitor.getElements(obj, removeDuplicates, useDeepIteration, false);
    }

    public static final Collection<ElementSymbol> getElements(LanguageObject obj, boolean removeDuplicates, boolean useDeepIteration, boolean aggsOnly) {
        if (obj == null) {
            return Collections.emptyList();
        }
        AbstractCollection elements = null;
        elements = removeDuplicates ? new LinkedHashSet() : new ArrayList();
        ElementCollectorVisitor visitor = new ElementCollectorVisitor(elements);
        visitor.aggsOnly = aggsOnly;
        if (useDeepIteration) {
            DeepPreOrderNavigator.doVisit(obj, visitor);
        } else {
            PreOrderNavigator.doVisit(obj, visitor);
        }
        return elements;
    }

    public static final Collection<ElementSymbol> getAggregates(LanguageObject obj, boolean removeDuplicates) {
        return ElementCollectorVisitor.getElements(obj, removeDuplicates, false, true);
    }
}

