/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.impl.CommandCandidatesProvider;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.parsing.command.CommandFormat;
import org.jboss.as.cli.parsing.operation.OperationFormat;

public class CommandCompleter
implements CommandLineCompleter {
    private final CommandRegistry cmdRegistry;
    private final CommandCandidatesProvider cmdProvider;

    public CommandCompleter(CommandRegistry cmdRegistry) {
        if (cmdRegistry == null) {
            throw new IllegalArgumentException("Command registry can't be null.");
        }
        this.cmdRegistry = cmdRegistry;
        this.cmdProvider = new CommandCandidatesProvider(cmdRegistry);
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        DefaultCallbackHandler parsedCmd;
        int offset;
        block6: {
            offset = 0;
            if (ctx.getArgumentsString() != null) {
                offset = ctx.getArgumentsString().length();
                buffer = ctx.getArgumentsString() + buffer;
            }
            if (buffer.isEmpty()) {
                for (String cmd : this.cmdRegistry.getTabCompletionCommands()) {
                    CommandHandler handler = this.cmdRegistry.getCommandHandler(cmd);
                    if (!handler.isAvailable(ctx)) continue;
                    candidates.add(cmd);
                }
                Collections.sort(candidates);
                candidates.add(OperationFormat.INSTANCE.getAddressOperationSeparator());
                return 0;
            }
            parsedCmd = (DefaultCallbackHandler)ctx.getParsedCommandLine();
            try {
                parsedCmd.parse(ctx.getCurrentNodePath(), buffer, false);
            }
            catch (CommandFormatException e) {
                if (parsedCmd.endsOnAddressOperationNameSeparator() && parsedCmd.endsOnSeparator()) break block6;
                return -1;
            }
        }
        OperationCandidatesProvider candidatesProvider = buffer.isEmpty() || parsedCmd.getFormat() == CommandFormat.INSTANCE ? this.cmdProvider : ctx.getOperationCandidatesProvider();
        int result = OperationRequestCompleter.INSTANCE.complete(ctx, parsedCmd, candidatesProvider, buffer, cursor, candidates);
        if (result <= 0) {
            return result;
        }
        return result - offset;
    }
}

