/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ldap;

import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.SortKey;
import org.teiid.core.BundleUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.ldap.IQueryToLdapSearchParser;
import org.teiid.translator.ldap.LDAPExecutionFactory;
import org.teiid.translator.ldap.LDAPPlugin;
import org.teiid.translator.ldap.LDAPSearchDetails;

public class LDAPQueryExecution
implements ResultSetExecution {
    private static final String delimiter = "?";
    private LDAPSearchDetails searchDetails;
    private LdapContext ldapCtx;
    private NamingEnumeration<?> searchEnumeration;
    private LDAPExecutionFactory executionFactory;
    private ExecutionContext executionContext;
    private SearchControls ctrls;
    private int resultCount;

    public LDAPQueryExecution(LdapContext ldapContext, LDAPSearchDetails search, SearchControls searchControls, LDAPExecutionFactory factory, ExecutionContext context) {
        this.searchDetails = search;
        this.ldapCtx = ldapContext;
        this.ctrls = searchControls;
        this.executionFactory = factory;
        this.executionContext = context;
    }

    public void execute() throws TranslatorException {
        String ctxName = this.searchDetails.getContextName();
        String filter = this.searchDetails.getContextFilter();
        if (ctxName == null || filter == null || this.ctrls == null) {
            throw new TranslatorException("Search context, filter, or controls were null. Cannot execute search.");
        }
        this.setRequestControls(null);
        this.executeSearch();
    }

    private void setRequestControls(byte[] cookie) throws TranslatorException {
        ArrayList<BasicControl> ctrl = new ArrayList<BasicControl>();
        SortKey[] keys = this.searchDetails.getSortKeys();
        try {
            if (keys != null) {
                ctrl.add(new SortControl(keys, false));
            }
            if (this.executionFactory.usePagination()) {
                ctrl.add(new PagedResultsControl(this.executionContext.getBatchSize(), cookie, true));
            }
            if (!ctrl.isEmpty()) {
                this.ldapCtx.setRequestControls(ctrl.toArray(new Control[ctrl.size()]));
                LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Sort/pagination controls were created successfully."});
            }
        }
        catch (NamingException ne) {
            String msg = LDAPPlugin.Util.getString("LDAPSyncQueryExecution.setControlsError") + " : " + ne.getExplanation();
            throw new TranslatorException((Throwable)ne, msg);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private void executeSearch() throws TranslatorException {
        String filter = this.searchDetails.getContextFilter();
        try {
            this.searchEnumeration = this.ldapCtx.search("", filter, this.ctrls);
        }
        catch (NamingException ne) {
            String msg = LDAPPlugin.Util.getString("LDAPSyncQueryExecution.execSearchError");
            throw new TranslatorException((Throwable)ne, msg + " : " + ne.getExplanation());
        }
        catch (Exception e) {
            String msg = LDAPPlugin.Util.getString("LDAPSyncQueryExecution.execSearchError");
            throw new TranslatorException((Throwable)e, msg);
        }
    }

    public void cancel() throws TranslatorException {
        this.close();
    }

    public void close() {
        if (this.searchEnumeration != null) {
            try {
                this.searchEnumeration.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.ldapCtx != null) {
            try {
                this.ldapCtx.close();
            }
            catch (NamingException ne) {
                LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12003, new Object[]{ne.getExplanation()}));
            }
        }
    }

    public List<?> next() throws TranslatorException {
        try {
            List<?> result = null;
            while (result == null && this.searchEnumeration != null && this.searchEnumeration.hasMore()) {
                SearchResult searchResult = (SearchResult)this.searchEnumeration.next();
                result = this.getRow(searchResult);
            }
            if (result == null && this.executionFactory.usePagination()) {
                byte[] cookie = null;
                Control[] controls = this.ldapCtx.getResponseControls();
                if (controls != null) {
                    for (int i = 0; i < controls.length; ++i) {
                        if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                        PagedResultsResponseControl prrc = (PagedResultsResponseControl)controls[i];
                        cookie = prrc.getCookie();
                    }
                }
                if (cookie == null) {
                    return null;
                }
                this.setRequestControls(cookie);
                this.executeSearch();
                return this.next();
            }
            if (result != null) {
                ++this.resultCount;
            }
            return result;
        }
        catch (SizeLimitExceededException e) {
            if ((long)this.resultCount != this.searchDetails.getCountLimit()) {
                String msg = LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12008, new Object[0]);
                TranslatorException te = new TranslatorException((Throwable)e, msg);
                if (this.executionFactory.isExceptionOnSizeLimitExceeded()) {
                    throw te;
                }
                this.executionContext.addWarning((Exception)te);
                LogManager.logWarning((String)"org.teiid.CONNECTOR", (Throwable)e, (Object)msg);
            }
            return null;
        }
        catch (NamingException ne) {
            throw new TranslatorException((Throwable)ne, LDAPPlugin.Util.gs("ldap_error", new Object[0]));
        }
    }

    private List<?> getRow(SearchResult result) throws TranslatorException {
        Attributes attrs = result.getAttributes();
        String resultDN = result.getNameInNamespace();
        ArrayList<Column> attributeList = this.searchDetails.getElementList();
        ArrayList<Object> row = new ArrayList<Object>(attributeList.size());
        for (Column col : attributeList) {
            this.addResultToRow(col, resultDN, attrs, row);
        }
        return row;
    }

    private void addResultToRow(Column modelElement, String resultDistinguishedName, Attributes attrs, List<Object> row) throws TranslatorException {
        String strResult = null;
        String modelAttrName = IQueryToLdapSearchParser.getNameFromElement(modelElement);
        Class modelAttrClass = modelElement.getJavaType();
        String multivalAttr = modelElement.getDefaultValue();
        if (modelAttrName == null) {
            String msg = LDAPPlugin.Util.getString("LDAPSyncQueryExecution.nullAttrError");
            throw new TranslatorException(msg);
        }
        Attribute resultAttr = attrs.get(modelAttrName);
        if (resultAttr == null) {
            if (modelAttrName.toUpperCase().equals("DN")) {
                row.add(resultDistinguishedName);
            } else {
                row.add(null);
            }
            return;
        }
        Object objResult = null;
        try {
            if (TypeFacility.RUNTIME_TYPES.STRING.equals(modelAttrClass) && "multivalued-concat".equalsIgnoreCase(multivalAttr)) {
                ArrayList<String> multivalList = new ArrayList<String>();
                NamingEnumeration<?> attrNE = resultAttr.getAll();
                int length = 0;
                while (attrNE.hasMore()) {
                    String val = (String)attrNE.next();
                    multivalList.add(val);
                    length += (val == null ? 0 : val.length()) + 1;
                }
                Collections.sort(multivalList);
                StringBuilder multivalSB = new StringBuilder(length);
                Iterator itr = multivalList.iterator();
                while (itr.hasNext()) {
                    multivalSB.append((String)itr.next());
                    if (!itr.hasNext()) continue;
                    multivalSB.append(delimiter);
                }
                row.add(multivalSB.toString());
                return;
            }
            objResult = resultAttr.get();
        }
        catch (NamingException ne) {
            String msg = LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12004, new Object[]{modelAttrName}) + " : " + ne.getExplanation();
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)msg);
            throw new TranslatorException(msg);
        }
        if (objResult instanceof String && (strResult = (String)objResult).equals("")) {
            strResult = null;
        }
        if (TypeFacility.RUNTIME_TYPES.TIMESTAMP.equals(modelAttrClass)) {
            String timestampFormat = modelElement.getFormat();
            if (timestampFormat == null) {
                timestampFormat = "yyyyMMddhhmmss'Z'";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(timestampFormat);
            try {
                if (strResult != null) {
                    Date dateResult = dateFormat.parse(strResult);
                    Timestamp tsResult = new Timestamp(dateResult.getTime());
                    row.add(tsResult);
                }
                row.add(null);
            }
            catch (ParseException pe) {
                throw new TranslatorException((Throwable)pe, LDAPPlugin.Util.getString("LDAPSyncQueryExecution.timestampParseFailed", new Object[]{modelAttrName}));
            }
        } else {
            row.add(strResult);
        }
    }

    LDAPSearchDetails getSearchDetails() {
        return this.searchDetails;
    }
}

