/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.ldap.SortKey;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.translator.ldap.IQueryToLdapSearchParser;

public class LDAPSearchDetails {
    private String contextName;
    private int searchScope;
    private String contextFilter;
    private SortKey[] keys;
    private long limit;
    private ArrayList<Column> elementList;
    private int timeLimit;

    public LDAPSearchDetails(String name, int searchScope, String filter, SortKey[] keys, long limit, ArrayList elementList, int timeLimit) {
        this.contextName = name;
        this.searchScope = searchScope;
        this.contextFilter = filter;
        this.keys = keys;
        this.limit = limit;
        this.elementList = elementList;
        this.timeLimit = timeLimit;
    }

    public String getContextName() {
        return this.contextName;
    }

    public int getSearchScope() {
        return this.searchScope;
    }

    public String getContextFilter() {
        return this.contextFilter;
    }

    public ArrayList<Column> getElementList() {
        return this.elementList;
    }

    public SortKey[] getSortKeys() {
        return this.keys;
    }

    public long getCountLimit() {
        return this.limit;
    }

    public void printDetailsToLog() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Search context: " + this.contextName});
        if (this.searchScope == 2) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Search scope = SUBTREE_SCOPE"});
        } else if (this.searchScope == 0) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Search scope = OBJECT_SCOPE"});
        } else if (this.searchScope == 1) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Search scope = ONELEVEL_SCOPE"});
        }
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Search attributes: "});
        Iterator<Column> itr = this.elementList.iterator();
        int i = 0;
        while (itr.hasNext()) {
            Column attr = itr.next();
            String attrName = IQueryToLdapSearchParser.getNameFromElement(attr);
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Attribute [" + i + "]: " + attrName + " (" + attr.toString() + ")"});
            ++i;
        }
        if (this.contextFilter != null && !this.contextFilter.equals("")) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Where clause was translated into Ldap search filter: " + this.contextFilter});
        }
        if (this.keys != null) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Sort keys: "});
            for (int j = 0; j < this.keys.length; ++j) {
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"\tName: " + this.keys[j].getAttributeID()});
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"\tOrder: "});
                if (this.keys[j].isAscending()) {
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"ASC"});
                    continue;
                }
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"DESC"});
            }
        }
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public String[] getAttributes() {
        ArrayList<String> attributes = new ArrayList<String>();
        for (Column c : this.elementList) {
            attributes.add(c.getName());
        }
        return attributes.toArray(new String[attributes.size()]);
    }
}

