/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ldap;

import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.teiid.core.BundleUtil;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Delete;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.Literal;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.ldap.IQueryToLdapSearchParser;
import org.teiid.translator.ldap.LDAPPlugin;

public class LDAPUpdateExecution
implements UpdateExecution {
    private LdapContext ldapConnection;
    private LdapContext ldapCtx;
    private Command command;

    public LDAPUpdateExecution(Command command, LdapContext ldapCtx) {
        this.ldapConnection = ldapCtx;
        this.command = command;
    }

    public void execute() throws TranslatorException {
        try {
            this.ldapCtx = (LdapContext)this.ldapConnection.lookup("");
        }
        catch (NamingException ne) {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.createContextError", new Object[]{ne.getExplanation()});
            throw new TranslatorException(msg);
        }
        if (this.command instanceof Update) {
            this.executeUpdate();
        } else if (this.command instanceof Delete) {
            this.executeDelete();
        } else if (this.command instanceof Insert) {
            this.executeInsert();
        } else {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.incorrectCommandError");
            throw new TranslatorException(msg);
        }
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return new int[]{1};
    }

    private void executeInsert() throws TranslatorException {
        List insertElementList = ((Insert)this.command).getColumns();
        List insertValueList = ((ExpressionValueSource)((Insert)this.command).getValueSource()).getValues();
        BasicAttributes insertAttrs = new BasicAttributes(true);
        String distinguishedName = null;
        for (int i = 0; i < insertElementList.size(); ++i) {
            Object insertValue;
            ColumnReference insertElement = (ColumnReference)insertElementList.get(i);
            String nameInsertElement = this.getNameFromElement(insertElement);
            if (nameInsertElement.toUpperCase().equals("DN")) {
                insertValue = ((Literal)insertValueList.get(i)).getValue();
                if (insertValue == null) {
                    String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.columnSourceNameDNNullError");
                    throw new TranslatorException(msg);
                }
                if (!(insertValue instanceof String)) {
                    String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.columnSourceNameDNTypeError");
                    throw new TranslatorException(msg);
                }
                distinguishedName = (String)insertValue;
                continue;
            }
            BasicAttribute insertAttr = new BasicAttribute(nameInsertElement);
            insertValue = ((Literal)insertValueList.get(i)).getValue();
            insertAttr.add(insertValue);
            insertAttrs.put(insertAttr);
        }
        if (distinguishedName == null) {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.noInsertSourceNameDNError");
            throw new TranslatorException(msg);
        }
        try {
            this.ldapCtx.createSubcontext(distinguishedName, (Attributes)insertAttrs);
        }
        catch (NamingException ne) {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.insertFailed", new Object[]{distinguishedName, ne.getExplanation()});
            throw new TranslatorException(msg);
        }
        catch (Exception e) {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.insertFailedUnexpected", new Object[]{distinguishedName});
            throw new TranslatorException((Throwable)e, msg);
        }
    }

    private void executeDelete() throws TranslatorException {
        Condition criteria = ((Delete)this.command).getWhere();
        String distinguishedName = this.getDNFromCriteria(criteria);
        try {
            this.ldapCtx.destroySubcontext(distinguishedName);
        }
        catch (NamingException ne) {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.deleteFailed", new Object[]{distinguishedName, ne.getExplanation()});
            throw new TranslatorException(msg);
        }
        catch (Exception e) {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.deleteFailedUnexpected", new Object[]{distinguishedName});
            throw new TranslatorException((Throwable)e, msg);
        }
    }

    private void executeUpdate() throws TranslatorException {
        String msg;
        List updateList = ((Update)this.command).getChanges();
        Condition criteria = ((Update)this.command).getWhere();
        String distinguishedName = this.getDNFromCriteria(criteria);
        ModificationItem[] updateMods = new ModificationItem[updateList.size()];
        String valueRightExpr = null;
        for (int i = 0; i < updateList.size(); ++i) {
            SetClause setClause = (SetClause)updateList.get(i);
            ColumnReference leftElement = setClause.getSymbol();
            String nameLeftElement = this.getNameFromElement(leftElement);
            Expression rightExpr = setClause.getValue();
            if (!(rightExpr instanceof Literal)) {
                String msg2 = LDAPPlugin.Util.getString("LDAPUpdateExecution.valueNotLiteralError", new Object[]{nameLeftElement});
                throw new TranslatorException(msg2);
            }
            if (((Literal)rightExpr).getValue() != null) {
                valueRightExpr = IQueryToLdapSearchParser.getExpressionString((Literal)rightExpr);
            }
            updateMods[i] = new ModificationItem(2, new BasicAttribute(nameLeftElement, valueRightExpr));
        }
        try {
            this.ldapCtx.modifyAttributes(distinguishedName, updateMods);
        }
        catch (NamingException ne) {
            msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.updateFailed", new Object[]{distinguishedName, ne.getExplanation()});
            throw new TranslatorException(msg);
        }
        catch (Exception e) {
            msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.updateFailedUnexpected", new Object[]{distinguishedName});
            throw new TranslatorException((Throwable)e, msg);
        }
    }

    private String getDNFromCriteria(Condition criteria) throws TranslatorException {
        if (criteria == null) {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.criteriaEmptyError");
            throw new TranslatorException(msg);
        }
        if (!(criteria instanceof Comparison)) {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.criteriaNotSimpleError");
            throw new TranslatorException(msg);
        }
        Comparison compareCriteria = (Comparison)criteria;
        if (compareCriteria.getOperator() != Comparison.Operator.EQ) {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.criteriaNotEqualsError");
            throw new TranslatorException(msg);
        }
        Expression leftExpr = compareCriteria.getLeftExpression();
        if (!(leftExpr instanceof ColumnReference)) {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.criteriaLHSNotElementError");
            throw new TranslatorException(msg);
        }
        String nameLeftExpr = this.getNameFromElement((ColumnReference)leftExpr);
        if (!nameLeftExpr.toUpperCase().equals("DN")) {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.criteriaSrcColumnError", new Object[]{nameLeftExpr});
            throw new TranslatorException(msg);
        }
        Expression rightExpr = compareCriteria.getRightExpression();
        if (!(rightExpr instanceof Literal)) {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.criteriaRHSNotLiteralError");
            throw new TranslatorException(msg);
        }
        Object valueRightExpr = ((Literal)rightExpr).getValue();
        if (!(valueRightExpr instanceof String)) {
            String msg = LDAPPlugin.Util.getString("LDAPUpdateExecution.criteriaRHSNotStringError");
            throw new TranslatorException(msg);
        }
        return (String)valueRightExpr;
    }

    private String getNameFromElement(ColumnReference e) {
        Column mdObject;
        String ldapAttributeName = null;
        String elementNameDirect = e.getName();
        if (elementNameDirect == null) {
            // empty if block
        }
        if ((mdObject = e.getMetadataObject()) == null) {
            return "";
        }
        ldapAttributeName = mdObject.getNameInSource();
        if (ldapAttributeName == null || ldapAttributeName.equals("")) {
            ldapAttributeName = mdObject.getName();
        }
        return ldapAttributeName;
    }

    public void cancel() throws TranslatorException {
        this.close();
    }

    public void close() {
        try {
            if (this.ldapCtx != null) {
                this.ldapCtx.close();
            }
        }
        catch (NamingException ne) {
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12003, new Object[]{ne.getExplanation()}));
        }
    }
}

