/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.odata4j.core.Guid;
import org.odata4j.edm.EdmSimpleType;
import org.teiid.core.types.DataTypeManager;

public class ODataTypeManager {
    private static HashMap<String, EdmSimpleType> teiidkeyed = new HashMap();
    private static HashMap<String, String> odatakeyed = new HashMap();

    public static String teiidType(String odataType) {
        return odatakeyed.get(odataType);
    }

    public static EdmSimpleType odataType(String teiidType) {
        return teiidkeyed.get(teiidType);
    }

    public static Object convertToTeiidRuntimeType(Object value) {
        if (value == null) {
            return null;
        }
        if (DataTypeManager.getAllDataTypeClasses().contains(value.getClass())) {
            return value;
        }
        if (value instanceof LocalDateTime) {
            return new Timestamp(((LocalDateTime)value).toDateTime().getMillis());
        }
        if (value instanceof Guid) {
            return value.toString();
        }
        if (value instanceof LocalTime) {
            return new Time(((LocalTime)value).toDateTimeToday().getMillis());
        }
        return value;
    }

    static {
        teiidkeyed.put("string", EdmSimpleType.STRING);
        teiidkeyed.put("boolean", EdmSimpleType.BOOLEAN);
        teiidkeyed.put("byte", EdmSimpleType.BYTE);
        teiidkeyed.put("short", EdmSimpleType.INT16);
        teiidkeyed.put("char", EdmSimpleType.STRING);
        teiidkeyed.put("integer", EdmSimpleType.INT32);
        teiidkeyed.put("long", EdmSimpleType.INT64);
        teiidkeyed.put("biginteger", EdmSimpleType.INT64);
        teiidkeyed.put("float", EdmSimpleType.SINGLE);
        teiidkeyed.put("double", EdmSimpleType.DOUBLE);
        teiidkeyed.put("bigdecimal", EdmSimpleType.DECIMAL);
        teiidkeyed.put("date", EdmSimpleType.DATETIME);
        teiidkeyed.put("time", EdmSimpleType.TIME);
        teiidkeyed.put("timestamp", EdmSimpleType.DATETIME);
        teiidkeyed.put("object", EdmSimpleType.BINARY);
        teiidkeyed.put("blob", EdmSimpleType.BINARY);
        teiidkeyed.put("clob", EdmSimpleType.BINARY);
        teiidkeyed.put("xml", EdmSimpleType.BINARY);
        teiidkeyed.put("varbinary", EdmSimpleType.BINARY);
        odatakeyed.put(EdmSimpleType.STRING.getFullyQualifiedTypeName(), "string");
        odatakeyed.put(EdmSimpleType.BOOLEAN.getFullyQualifiedTypeName(), "boolean");
        odatakeyed.put(EdmSimpleType.BYTE.getFullyQualifiedTypeName(), "byte");
        odatakeyed.put(EdmSimpleType.SBYTE.getFullyQualifiedTypeName(), "byte");
        odatakeyed.put(EdmSimpleType.INT16.getFullyQualifiedTypeName(), "short");
        odatakeyed.put(EdmSimpleType.INT32.getFullyQualifiedTypeName(), "integer");
        odatakeyed.put(EdmSimpleType.INT64.getFullyQualifiedTypeName(), "long");
        odatakeyed.put(EdmSimpleType.SINGLE.getFullyQualifiedTypeName(), "float");
        odatakeyed.put(EdmSimpleType.DOUBLE.getFullyQualifiedTypeName(), "double");
        odatakeyed.put(EdmSimpleType.DECIMAL.getFullyQualifiedTypeName(), "bigdecimal");
        odatakeyed.put(EdmSimpleType.TIME.getFullyQualifiedTypeName(), "time");
        odatakeyed.put(EdmSimpleType.DATETIME.getFullyQualifiedTypeName(), "timestamp");
        odatakeyed.put(EdmSimpleType.DATETIMEOFFSET.getFullyQualifiedTypeName(), "timestamp");
        odatakeyed.put(EdmSimpleType.BINARY.getFullyQualifiedTypeName(), "blob");
        odatakeyed.put(EdmSimpleType.GUID.getFullyQualifiedTypeName(), "string");
    }
}

