/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.util.ArrayList;
import java.util.List;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.teiid.core.BundleUtil;
import org.teiid.language.ColumnReference;
import org.teiid.language.Delete;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.odata.ODataExecutionFactory;
import org.teiid.translator.odata.ODataPlugin;
import org.teiid.translator.odata.ODataSQLVisitor;

public class ODataUpdateVisitor
extends ODataSQLVisitor {
    protected ODataExecutionFactory executionFactory;
    protected RuntimeMetadata metadata;
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    private String method = "POST";
    private Table entity;
    private List<OProperty<?>> payload;
    private String uri;

    public ODataUpdateVisitor(ODataExecutionFactory executionFactory, RuntimeMetadata metadata) {
        super(executionFactory, metadata);
    }

    public void visit(Insert obj) {
        this.method = "POST";
        this.entity = obj.getTable().getMetadataObject();
        this.uri = this.entity.getName();
        ArrayList props = new ArrayList();
        int elementCount = obj.getColumns().size();
        for (int i = 0; i < elementCount; ++i) {
            Column column = ((ColumnReference)obj.getColumns().get(i)).getMetadataObject();
            List values = ((ExpressionValueSource)obj.getValueSource()).getValues();
            OProperty property = OProperties.simple((String)column.getName(), (Object)((Literal)values.get(i)).getValue());
            props.add(property);
        }
        this.payload = props;
    }

    public void visit(Update obj) {
        this.method = "PUT";
        this.entity = obj.getTable().getMetadataObject();
        this.visitNode((LanguageObject)obj.getTable());
        obj.setWhere(this.buildEntityKey(obj.getWhere()));
        this.uri = this.getEnitityURL();
        if (this.uri.indexOf(40) == -1) {
            this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17011, new Object[]{this.filter.toString()})));
        }
        if (this.filter.length() > 0) {
            this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17009, new Object[]{this.filter.toString()})));
        }
        ArrayList props = new ArrayList();
        int elementCount = obj.getChanges().size();
        for (int i = 0; i < elementCount; ++i) {
            Column column = ((SetClause)obj.getChanges().get(i)).getSymbol().getMetadataObject();
            Literal value = (Literal)((SetClause)obj.getChanges().get(i)).getValue();
            OProperty property = OProperties.simple((String)column.getName(), (Object)value.getValue());
            props.add(property);
        }
        this.payload = props;
    }

    public void visit(Delete obj) {
        this.method = "DELETE";
        this.entity = obj.getTable().getMetadataObject();
        this.visitNode((LanguageObject)obj.getTable());
        obj.setWhere(this.buildEntityKey(obj.getWhere()));
        this.uri = this.getEnitityURL();
        if (this.uri.indexOf(40) == -1) {
            this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17011, new Object[]{this.filter.toString()})));
        }
        if (this.filter.length() > 0) {
            this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17009, new Object[]{this.filter.toString()})));
        }
    }

    public Table getTable() {
        return this.entity;
    }

    @Override
    public String buildURL() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public List<OProperty<?>> getPayload() {
        return this.payload;
    }
}

