/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.tools;

import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.tools.TypeGenerator;
import com.sforce.ws.wsdl.Enumeration;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.SimpleType;
import com.sforce.ws.wsdl.Types;
import java.io.File;
import java.util.Iterator;
import java.util.regex.Pattern;

public class SimpleTypeGenerator
extends TypeGenerator {
    private SimpleType simpleType;
    private static final String TEMPLATE = "com/sforce/ws/tools/simpleType.template";
    private TypeMapper typeMapper;
    private static final Pattern DASH_PATTERN = Pattern.compile("-");

    public SimpleTypeGenerator(Types types, Schema schema, SimpleType simpleType, File tempDir, TypeMapper typeMapper) {
        super(types, schema, simpleType.getName(), tempDir, typeMapper);
        this.simpleType = simpleType;
        this.typeMapper = typeMapper;
    }

    @Override
    protected String getTemplate() {
        return TEMPLATE;
    }

    public Iterator<Enumeration> getEnumeration() {
        return this.simpleType.getRestriction().getElements();
    }

    public String javaName(Enumeration enumeration) {
        String subname;
        String name = enumeration.getValue();
        int index = name.indexOf(":");
        String string = subname = index == -1 ? name : name.substring(index + 1);
        if (this.typeMapper.isKeyWord(subname)) {
            subname = "_" + subname;
        }
        if (subname.indexOf("-") > 0) {
            subname = DASH_PATTERN.matcher(subname).replaceAll("_");
        }
        return subname;
    }
}

