/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce;

import com.sforce.soap.partner.ChildRelationship;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.PicklistEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import org.teiid.core.BundleUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.NameUtil;
import org.teiid.translator.salesforce.Relationship;
import org.teiid.translator.salesforce.RelationshipImpl;
import org.teiid.translator.salesforce.SalesForceExecutionFactory;
import org.teiid.translator.salesforce.SalesForcePlugin;
import org.teiid.translator.salesforce.SalesforceConnection;

public class MetadataProcessor {
    private MetadataFactory metadataFactory;
    private SalesforceConnection connection;
    private SalesForceExecutionFactory connectorEnv;
    private Map<String, Table> tableMap = new HashMap<String, Table>();
    private List<Relationship> relationships = new ArrayList<Relationship>();
    private boolean hasUpdateableColumn = false;
    private List<Column> columns;
    public static final String AUDIT_FIELD_CREATED_BY_ID = "CreatedById";
    public static final String AUDIT_FIELD_CREATED_DATE = "CreatedDate";
    public static final String AUDIT_FIELD_LAST_MODIFIED_BY_ID = "LastModifiedById";
    public static final String AUDIT_FIELD_LAST_MODIFIED_DATE = "LastModifiedDate";
    public static final String AUDIT_FIELD_SYSTEM_MOD_STAMP = "SystemModstamp";
    static final String TABLE_SUPPORTS_CREATE = "Supports Create";
    static final String TABLE_SUPPORTS_DELETE = "Supports Delete";
    static final String TABLE_CUSTOM = "Custom";
    static final String TABLE_SUPPORTS_LOOKUP = "Supports ID Lookup";
    static final String TABLE_SUPPORTS_MERGE = "Supports Merge";
    static final String TABLE_SUPPORTS_QUERY = "Supports Query";
    static final String TABLE_SUPPORTS_REPLICATE = "Supports Replicate";
    static final String TABLE_SUPPORTS_RETRIEVE = "Supports Retrieve";
    static final String TABLE_SUPPORTS_SEARCH = "Supports Search";
    static final String COLUMN_DEFAULTED = "Defaulted on Create";
    static final String COLUMN_CUSTOM = "Custom";
    static final String COLUMN_CALCULATED = "Calculated";
    static final String COLUMN_PICKLIST_VALUES = "Picklist Values";

    public MetadataProcessor(SalesforceConnection connection, MetadataFactory metadataFactory, SalesForceExecutionFactory env) {
        this.connection = connection;
        this.metadataFactory = metadataFactory;
        this.connectorEnv = env;
    }

    public void processMetadata() throws TranslatorException {
        try {
            DescribeGlobalResult globalResult = this.connection.getObjects();
            List objects = globalResult.getSobjects();
            for (DescribeGlobalSObjectResult object : objects) {
                this.addTable(object);
            }
            this.addRelationships();
            for (Table table : this.metadataFactory.getSchema().getTables().values()) {
                for (Column column : table.getPrimaryKey().getColumns()) {
                    if (column.isUpdatable()) continue;
                    column.setAutoIncremented(true);
                }
            }
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private void addRelationships() throws TranslatorException {
        for (Relationship relationship : this.relationships) {
            if (!this.connectorEnv.isModelAuditFields() && MetadataProcessor.isAuditField(relationship.getForeignKeyField())) continue;
            Table parent = this.tableMap.get(NameUtil.normalizeName(relationship.getParentTable()));
            KeyRecord pk = parent.getPrimaryKey();
            if (null == pk) {
                throw new RuntimeException("ERROR !!primary key column not found!!");
            }
            ArrayList<String> columnNames = new ArrayList<String>();
            columnNames.add(pk.getName());
            Table child = this.tableMap.get(NameUtil.normalizeName(relationship.getChildTable()));
            Column col = null;
            this.columns = child.getColumns();
            for (Column column : this.columns) {
                if (!column.getName().equals(relationship.getForeignKeyField())) continue;
                col = column;
            }
            if (null == col) {
                throw new RuntimeException("ERROR !!foreign key column not found!! " + child.getName() + relationship.getForeignKeyField());
            }
            String columnName = "FK_" + parent.getName() + "_" + col.getName();
            ArrayList<String> columnNames2 = new ArrayList<String>();
            columnNames2.add(col.getName());
            this.metadataFactory.addForiegnKey(columnName, columnNames2, parent.getName(), child);
        }
    }

    public static boolean isAuditField(String name) {
        boolean result = false;
        if (name.equals(AUDIT_FIELD_CREATED_BY_ID) || name.equals(AUDIT_FIELD_CREATED_DATE) || name.equals(AUDIT_FIELD_LAST_MODIFIED_BY_ID) || name.equals(AUDIT_FIELD_LAST_MODIFIED_DATE) || name.equals(AUDIT_FIELD_SYSTEM_MOD_STAMP)) {
            result = true;
        }
        return result;
    }

    private void addTable(DescribeGlobalSObjectResult object) throws TranslatorException {
        DescribeSObjectResult objectMetadata = null;
        try {
            objectMetadata = this.connection.getObjectMetaData(object.getName());
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
        String name = NameUtil.normalizeName(objectMetadata.getName());
        Table table = this.metadataFactory.addTable(name);
        table.setNameInSource(objectMetadata.getName());
        this.tableMap.put(name, table);
        this.getRelationships(objectMetadata);
        table.setProperty("Custom", String.valueOf(objectMetadata.isCustom()));
        table.setProperty(TABLE_SUPPORTS_CREATE, String.valueOf(objectMetadata.isCreateable()));
        table.setProperty(TABLE_SUPPORTS_DELETE, String.valueOf(objectMetadata.isDeletable()));
        table.setProperty(TABLE_SUPPORTS_MERGE, String.valueOf(objectMetadata.isMergeable()));
        table.setProperty(TABLE_SUPPORTS_QUERY, String.valueOf(objectMetadata.isQueryable()));
        table.setProperty(TABLE_SUPPORTS_REPLICATE, String.valueOf(objectMetadata.isReplicateable()));
        table.setProperty(TABLE_SUPPORTS_RETRIEVE, String.valueOf(objectMetadata.isRetrieveable()));
        table.setProperty(TABLE_SUPPORTS_SEARCH, String.valueOf(objectMetadata.isSearchable()));
        this.hasUpdateableColumn = false;
        this.addColumns(objectMetadata, table);
        if (this.hasUpdateableColumn && objectMetadata.isUpdateable()) {
            table.setSupportsUpdate(true);
        }
    }

    private void getRelationships(DescribeSObjectResult objectMetadata) {
        List children = objectMetadata.getChildRelationships();
        if (children != null && children.size() != 0) {
            for (ChildRelationship childRelation : children) {
                RelationshipImpl newRelation = new RelationshipImpl();
                newRelation.setParentTable(objectMetadata.getName());
                newRelation.setChildTable(childRelation.getChildSObject());
                newRelation.setForeignKeyField(childRelation.getField());
                newRelation.setCascadeDelete(childRelation.isCascadeDelete());
                this.relationships.add(newRelation);
            }
        }
    }

    private void addColumns(DescribeSObjectResult objectMetadata, Table table) throws TranslatorException {
        List fields = objectMetadata.getFields();
        for (Field field : fields) {
            String normalizedName = NameUtil.normalizeName(field.getName());
            FieldType fieldType = field.getType();
            if (!this.connectorEnv.isModelAuditFields() && MetadataProcessor.isAuditField(field.getName())) continue;
            String sfTypeName = fieldType.value();
            Column column = null;
            if (sfTypeName.equals(FieldType.STRING.value()) || sfTypeName.equals(FieldType.COMBOBOX.value()) || sfTypeName.equals(FieldType.REFERENCE.value()) || sfTypeName.equals(FieldType.PHONE.value()) || sfTypeName.equals(FieldType.ID.value()) || sfTypeName.equals(FieldType.URL.value()) || sfTypeName.equals(FieldType.EMAIL.value()) || sfTypeName.equals(FieldType.ENCRYPTEDSTRING.value()) || sfTypeName.equals(FieldType.ANY_TYPE.value())) {
                column = this.metadataFactory.addColumn(normalizedName, "string", (ColumnSet)table);
                column.setNativeType(sfTypeName);
                if (sfTypeName.equals(FieldType.ID.value())) {
                    column.setNullType(BaseColumn.NullType.No_Nulls);
                    ArrayList<String> columnNames = new ArrayList<String>();
                    columnNames.add(field.getName());
                    this.metadataFactory.addPrimaryKey(field.getName() + "_PK", columnNames, table);
                }
            } else if (sfTypeName.equals(FieldType.PICKLIST.value())) {
                column = this.metadataFactory.addColumn(normalizedName, "string", (ColumnSet)table);
                if (field.isRestrictedPicklist()) {
                    column.setNativeType("restrictedpicklist");
                } else {
                    column.setNativeType(sfTypeName);
                }
                column.setProperty(COLUMN_PICKLIST_VALUES, this.getPicklistValues(field));
            } else if (sfTypeName.equals(FieldType.MULTIPICKLIST.value())) {
                column = this.metadataFactory.addColumn(normalizedName, "string", (ColumnSet)table);
                if (field.isRestrictedPicklist()) {
                    column.setNativeType("restrictedmultiselectpicklist");
                } else {
                    column.setNativeType(sfTypeName);
                }
                column.setProperty(COLUMN_PICKLIST_VALUES, this.getPicklistValues(field));
            } else if (sfTypeName.equals(FieldType.BASE_64.value())) {
                column = this.metadataFactory.addColumn(normalizedName, "blob", (ColumnSet)table);
                column.setNativeType(sfTypeName);
            } else if (sfTypeName.equals(FieldType.BOOLEAN.value())) {
                column = this.metadataFactory.addColumn(normalizedName, "boolean", (ColumnSet)table);
                column.setNativeType(sfTypeName);
            } else if (sfTypeName.equals(FieldType.CURRENCY.value())) {
                column = this.metadataFactory.addColumn(normalizedName, "double", (ColumnSet)table);
                column.setNativeType(sfTypeName);
                column.setCurrency(true);
                column.setScale(field.getScale());
                column.setPrecision(field.getPrecision());
            } else if (sfTypeName.equals(FieldType.TEXTAREA.value())) {
                column = this.metadataFactory.addColumn(normalizedName, "string", (ColumnSet)table);
                column.setNativeType(sfTypeName);
                column.setSearchType(Column.SearchType.Unsearchable);
            } else if (sfTypeName.equals(FieldType.INT.value())) {
                column = this.metadataFactory.addColumn(normalizedName, "integer", (ColumnSet)table);
                column.setNativeType(sfTypeName);
                column.setPrecision(field.getPrecision());
            } else if (sfTypeName.equals(FieldType.DOUBLE.value()) || sfTypeName.equals(FieldType.PERCENT.value())) {
                column = this.metadataFactory.addColumn(normalizedName, "double", (ColumnSet)table);
                column.setNativeType(sfTypeName);
                column.setScale(field.getScale());
                column.setPrecision(field.getPrecision());
            } else if (sfTypeName.equals(FieldType.DATE.value())) {
                column = this.metadataFactory.addColumn(normalizedName, "date", (ColumnSet)table);
                column.setNativeType(sfTypeName);
            } else if (sfTypeName.equals(FieldType.DATETIME.value())) {
                column = this.metadataFactory.addColumn(normalizedName, "timestamp", (ColumnSet)table);
                column.setNativeType(sfTypeName);
            } else if (sfTypeName.equals(FieldType.TIME.value())) {
                column = this.metadataFactory.addColumn(normalizedName, "time", (ColumnSet)table);
                column.setNativeType(sfTypeName);
            }
            if (column == null) {
                LogManager.logError((String)"org.teiid.CONNECTOR", (Object)SalesForcePlugin.Util.gs((BundleUtil.Event)SalesForcePlugin.Event.TEIID13001, new Object[]{sfTypeName}));
                continue;
            }
            column.setNameInSource(field.getName());
            column.setLength(field.getLength());
            if (field.isUpdateable()) {
                column.setUpdatable(true);
                this.hasUpdateableColumn = true;
            }
            column.setProperty(COLUMN_CALCULATED, String.valueOf(field.isCalculated()));
            column.setProperty("Custom", String.valueOf(field.isCustom()));
            column.setProperty(COLUMN_DEFAULTED, String.valueOf(field.isDefaultedOnCreate()));
        }
    }

    private String getPicklistValues(Field field) {
        StringBuffer picklistValues = new StringBuffer();
        if (null != field.getPicklistValues() && 0 != field.getPicklistValues().size()) {
            List entries = field.getPicklistValues();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                PicklistEntry entry = (PicklistEntry)iterator.next();
                picklistValues.append(entry.getValue());
                if (!iterator.hasNext()) continue;
                picklistValues.append(',');
            }
        }
        return picklistValues.toString();
    }
}

