/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution;

import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.resource.ResourceException;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.teiid.core.BundleUtil;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.language.Literal;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.SalesForcePlugin;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.translator.salesforce.Util;
import org.teiid.translator.salesforce.execution.DataPayload;
import org.teiid.translator.salesforce.execution.visitors.CriteriaVisitor;
import org.w3c.dom.Element;

public class DirectQueryExecution
implements ProcedureExecution {
    public static final String SEARCH = "search;";
    private static final String ATTRIBUTES = "attributes";
    private static final String TYPE = "type";
    private static final String ID = "id";
    protected List<Argument> arguments;
    protected Command command;
    private SalesforceConnection connection;
    protected RuntimeMetadata metadata;
    private ExecutionContext context;
    private QueryResult results;
    private List<List<Object>> currentBatch;
    private int updateCount = -1;
    private boolean updateQuery = false;
    private String query;
    private boolean returnsArray = true;

    public DirectQueryExecution(List<Argument> arguments, Command command, SalesforceConnection connection, RuntimeMetadata metadata, ExecutionContext context, String query, boolean returnsArray) {
        this.arguments = arguments;
        this.command = command;
        this.connection = connection;
        this.metadata = metadata;
        this.context = context;
        this.query = query;
        this.returnsArray = returnsArray;
    }

    public void execute() throws TranslatorException {
        if (this.query.startsWith(SEARCH)) {
            StringBuilder buffer = new StringBuilder();
            SQLStringVisitor.parseNativeQueryParts((String)this.query, this.arguments, (StringBuilder)buffer, (SQLStringVisitor.Substitutor)new SQLStringVisitor.Substitutor(){

                public void substitute(Argument arg, StringBuilder builder, int index) {
                    Literal argumentValue = arg.getArgumentValue();
                    CriteriaVisitor.appendLiteralValue(builder, argumentValue);
                }
            });
            this.doSelect(buffer.toString().substring(7));
        } else if (this.query.startsWith("create;")) {
            this.doInsert(this.query.substring(7));
        } else if (this.query.startsWith("update;")) {
            this.doUpdate(this.query.substring(7));
        } else if (this.query.startsWith("delete;")) {
            this.doDelete();
        } else {
            throw new TranslatorException(SalesForcePlugin.Util.gs((BundleUtil.Event)SalesForcePlugin.Event.TEIID13002, new Object[0]));
        }
    }

    private void doDelete() throws TranslatorException {
        ArrayList<String> ids = new ArrayList<String>();
        for (Argument arg : this.arguments) {
            Object val = arg.getArgumentValue().getValue();
            if (val == null) continue;
            ids.add(Util.stripQutes(val.toString()));
        }
        try {
            this.updateCount = this.connection.delete(ids.toArray(new String[ids.size()]));
            this.updateQuery = true;
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private void doUpdate(String update) throws TranslatorException {
        DataPayload payload = this.buildDataPlayload(update);
        try {
            this.updateCount = this.connection.update(Arrays.asList(payload));
            this.updateQuery = true;
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private void doInsert(String insert) throws TranslatorException {
        DataPayload payload = this.buildDataPlayload(insert);
        try {
            this.updateCount = this.connection.create(payload);
            this.updateQuery = true;
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private void doSelect(String select) throws TranslatorException {
        try {
            this.results = this.connection.query(select, this.context.getBatchSize(), Boolean.FALSE);
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        List<?> vals = this.getRow(this.results);
        if (vals == null) {
            return null;
        }
        if (this.returnsArray) {
            ArrayList<Object[]> row = new ArrayList<Object[]>(1);
            row.add(vals.toArray(new Object[vals.size()]));
            return row;
        }
        return vals;
    }

    private List<?> getRow(QueryResult result) throws TranslatorException {
        if (this.updateQuery) {
            if (this.updateCount != -1) {
                List<Integer> updateResult = Arrays.asList(this.updateCount);
                this.updateCount = -1;
                return updateResult;
            }
            return null;
        }
        List<Object> row = null;
        if (this.currentBatch == null) {
            this.currentBatch = this.loadBatch(this.results);
        }
        if (!this.currentBatch.isEmpty()) {
            row = this.currentBatch.remove(0);
        } else if (!result.isDone()) {
            try {
                this.results = this.connection.queryMore(this.results.getQueryLocator(), this.context.getBatchSize());
            }
            catch (ResourceException e) {
                throw new TranslatorException((Throwable)e);
            }
            this.currentBatch = this.loadBatch(this.results);
            row = this.currentBatch.remove(0);
        }
        return row;
    }

    private List<List<Object>> loadBatch(QueryResult queryResult) {
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>();
        for (SObject sObject : queryResult.getRecords()) {
            List fields = sObject.getAny();
            ArrayList<String> row = new ArrayList<String>();
            if (sObject.getId() != null) {
                row.add(sObject.getId());
            }
            for (Object field : fields) {
                Element elem = (Element)field;
                String value = elem.getTextContent();
                row.add(value);
            }
            batch.add(row);
        }
        return batch;
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    private DataPayload buildDataPlayload(String update) throws TranslatorException {
        StringTokenizer st = new StringTokenizer(update, ";");
        if (!st.hasMoreTokens()) {
            throw new TranslatorException(SalesForcePlugin.Util.gs((BundleUtil.Event)SalesForcePlugin.Event.TEIID13004, new Object[0]));
        }
        ArrayList<JAXBElement> attributes = new ArrayList<JAXBElement>();
        String type = null;
        String id = null;
        while (st.hasMoreElements()) {
            String var = st.nextToken();
            int index = var.indexOf(61);
            if (index == -1) continue;
            String key = var.substring(0, index).trim().toLowerCase();
            String value = var.substring(index + 1).trim();
            if (key.equalsIgnoreCase(ATTRIBUTES)) {
                StringTokenizer attrTokens = new StringTokenizer(value, ",");
                int attrCount = 0;
                while (attrTokens.hasMoreElements()) {
                    Argument argument;
                    Object anObj;
                    String name = attrTokens.nextToken().trim();
                    if (this.arguments.size() <= attrCount) {
                        throw new TranslatorException(SalesForcePlugin.Util.gs((BundleUtil.Event)SalesForcePlugin.Event.TEIID13005, new Object[]{name}));
                    }
                    if ((anObj = (argument = this.arguments.get(attrCount++)).getArgumentValue().getValue()) == null) continue;
                    anObj = Util.stripQutes(anObj.toString());
                    QName qname = new QName(name);
                    JAXBElement jbe = new JAXBElement(qname, String.class, anObj);
                    attributes.add(jbe);
                }
                continue;
            }
            if (key.equalsIgnoreCase(TYPE)) {
                type = value;
                continue;
            }
            if (!key.equalsIgnoreCase(ID)) continue;
            id = value;
        }
        DataPayload payload = new DataPayload();
        payload.setID(id);
        payload.setType(type);
        payload.setMessageElements(attributes);
        return payload;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }
}

