/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.resource.ResourceException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.execution.DeletedResult;
import org.teiid.translator.salesforce.execution.ProcedureExecutionParent;
import org.teiid.translator.salesforce.execution.SalesforceProcedureExecution;

public class GetDeletedExecutionImpl
implements SalesforceProcedureExecution {
    private ProcedureExecutionParent parent;
    private DeletedResult deletedResult;
    private int resultIndex = 0;
    DatatypeFactory factory;

    public GetDeletedExecutionImpl(ProcedureExecutionParent procedureExecutionParent) throws TranslatorException {
        this.parent = procedureExecutionParent;
        try {
            this.factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new TranslatorException(e.getMessage());
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
    }

    @Override
    public void execute(ProcedureExecutionParent procedureExecutionParent) throws TranslatorException {
        try {
            Call command = this.parent.getCommand();
            List params = command.getArguments();
            Argument object = (Argument)params.get(0);
            String objectName = (String)object.getArgumentValue().getValue();
            Argument start = (Argument)params.get(1);
            Timestamp startTime = (Timestamp)start.getArgumentValue().getValue();
            GregorianCalendar tempCalendar = (GregorianCalendar)GregorianCalendar.getInstance();
            tempCalendar.setTime(startTime);
            XMLGregorianCalendar startCalendar = this.factory.newXMLGregorianCalendar(tempCalendar);
            Argument end = (Argument)params.get(2);
            Timestamp endTime = (Timestamp)end.getArgumentValue().getValue();
            tempCalendar = (GregorianCalendar)GregorianCalendar.getInstance();
            tempCalendar.setTime(endTime);
            XMLGregorianCalendar endCalendar = this.factory.newXMLGregorianCalendar(tempCalendar);
            this.deletedResult = this.parent.getConnection().getDeleted(objectName, startCalendar, endCalendar);
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    @Override
    public List<?> getOutputParameterValues() {
        ArrayList<Timestamp> result = new ArrayList<Timestamp>();
        result.add(new Timestamp(this.deletedResult.getLatestDateCovered().getTimeInMillis()));
        result.add(new Timestamp(this.deletedResult.getEarliestDateAvailable().getTimeInMillis()));
        return result;
    }

    @Override
    public List<?> next() {
        ArrayList<Object> result = null;
        if (this.deletedResult.getResultRecords() != null && this.resultIndex < this.deletedResult.getResultRecords().size()) {
            result = new ArrayList<Object>(2);
            result.add(this.deletedResult.getResultRecords().get(this.resultIndex).getID());
            result.add(new Timestamp(this.deletedResult.getResultRecords().get(this.resultIndex).getDeletedDate().getTimeInMillis()));
            ++this.resultIndex;
        }
        return result;
    }
}

