/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution.visitors;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.In;
import org.teiid.language.IsNull;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Not;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.SalesForcePlugin;
import org.teiid.translator.salesforce.Util;
import org.teiid.translator.salesforce.execution.visitors.ICriteriaVisitor;

public class CriteriaVisitor
extends HierarchyVisitor
implements ICriteriaVisitor {
    private static final String RESTRICTEDMULTISELECTPICKLIST = "restrictedmultiselectpicklist";
    private static final String MULTIPICKLIST = "multipicklist";
    protected static final String SELECT = "SELECT";
    protected static final String FROM = "FROM";
    protected static final String WHERE = "WHERE";
    protected static final String ORDER_BY = "ORDER BY";
    protected static final String LIMIT = "LIMIT";
    protected static final String SPACE = " ";
    protected static final String EXCLUDES = "EXCLUDES";
    protected static final String INCLUDES = "includes";
    protected static final String COMMA = ",";
    protected static final String SEMI = ";";
    protected static final String APOS = "'";
    protected static final String OPEN = "(";
    protected static final String CLOSE = ")";
    protected RuntimeMetadata metadata;
    protected List<String> criteriaList = new ArrayList<String>();
    protected boolean hasCriteria;
    protected List<TranslatorException> exceptions = new ArrayList<TranslatorException>();
    protected Table table;
    boolean onlyIDCriteria;
    protected Boolean queryAll = Boolean.FALSE;
    protected In idInCriteria = null;

    public CriteriaVisitor(RuntimeMetadata metadata) {
        this.metadata = metadata;
    }

    public void visit(Comparison criteria) {
        this.addCompareCriteria(criteria);
        boolean isAcceptableID = Comparison.Operator.EQ == criteria.getOperator() && this.isIdColumn(criteria.getLeftExpression());
        this.setHasCriteria(true, isAcceptableID);
        if (isAcceptableID) {
            this.idInCriteria = new In(criteria.getLeftExpression(), Arrays.asList(criteria.getRightExpression()), false);
        }
    }

    public void visit(IsNull obj) {
        this.visit(new Comparison(obj.getExpression(), (Expression)new Literal(null, obj.getExpression().getType()), obj.isNegated() ? Comparison.Operator.NE : Comparison.Operator.EQ));
    }

    public void visit(Like criteria) {
        TranslatorException e;
        if (this.isIdColumn(criteria.getLeftExpression())) {
            e = new TranslatorException(SalesForcePlugin.Util.getString("CriteriaVisitor.LIKE.not.supported.on.Id"));
            this.exceptions.add(e);
        }
        if (this.isMultiSelectColumn(criteria.getLeftExpression())) {
            e = new TranslatorException(SalesForcePlugin.Util.getString("CriteriaVisitor.LIKE.not.supported.on.multiselect"));
            this.exceptions.add(e);
        }
        boolean negated = criteria.isNegated();
        criteria.setNegated(false);
        this.criteriaList.add(criteria.toString());
        if (negated) {
            this.addNot();
            criteria.setNegated(true);
        }
        this.setHasCriteria(true, false);
    }

    public void visit(AndOr obj) {
        LinkedList<String> savedCriteria = new LinkedList<String>();
        savedCriteria.add(OPEN);
        super.visitNode((LanguageObject)obj.getLeftCondition());
        savedCriteria.addAll(this.criteriaList);
        this.criteriaList.clear();
        savedCriteria.add(CLOSE);
        savedCriteria.add(SPACE);
        savedCriteria.add(obj.getOperator().toString());
        savedCriteria.add(SPACE);
        savedCriteria.add(OPEN);
        super.visitNode((LanguageObject)obj.getRightCondition());
        savedCriteria.addAll(this.criteriaList);
        this.criteriaList.clear();
        this.criteriaList = savedCriteria;
        this.criteriaList.add(CLOSE);
    }

    public void visit(Not obj) {
        super.visit(obj);
        this.addNot();
    }

    private void addNot() {
        if (!this.criteriaList.isEmpty()) {
            this.criteriaList.add(0, "NOT (");
            this.criteriaList.add(CLOSE);
        }
    }

    public void visit(In criteria) {
        Expression lExpr = criteria.getLeftExpression();
        if (lExpr instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)lExpr;
            Column column = cr.getMetadataObject();
            if (column != null && (MULTIPICKLIST.equalsIgnoreCase(column.getNativeType()) || RESTRICTEDMULTISELECTPICKLIST.equalsIgnoreCase(column.getNativeType()))) {
                this.appendMultiselectIn(column, criteria);
            } else {
                this.appendCriteria(criteria);
            }
        } else {
            this.appendCriteria(criteria);
        }
        this.setHasCriteria(true, this.isIdColumn(criteria.getLeftExpression()));
    }

    public void parseFunction(Function func) {
        String functionName = func.getName();
        try {
            if (functionName.equalsIgnoreCase(INCLUDES)) {
                this.generateMultiSelect(func, INCLUDES);
            } else if (functionName.equalsIgnoreCase("excludes")) {
                this.generateMultiSelect(func, EXCLUDES);
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    private void generateMultiSelect(Function func, String funcName) throws TranslatorException {
        List expressions = func.getParameters();
        this.validateFunction(expressions);
        Expression columnExpression = (Expression)expressions.get(0);
        Column column = ((ColumnReference)columnExpression).getMetadataObject();
        StringBuffer criterion = new StringBuffer();
        criterion.append(column.getNameInSource()).append(SPACE).append(funcName);
        this.addFunctionParams((Literal)expressions.get(1), criterion);
        this.criteriaList.add(criterion.toString());
    }

    private void appendMultiselectIn(Column column, In criteria) {
        StringBuffer result = new StringBuffer();
        result.append(column.getNameInSource()).append(SPACE);
        if (criteria.isNegated()) {
            result.append(EXCLUDES).append(SPACE);
        } else {
            result.append(INCLUDES).append(SPACE);
        }
        result.append('(');
        List rightExpressions = criteria.getRightExpressions();
        Iterator iter = rightExpressions.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            Expression rightExpression = (Expression)iter.next();
            if (first) {
                result.append(rightExpression.toString());
                first = false;
                continue;
            }
            result.append(COMMA).append(rightExpression.toString());
        }
        result.append(')');
        this.criteriaList.add(result.toString());
    }

    private void validateFunction(List<Expression> expressions) throws TranslatorException {
        if (expressions.size() != 2) {
            throw new TranslatorException(SalesForcePlugin.Util.getString("CriteriaVisitor.invalid.arg.count"));
        }
        if (!(expressions.get(0) instanceof ColumnReference)) {
            throw new TranslatorException(SalesForcePlugin.Util.getString("CriteriaVisitor.function.not.column.arg"));
        }
        if (!(expressions.get(1) instanceof Literal)) {
            throw new TranslatorException(SalesForcePlugin.Util.getString("CriteriaVisitor.function.not.literal.arg"));
        }
    }

    private void addFunctionParams(Literal param, StringBuffer criterion) {
        criterion.append(OPEN);
        boolean first = true;
        String fullParam = param.toString();
        String[] params = fullParam.split(COMMA);
        for (int i = 0; i < params.length; ++i) {
            String token = params[i];
            if (first) {
                criterion.append(SPACE).append(Util.addSingleQuotes(token));
                first = false;
                continue;
            }
            criterion.append(COMMA).append(SPACE).append(Util.addSingleQuotes(token));
        }
        criterion.append(CLOSE);
    }

    protected void addCompareCriteria(Comparison compCriteria) {
        Expression lExpr = compCriteria.getLeftExpression();
        if (lExpr instanceof Function) {
            this.parseFunction((Function)lExpr);
        } else {
            Literal isDeletedLiteral;
            Boolean isDeleted;
            StringBuilder queryString = new StringBuilder();
            queryString.append(this.getValue(lExpr, false));
            queryString.append(SPACE);
            queryString.append((Object)(compCriteria.getOperator() == Comparison.Operator.NE ? "!=" : compCriteria.getOperator()));
            queryString.append(' ');
            Expression rExp = compCriteria.getRightExpression();
            queryString.append(this.getValue(rExp, false));
            this.criteriaList.add(queryString.toString());
            if (lExpr instanceof ColumnReference && "IsDeleted".equalsIgnoreCase(((ColumnReference)lExpr).getMetadataObject().getNameInSource()) && (isDeleted = (Boolean)(isDeletedLiteral = (Literal)compCriteria.getRightExpression()).getValue()).booleanValue()) {
                this.queryAll = isDeleted;
            }
        }
    }

    void appendColumnReference(StringBuilder queryString, ColumnReference ref) {
        queryString.append(ref.getMetadataObject().getParent().getNameInSource());
        queryString.append('.');
        queryString.append(ref.getMetadataObject().getNameInSource());
    }

    private void appendCriteria(In criteria) {
        StringBuffer queryString = new StringBuffer();
        Expression leftExp = criteria.getLeftExpression();
        if (this.isIdColumn(leftExp)) {
            this.idInCriteria = criteria;
        }
        queryString.append(this.getValue(leftExp, false));
        queryString.append(' ');
        if (criteria.isNegated()) {
            queryString.append("NOT ");
        }
        queryString.append("IN");
        queryString.append('(');
        Iterator iter = criteria.getRightExpressions().iterator();
        while (iter.hasNext()) {
            queryString.append(this.getValue((Expression)iter.next(), false));
            if (!iter.hasNext()) continue;
            queryString.append(',');
        }
        queryString.append(')');
        this.criteriaList.add(queryString.toString());
    }

    protected String getValue(Expression expr, boolean raw) {
        StringBuilder result = new StringBuilder();
        if (expr instanceof ColumnReference) {
            this.appendColumnReference(result, (ColumnReference)expr);
        } else if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            if (literal.getValue() == null) {
                if (raw) {
                    return null;
                }
                return "NULL";
            }
            if (raw) {
                return literal.getValue().toString();
            }
            CriteriaVisitor.appendLiteralValue(result, literal);
        } else if (expr instanceof AggregateFunction) {
            this.appendAggregateFunction(result, (AggregateFunction)expr);
        } else {
            throw new RuntimeException("unknown type in SalesforceQueryExecution.getValue(): " + expr.toString());
        }
        return result.toString();
    }

    public static void appendLiteralValue(StringBuilder result, Literal literal) {
        if (literal.getValue().getClass().equals(Boolean.class)) {
            result.append(((Boolean)literal.getValue()).toString());
        } else if (literal.getValue().getClass().equals(Timestamp.class)) {
            Timestamp datetime = (Timestamp)literal.getValue();
            String value = datetime.toString();
            int fractionalPlace = value.lastIndexOf(46);
            int fractionalLength = value.length() - fractionalPlace - 1;
            if (fractionalLength > 3) {
                value = value.substring(0, fractionalPlace + 3);
            } else if (fractionalLength < 3) {
                value = value + "00".substring(fractionalLength - 1);
            }
            result.append(value).setCharAt(result.length() - value.length() + 10, 'T');
            Calendar c = TimestampWithTimezone.getCalendar();
            c.setTime(datetime);
            int minutes = (c.get(15) + c.get(16)) / 60000;
            int val = minutes / 60;
            result.append(String.format("%1$+03d", val));
            result.append(':');
            val = minutes % 60;
            result.append(val / 10);
            result.append(val % 10);
        } else if (literal.getValue().getClass().equals(Time.class)) {
            result.append(literal.getValue()).append(".000").append(Util.getDefaultTimeZoneString());
        } else if (literal.getValue().getClass().equals(Date.class)) {
            result.append(literal.getValue());
        } else {
            result.append(literal.toString());
        }
    }

    protected void appendAggregateFunction(StringBuilder result, AggregateFunction af) {
        if (af.getName().equalsIgnoreCase("COUNT") && (af.getExpression() == null || af.getExpression() instanceof Literal)) {
            result.append("COUNT(Id)");
        } else {
            result.append(af.getName() + OPEN + this.getValue(af.getExpression(), false) + CLOSE);
        }
    }

    protected void loadColumnMetadata(NamedTable group) throws TranslatorException {
        this.table = group.getMetadataObject();
        String supportsQuery = this.table.getProperty("{http://www.teiid.org/translator/salesforce/2012}Supports Query", true);
        if (!Boolean.valueOf(supportsQuery).booleanValue()) {
            throw new TranslatorException(this.table.getNameInSource() + SPACE + SalesForcePlugin.Util.getString("CriteriaVisitor.query.not.supported"));
        }
        List columnIds = this.table.getColumns();
        for (Column element : columnIds) {
            String isDeleted;
            if (!element.getNameInSource().equals("IsDeleted") || !Boolean.parseBoolean(isDeleted = element.getDefaultValue())) continue;
            this.queryAll = true;
        }
    }

    protected boolean isIdColumn(Expression expression) {
        Column element;
        String nameInSource;
        boolean result = false;
        if (expression instanceof ColumnReference && (nameInSource = (element = ((ColumnReference)expression).getMetadataObject()).getNameInSource()).equalsIgnoreCase("id")) {
            result = true;
        }
        return result;
    }

    protected boolean isMultiSelectColumn(Expression expression) {
        Column element;
        String nativeType;
        boolean result = false;
        if (expression instanceof ColumnReference && (MULTIPICKLIST.equalsIgnoreCase(nativeType = (element = ((ColumnReference)expression).getMetadataObject()).getNativeType()) || RESTRICTEDMULTISELECTPICKLIST.equalsIgnoreCase(nativeType))) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean hasCriteria() {
        return this.hasCriteria;
    }

    public void setHasCriteria(boolean hasCriteria, boolean isIdCriteria) {
        if (isIdCriteria) {
            this.onlyIDCriteria = !this.hasCriteria();
        } else if (this.onlyIDCriteria) {
            this.onlyIDCriteria = false;
        }
        this.hasCriteria = hasCriteria;
    }

    @Override
    public boolean hasOnlyIDCriteria() {
        return this.onlyIDCriteria;
    }

    @Override
    public String getTableName() throws TranslatorException {
        return this.table.getNameInSource();
    }

    protected void addCriteriaString(StringBuilder result) {
        this.addCriteriaString(WHERE, result);
    }

    protected void addCriteriaString(String clause, StringBuilder result) {
        if (this.hasCriteria()) {
            result.append(clause).append(SPACE);
            for (String string : this.criteriaList) {
                result.append(string);
            }
            result.append(SPACE);
        }
    }
}

