/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.MapValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public abstract class MapAttributeDefinition
extends AttributeDefinition {
    private final ParameterValidator elementValidator;
    public static final ParameterCorrector LIST_TO_MAP_CORRECTOR = new ParameterCorrector(){

        @Override
        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            if (newValue.isDefined() && newValue.getType() == ModelType.LIST) {
                int listSize = newValue.asList().size();
                List propertyList = newValue.asPropertyList();
                if (propertyList.size() == 0) {
                    if (listSize == 0) {
                        return new ModelNode();
                    }
                    if (listSize > 0) {
                        return newValue;
                    }
                }
                ModelNode corrected = new ModelNode();
                for (Property p : newValue.asPropertyList()) {
                    corrected.get(p.getName()).set(p.getValue());
                }
                return corrected;
            }
            return newValue;
        }
    };

    public MapAttributeDefinition(String name, boolean allowNull, ParameterValidator elementValidator) {
        this(name, name, allowNull, false, 0, Integer.MAX_VALUE, null, elementValidator, null, null, null, false, null, null, (Boolean)null, new AttributeAccess.Flag[0]);
    }

    @Deprecated
    public MapAttributeDefinition(String name, String xmlName, boolean allowNull, int minSize, int maxSize, ParameterValidator elementValidator) {
        this(name, xmlName, allowNull, false, minSize, maxSize, null, elementValidator, null, null, null, false, null, null, (Boolean)null, new AttributeAccess.Flag[0]);
    }

    @Deprecated
    public MapAttributeDefinition(String name, String xmlName, boolean allowNull, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeAccess.Flag ... flags) {
        this(name, xmlName, allowNull, false, minSize, maxSize, (ParameterCorrector)null, elementValidator, alternatives, requires, (AttributeMarshaller)null, false, (DeprecationData)null, (AccessConstraintDefinition[])null, (Boolean)null, flags);
    }

    @Deprecated
    protected MapAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpression, int minSize, int maxSize, ParameterCorrector corrector, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AccessConstraintDefinition[] accessConstraints, AttributeAccess.Flag ... flags) {
        this(name, xmlName, allowNull, allowExpression, minSize, maxSize, corrector, elementValidator, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, accessConstraints, (Boolean)null, flags);
    }

    protected MapAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpression, int minSize, int maxSize, ParameterCorrector corrector, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AccessConstraintDefinition[] accessConstraints, Boolean nullSignificant, AttributeAccess.Flag ... flags) {
        super(name, xmlName, null, ModelType.OBJECT, allowNull, allowExpression, null, corrector, (ParameterValidator)new MapValidator(elementValidator, allowNull, minSize, maxSize), false, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, accessConstraints, nullSignificant, flags);
        this.elementValidator = elementValidator;
    }

    public ModelNode parse(String value, Location location) throws XMLStreamException {
        ModelNode node;
        String trimmed;
        String string = trimmed = value == null ? null : value.trim();
        if (trimmed != null) {
            node = this.isAllowExpression() ? ParseUtils.parsePossibleExpression(trimmed) : new ModelNode().set(trimmed);
            if (node.getType() != ModelType.EXPRESSION) {
                switch (this.getType()) {
                    case BIG_DECIMAL: {
                        node.set(node.asBigDecimal());
                        break;
                    }
                    case BIG_INTEGER: {
                        node.set(node.asBigInteger());
                        break;
                    }
                    case BOOLEAN: {
                        node.set(node.asBoolean());
                        break;
                    }
                    case BYTES: {
                        node.set(node.asBytes());
                        break;
                    }
                    case DOUBLE: {
                        node.set(node.asDouble());
                        break;
                    }
                    case INT: {
                        node.set(node.asInt());
                        break;
                    }
                    case LONG: {
                        node.set(node.asLong());
                    }
                }
            }
        } else {
            node = new ModelNode();
        }
        try {
            this.elementValidator.validateParameter(this.getXmlName(), node);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), location);
        }
        return node;
    }

    @Deprecated
    public void parseAndAddParameterElement(String key, String value, ModelNode operation, Location location) throws XMLStreamException {
        ModelNode paramVal = this.parse(value, location);
        operation.get(this.getName()).get(key).set(paramVal);
    }

    public void parseAndAddParameterElement(String key, String value, ModelNode operation, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode paramVal = this.parse(value, reader.getLocation());
        operation.get(this.getName()).get(key).set(paramVal);
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle2, prefix, resourceDescription);
        this.addValueTypeDescription(result, bundle2);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle2, prefix, operationDescription);
        this.addValueTypeDescription(result, bundle2);
        return result;
    }

    protected abstract void addValueTypeDescription(ModelNode var1, ResourceBundle var2);

    @Override
    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle2);
        this.addAttributeValueTypeDescription(result, resolver, locale, bundle2);
        return result;
    }

    protected abstract void addAttributeValueTypeDescription(ModelNode var1, ResourceDescriptionResolver var2, Locale var3, ResourceBundle var4);

    @Override
    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle2);
        this.addOperationParameterValueTypeDescription(result, operationName, resolver, locale, bundle2);
        return result;
    }

    protected abstract void addOperationParameterValueTypeDescription(ModelNode var1, String var2, ResourceDescriptionResolver var3, Locale var4, ResourceBundle var5);

    @Override
    public void marshallAsElement(ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        if (this.attributeMarshaller.isMarshallable(this, resourceModel, marshallDefault)) {
            this.attributeMarshaller.marshallAsElement(this, resourceModel, marshallDefault, writer);
        }
    }

    @Override
    protected ModelNode convertParameterExpressions(ModelNode parameter) {
        ModelNode result = parameter;
        if (parameter.isDefined()) {
            boolean changeMade = false;
            ModelNode newMap = new ModelNode().setEmptyObject();
            for (Property prop : parameter.asPropertyList()) {
                ModelNode converted = this.convertParameterElementExpressions(prop.getValue());
                newMap.get(prop.getName()).set(converted);
                changeMade |= !converted.equals(prop.getValue());
            }
            if (changeMade) {
                result = newMap;
            }
        }
        return result;
    }

    protected ModelNode convertParameterElementExpressions(ModelNode parameterElementValue) {
        return this.isAllowExpression() ? MapAttributeDefinition.convertStringExpression(parameterElementValue) : parameterElementValue;
    }
}

