/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.NoSuchResourceException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.ResourceAuthorization;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.NonResolvingResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AliasStepHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class ReadResourceDescriptionHandler
implements OperationStepHandler {
    private static final SimpleAttributeDefinition INHERITED = new SimpleAttributeDefinitionBuilder("inherited", ModelType.BOOLEAN).setAllowNull(true).setDefaultValue(new ModelNode(true)).build();
    private static final SimpleAttributeDefinition OPERATIONS = new SimpleAttributeDefinitionBuilder("operations", ModelType.BOOLEAN).setAllowNull(true).setDefaultValue(new ModelNode(false)).build();
    private static final SimpleAttributeDefinition ACCESS_CONTROL = new SimpleAttributeDefinitionBuilder("access-control", ModelType.STRING).setAllowNull(true).setDefaultValue(new ModelNode(AccessControl.NONE.toString())).setValidator(EnumValidator.create(AccessControl.class, (boolean)true, (Enum[])new AccessControl[]{AccessControl.NONE, AccessControl.COMBINED_DESCRIPTIONS, AccessControl.TRIM_DESCRIPTONS})).build();
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-resource-description", ControllerResolver.getResolver("global")).setParameters(OPERATIONS, INHERITED, GlobalOperationAttributes.RECURSIVE, GlobalOperationAttributes.RECURSIVE_DEPTH, GlobalOperationAttributes.PROXIES, GlobalOperationAttributes.INCLUDE_ALIASES, ACCESS_CONTROL, GlobalOperationAttributes.LOCALE).setReadOnly().setRuntimeOnly().setReplyType(ModelType.OBJECT).build();
    static final OperationStepHandler INSTANCE = new ReadResourceDescriptionHandler();
    private static final ModelNode PROXY_NO_SUCH_RESOURCE;

    private ReadResourceDescriptionHandler() {
    }

    ReadResourceDescriptionAccessControlContext getAccessControlContext() {
        return null;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ReadResourceDescriptionAccessControlContext accessControlContext;
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        ReadResourceDescriptionAccessControlContext readResourceDescriptionAccessControlContext = accessControlContext = this.getAccessControlContext() == null ? new ReadResourceDescriptionAccessControlContext(address, null) : this.getAccessControlContext();
        if (this.getAccessControlContext() == null && address.isMultiTarget()) {
            this.executeMultiTarget(context, operation, accessControlContext);
        } else {
            this.doExecute(context, operation, accessControlContext);
        }
    }

    private void doExecute(OperationContext context, ModelNode operation, ReadResourceDescriptionAccessControlContext accessControlContext) throws OperationFailedException {
        if (accessControlContext.parentAddresses == null) {
            this.doExecuteInternal(context, operation, accessControlContext);
        } else {
            try {
                this.doExecuteInternal(context, operation, accessControlContext);
            }
            catch (NoSuchResourceException nsre) {
                context.getResult().set(new ModelNode());
                context.stepCompleted();
            }
            catch (UnauthorizedException ue) {
                context.getResult().set(new ModelNode());
                context.stepCompleted();
            }
        }
    }

    private void doExecuteInternal(OperationContext context, ModelNode operation, ReadResourceDescriptionAccessControlContext accessControlContext) throws OperationFailedException {
        HashMap<PathElement, ModelNode> childResources;
        for (AttributeDefinition def : DEFINITION.getParameters()) {
            def.validateOperation(operation);
        }
        String opName = operation.require("operation").asString();
        int recursiveDepth = GlobalOperationAttributes.RECURSIVE_DEPTH.resolveModelAttribute(context, operation).asInt();
        boolean recursive = recursiveDepth > 0 || GlobalOperationAttributes.RECURSIVE.resolveModelAttribute(context, operation).asBoolean();
        boolean proxies = GlobalOperationAttributes.PROXIES.resolveModelAttribute(context, operation).asBoolean();
        boolean ops = OPERATIONS.resolveModelAttribute(context, operation).asBoolean();
        boolean aliases = GlobalOperationAttributes.INCLUDE_ALIASES.resolveModelAttribute(context, operation).asBoolean();
        boolean inheritedOps = INHERITED.resolveModelAttribute(context, operation).asBoolean();
        AccessControl accessControl = AccessControl.forName(ACCESS_CONTROL.resolveModelAttribute(context, operation).asString());
        ImmutableManagementResourceRegistration registry = this.getResourceRegistrationCheckForAlias(context, accessControlContext.opAddress, accessControlContext);
        DescriptionProvider descriptionProvider = registry.getModelDescription(PathAddress.EMPTY_ADDRESS);
        Locale locale = GlobalOperationHandlers.getLocale(context, operation);
        ModelNode nodeDescription = descriptionProvider.getModelDescription(locale);
        HashMap<String, ModelNode> operations = ops ? new HashMap<String, ModelNode>() : null;
        HashMap<PathElement, ModelNode> hashMap = childResources = recursive ? new HashMap<PathElement, ModelNode>() : Collections.emptyMap();
        if (accessControl != AccessControl.NONE) {
            accessControlContext.initLocalResourceAddresses(context, operation);
        }
        ReadResourceDescriptionAssemblyHandler assemblyHandler = new ReadResourceDescriptionAssemblyHandler(nodeDescription, operations, childResources, accessControlContext, accessControl);
        context.addStep(assemblyHandler, OperationContext.Stage.MODEL, true);
        if (ops) {
            for (Map.Entry<String, OperationEntry> entry : registry.getOperationDescriptions(PathAddress.EMPTY_ADDRESS, inheritedOps).entrySet()) {
                if (entry.getValue().getType() != OperationEntry.EntryType.PUBLIC || context.getProcessType() == ProcessType.DOMAIN_SERVER && !entry.getValue().getFlags().contains((Object)OperationEntry.Flag.RUNTIME_ONLY)) continue;
                DescriptionProvider provider = entry.getValue().getDescriptionProvider();
                operations.put(entry.getKey(), provider.getModelDescription(locale));
            }
        }
        if (nodeDescription.hasDefined("attributes")) {
            for (String attr : nodeDescription.require("attributes").keys()) {
                AttributeAccess access = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attr);
                AttributeAccess.AccessType accessType = access == null ? AttributeAccess.AccessType.READ_ONLY : access.getAccessType();
                AttributeAccess.Storage storage = access == null ? AttributeAccess.Storage.CONFIGURATION : access.getStorageType();
                ModelNode attrNode = nodeDescription.get(new String[]{"attributes", attr});
                String displayedAccessType = context.getProcessType() == ProcessType.DOMAIN_SERVER && storage == AttributeAccess.Storage.CONFIGURATION ? AttributeAccess.AccessType.READ_ONLY.toString() : accessType.toString();
                attrNode.get("access-type").set(displayedAccessType);
                attrNode.get("storage").set(storage.toString());
                if (accessType != AttributeAccess.AccessType.READ_WRITE) continue;
                Set<AttributeAccess.Flag> flags = access.getFlags();
                if (flags.contains((Object)AttributeAccess.Flag.RESTART_ALL_SERVICES)) {
                    attrNode.get("restart-required").set("all-services");
                    continue;
                }
                if (flags.contains((Object)AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)) {
                    attrNode.get("restart-required").set("resource-services");
                    continue;
                }
                if (flags.contains((Object)AttributeAccess.Flag.RESTART_JVM)) {
                    attrNode.get("restart-required").set("jvm");
                    continue;
                }
                attrNode.get("restart-required").set("no-services");
            }
        }
        if (accessControl != AccessControl.NONE) {
            accessControlContext.checkResourceAccess(context, registry, nodeDescription, operations);
        }
        if (recursive) {
            for (PathElement element : registry.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
                PathAddress relativeAddr = PathAddress.pathAddress(element);
                ImmutableManagementResourceRegistration childReg = registry.getSubModel(relativeAddr);
                boolean readChild = true;
                if (childReg.isRemote() && !proxies) {
                    readChild = false;
                }
                if (childReg.isAlias() && !aliases) {
                    readChild = false;
                }
                if (readChild) {
                    PathAddress address;
                    int newDepth = recursiveDepth > 0 ? recursiveDepth - 1 : 0;
                    ModelNode rrOp = operation.clone();
                    try {
                        address = PathAddress.pathAddress(accessControlContext.opAddress, element);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    rrOp.get("address").set(address.toModelNode());
                    rrOp.get(GlobalOperationAttributes.RECURSIVE_DEPTH.getName()).set(newDepth);
                    ModelNode rrRsp = new ModelNode();
                    childResources.put(element, rrRsp);
                    OperationStepHandler handler = this.getRecursiveStepHandler(childReg, opName, accessControlContext, address);
                    context.addStep(rrRsp, rrOp, handler, OperationContext.Stage.MODEL, true);
                }
                nodeDescription.get(new String[]{"children", element.getKey(), "model-description", element.getValue()});
            }
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!context.hasFailureDescription()) {
                    for (ModelNode value : childResources.values()) {
                        if (!value.hasDefined("failure-description")) continue;
                        context.getFailureDescription().set(value.get("failure-description"));
                        break;
                    }
                }
            }
        });
    }

    private OperationStepHandler getRecursiveStepHandler(ImmutableManagementResourceRegistration childReg, String opName, ReadResourceDescriptionAccessControlContext accessControlContext, PathAddress address) {
        OperationStepHandler overrideHandler = childReg.getOperationHandler(PathAddress.EMPTY_ADDRESS, opName);
        if (overrideHandler != null && overrideHandler.getClass() == ReadResourceDescriptionHandler.class || overrideHandler.getClass() == AliasStepHandler.class) {
            overrideHandler = null;
        }
        if (overrideHandler != null) {
            return new NestedReadResourceDescriptionHandler(overrideHandler);
        }
        return new NestedReadResourceDescriptionHandler(new ReadResourceDescriptionAccessControlContext(address, accessControlContext));
    }

    private ImmutableManagementResourceRegistration getResourceRegistrationCheckForAlias(OperationContext context, PathAddress opAddr, ReadResourceDescriptionAccessControlContext accessControlContext) {
        ImmutableManagementResourceRegistration root = context.getRootResourceRegistration();
        ImmutableManagementResourceRegistration registry = root.getSubModel(opAddr);
        AliasEntry aliasEntry = registry.getAliasEntry();
        if (aliasEntry == null) {
            return registry;
        }
        return root.getSubModel(aliasEntry.convertToTargetAddress(opAddr));
    }

    private void executeMultiTarget(OperationContext context, ModelNode operation, final ReadResourceDescriptionAccessControlContext accessControlContext) {
        final ModelNode result = context.getResult().setEmptyList();
        context.addStep(new ModelNode(), GlobalOperationHandlers.AbstractMultiTargetHandler.FAKE_OPERATION.clone(), new GlobalOperationHandlers.RegistrationAddressResolver(operation, result, new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ReadResourceDescriptionHandler.this.doExecute(context, operation, accessControlContext);
            }
        }), OperationContext.Stage.IMMEDIATE);
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!context.hasFailureDescription()) {
                    String op = operation.require("operation").asString();
                    HashMap<PathAddress, ModelNode> failures = new HashMap<PathAddress, ModelNode>();
                    for (ModelNode resultItem : result.asList()) {
                        if (!resultItem.hasDefined("failure-description")) continue;
                        PathAddress failedAddress = PathAddress.pathAddress(operation.require("address"));
                        ModelNode failedDesc = resultItem.get("failure-description");
                        failures.put(failedAddress, failedDesc);
                    }
                    if (failures.size() == 1) {
                        Map.Entry entry = failures.entrySet().iterator().next();
                        if (((ModelNode)entry.getValue()).getType() == ModelType.STRING) {
                            context.getFailureDescription().set(ControllerMessages.MESSAGES.wildcardOperationFailedAtSingleAddress(op, (PathAddress)entry.getKey(), ((ModelNode)entry.getValue()).asString()));
                        } else {
                            context.getFailureDescription().set(ControllerMessages.MESSAGES.wildcardOperationFailedAtSingleAddressWithComplexFailure(op, (PathAddress)entry.getKey()));
                        }
                    } else if (failures.size() > 1) {
                        context.getFailureDescription().set(ControllerMessages.MESSAGES.wildcardOperationFailedAtMultipleAddresses(op, failures.keySet()));
                    }
                }
            }
        });
    }

    static {
        ModelNode none = new ModelNode();
        none.get("no-such-resource").set("no$such$resource");
        none.protect();
        PROXY_NO_SUCH_RESOURCE = none;
    }

    public static enum AccessControl {
        NONE("none"),
        COMBINED_DESCRIPTIONS("combined-descriptions"),
        TRIM_DESCRIPTONS("trim-descriptions");

        private static final Map<String, AccessControl> MAP;
        private final String localName;

        public static AccessControl forName(String localName) {
            AccessControl value = localName != null ? MAP.get(localName.toLowerCase()) : null;
            return value == null ? AccessControl.valueOf(localName.toUpperCase()) : value;
        }

        private AccessControl(String localName) {
            this.localName = localName;
        }

        public String toString() {
            return this.localName;
        }

        public ModelNode toModelNode() {
            return new ModelNode().set(this.toString());
        }

        static {
            HashMap<String, AccessControl> map = new HashMap<String, AccessControl>();
            for (AccessControl directoryGrouping : AccessControl.values()) {
                map.put(directoryGrouping.localName, directoryGrouping);
            }
            MAP = map;
        }
    }

    private class NestedReadResourceDescriptionHandler
    extends ReadResourceDescriptionHandler {
        final ReadResourceDescriptionAccessControlContext accessControlContext;
        final OperationStepHandler overrideStepHandler;

        NestedReadResourceDescriptionHandler(ReadResourceDescriptionAccessControlContext accessControlContext) {
            this.accessControlContext = accessControlContext;
            this.overrideStepHandler = null;
        }

        NestedReadResourceDescriptionHandler(OperationStepHandler overrideStepHandler) {
            this.accessControlContext = null;
            this.overrideStepHandler = overrideStepHandler;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (this.accessControlContext != null) {
                ReadResourceDescriptionHandler.this.doExecute(context, operation, this.accessControlContext);
            } else {
                try {
                    this.overrideStepHandler.execute(context, operation);
                }
                catch (NoSuchResourceException e) {
                    context.getResult().set(PROXY_NO_SUCH_RESOURCE);
                    context.stepCompleted();
                }
                catch (UnauthorizedException e) {
                    context.getResult().set(new ModelNode());
                    context.stepCompleted();
                }
            }
        }
    }

    static final class ReadResourceDescriptionAccessControlContext {
        private final PathAddress opAddress;
        private final List<PathAddress> parentAddresses;
        private List<PathAddress> localResourceAddresses = null;
        private ModelNode defaultWildcardAccessControl;
        private Map<PathAddress, ModelNode> localResourceAccessControlResults = new HashMap<PathAddress, ModelNode>();

        ReadResourceDescriptionAccessControlContext(PathAddress opAddress, ReadResourceDescriptionAccessControlContext parent) {
            this.opAddress = opAddress;
            this.parentAddresses = parent != null ? parent.parentAddresses : null;
        }

        private void initLocalResourceAddresses(OperationContext context, ModelNode operation) {
            this.localResourceAddresses = this.getLocalResourceAddresses(context, operation);
        }

        private List<PathAddress> getLocalResourceAddresses(OperationContext context, ModelNode operation) {
            ArrayList<PathAddress> localResourceAddresses = null;
            PathAddress opAddr = PathAddress.pathAddress(operation.require("address"));
            if (this.parentAddresses == null) {
                if (opAddr.size() == 0) {
                    return Collections.singletonList(PathAddress.EMPTY_ADDRESS);
                }
                localResourceAddresses = new ArrayList();
                this.getAllActualResourceAddresses(context, operation, localResourceAddresses, PathAddress.EMPTY_ADDRESS, opAddr);
            } else {
                localResourceAddresses = new ArrayList<PathAddress>();
                for (PathAddress pathAddress : this.parentAddresses) {
                    this.getAllActualResourceAddresses(context, operation, localResourceAddresses, pathAddress, opAddr);
                }
            }
            return localResourceAddresses;
        }

        private void getAllActualResourceAddresses(OperationContext context, ModelNode operation, List<PathAddress> addresses, PathAddress currentAddress, PathAddress opAddress) {
            if (opAddress.size() == 0) {
                return;
            }
            int length = currentAddress.size();
            PathElement currentElement = opAddress.getElement(length);
            if (currentElement.isWildcard()) {
                Resource resource;
                try {
                    resource = context.readResourceFromRoot(currentAddress);
                }
                catch (UnauthorizedException e) {
                    ResourceAuthorization response = context.authorizeResource(false, false);
                    if (response.getResourceResult(Action.ActionEffect.ADDRESS).getDecision() != AuthorizationResult.Decision.PERMIT) {
                        return;
                    }
                    resource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
                    for (PathElement element : currentAddress) {
                        resource = resource.getChild(element);
                    }
                }
                ImmutableManagementResourceRegistration directRegistration = context.getRootResourceRegistration().getSubModel(currentAddress);
                Map<String, Set<String>> childAddresses = GlobalOperationHandlers.getChildAddresses(context, currentAddress, directRegistration, resource, currentElement.getKey());
                Set<String> childNames = childAddresses.get(currentElement.getKey());
                if (childNames != null) {
                    for (String name : childNames) {
                        PathAddress address = currentAddress.append(PathElement.pathElement(currentElement.getKey(), name));
                        if (!this.addParentResource(context, addresses, address)) continue;
                        if (address.size() == opAddress.size()) {
                            addresses.add(address);
                            continue;
                        }
                        this.getAllActualResourceAddresses(context, operation, addresses, address, opAddress);
                    }
                }
            } else {
                PathAddress address = currentAddress.append(currentElement);
                if (this.addParentResource(context, addresses, address)) {
                    if (address.size() == opAddress.size()) {
                        addresses.add(address);
                    } else {
                        this.getAllActualResourceAddresses(context, operation, addresses, address, opAddress);
                    }
                }
            }
        }

        private boolean addParentResource(OperationContext context, List<PathAddress> addresses, PathAddress address) {
            try {
                context.readResourceFromRoot(address);
            }
            catch (NoSuchResourceException nsre) {
                return false;
            }
            catch (UnauthorizedException ue) {
                // empty catch block
            }
            return true;
        }

        void checkResourceAccess(OperationContext context, ImmutableManagementResourceRegistration registration, ModelNode nodeDescription, Map<String, ModelNode> operations) {
            ModelNode defaultAccess = Util.createOperation(this.opAddress.size() > 0 && !this.opAddress.getLastElement().isWildcard() ? "check-default-resource-access" : "check-resource-access", this.opAddress);
            this.defaultWildcardAccessControl = new ModelNode();
            context.addStep(defaultAccess, new CheckResourceAccessHandler(registration.isRuntimeOnly(), true, this.defaultWildcardAccessControl, nodeDescription, operations), OperationContext.Stage.MODEL, true);
            for (PathAddress address : this.localResourceAddresses) {
                ModelNode op = Util.createOperation("check-resource-access", address);
                ModelNode resultHolder = new ModelNode();
                this.localResourceAccessControlResults.put(address, resultHolder);
                context.addStep(op, new CheckResourceAccessHandler(registration.isRuntimeOnly(), false, resultHolder, nodeDescription, operations), OperationContext.Stage.MODEL, true);
            }
        }
    }

    private static class ReadResourceDescriptionAssemblyHandler
    implements OperationStepHandler {
        private final ModelNode nodeDescription;
        private final Map<String, ModelNode> operations;
        private final Map<PathElement, ModelNode> childResources;
        private final ReadResourceDescriptionAccessControlContext accessControlContext;
        private final AccessControl accessControl;

        private ReadResourceDescriptionAssemblyHandler(ModelNode nodeDescription, Map<String, ModelNode> operations, Map<PathElement, ModelNode> childResources, ReadResourceDescriptionAccessControlContext accessControlContext, AccessControl accessControl) {
            this.nodeDescription = nodeDescription;
            this.operations = operations;
            this.childResources = childResources;
            this.accessControlContext = accessControlContext;
            this.accessControl = accessControl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            for (Map.Entry<PathElement, ModelNode> entry : this.childResources.entrySet()) {
                PathElement element = entry.getKey();
                ModelNode value = entry.getValue();
                if (!value.has("failure-description")) {
                    ModelNode actualValue = value.get("result");
                    if (actualValue.equals(PROXY_NO_SUCH_RESOURCE)) {
                        this.nodeDescription.get("children").remove(element.getKey());
                        continue;
                    }
                    this.nodeDescription.get(new String[]{"children", element.getKey(), "model-description", element.getValue()}).set(actualValue);
                    continue;
                }
                if (!value.hasDefined("failure-description")) continue;
                context.getFailureDescription().set(value.get("failure-description"));
                break;
            }
            if (this.operations != null) {
                for (Map.Entry<Object, ModelNode> entry : this.operations.entrySet()) {
                    this.nodeDescription.get(new String[]{OPERATIONS.getName(), (String)entry.getKey()}).set(entry.getValue());
                }
            }
            if (this.accessControlContext.defaultWildcardAccessControl != null && this.accessControlContext.localResourceAccessControlResults != null) {
                ModelNode accessControl = new ModelNode();
                accessControl.setEmptyObject();
                if (this.accessControlContext.defaultWildcardAccessControl != null) {
                    accessControl.get("default").set(this.accessControlContext.defaultWildcardAccessControl);
                    ModelNode modelNode = this.accessControlContext.defaultWildcardAccessControl;
                } else {
                    ModelNode modelNode = new ModelNode();
                }
                if (this.accessControlContext.localResourceAccessControlResults != null) {
                    ModelNode exceptions = accessControl.get("exceptions");
                    exceptions.setEmptyObject();
                    for (Map.Entry entry : this.accessControlContext.localResourceAccessControlResults.entrySet()) {
                        void var4_9;
                        if (!((ModelNode)entry.getValue()).isDefined() || ((ModelNode)entry.getValue()).equals((ModelNode)var4_9)) continue;
                        ModelNode exceptionAddr = ((PathAddress)entry.getKey()).toModelNode();
                        ModelNode exception = (ModelNode)entry.getValue();
                        exception.get("address").set(exceptionAddr);
                        exceptions.get(exceptionAddr.asString()).set((ModelNode)entry.getValue());
                    }
                }
                this.nodeDescription.get(ACCESS_CONTROL.getName()).set(accessControl);
            }
            if (this.accessControl == AccessControl.TRIM_DESCRIPTONS) {
                this.nodeDescription.get("description").clear();
                if (this.nodeDescription.hasDefined("attributes")) {
                    this.nodeDescription.get("attributes").clear();
                }
                if (this.nodeDescription.hasDefined("operations")) {
                    this.nodeDescription.get("operations").clear();
                }
                if (this.nodeDescription.hasDefined("children")) {
                    for (String string : this.nodeDescription.get("children").keys()) {
                        ModelNode childNode = this.nodeDescription.get(new String[]{"children", string});
                        if (!childNode.isDefined()) continue;
                        childNode.remove("description");
                    }
                }
            }
            context.getResult().set(this.nodeDescription);
            context.stepCompleted();
        }
    }

    static final class CheckResourceAccessHandler
    implements OperationStepHandler {
        static final OperationDefinition DEFAULT_DEFINITION = new SimpleOperationDefinitionBuilder("check-default-resource-access", new NonResolvingResourceDescriptionResolver()).setPrivateEntry().build();
        static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("check-resource-access", new NonResolvingResourceDescriptionResolver()).setPrivateEntry().build();
        private final boolean runtimeResource;
        private final boolean defaultSetting;
        private final ModelNode accessControlResult;
        private final ModelNode nodeDescription;
        private final Map<String, ModelNode> operations;

        CheckResourceAccessHandler(boolean runtimeResource, boolean defaultSetting, ModelNode accessControlResult, ModelNode nodeDescription, Map<String, ModelNode> operations) {
            this.runtimeResource = runtimeResource;
            this.defaultSetting = defaultSetting;
            this.accessControlResult = accessControlResult;
            this.nodeDescription = nodeDescription;
            this.operations = operations;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode result = new ModelNode();
            boolean customDefaultCheck = operation.get("operation").asString().equals("check-default-resource-access");
            ResourceAuthorization authResp = context.authorizeResource(true, customDefaultCheck);
            if (authResp.getResourceResult(Action.ActionEffect.ADDRESS).getDecision() == AuthorizationResult.Decision.DENY) {
                if (this.defaultSetting) {
                    result.get(Action.ActionEffect.ADDRESS.toString()).set(false);
                }
            } else {
                this.addResourceAuthorizationResults(result, authResp);
                ModelNode attributes = new ModelNode();
                attributes.setEmptyObject();
                if (result.get("read").asBoolean()) {
                    if (this.nodeDescription.hasDefined("attributes")) {
                        for (Property attrProp : this.nodeDescription.require("attributes").asPropertyList()) {
                            ModelNode attributeResult = new ModelNode();
                            AttributeAccess.Storage storage = AttributeAccess.Storage.valueOf(attrProp.getValue().get("storage").asString().toUpperCase());
                            this.addAttributeAuthorizationResults(attributeResult, attrProp.getName(), authResp, storage == AttributeAccess.Storage.RUNTIME);
                            if (!attributeResult.isDefined()) continue;
                            attributes.get(attrProp.getName()).set(attributeResult);
                        }
                    }
                    result.get("attributes").set(attributes);
                    if (this.operations != null) {
                        ModelNode ops = new ModelNode();
                        ops.setEmptyObject();
                        for (Map.Entry<String, ModelNode> entry : this.operations.entrySet()) {
                            ModelNode operationToCheck = Util.createOperation(entry.getKey(), PathAddress.pathAddress(operation.require("address")));
                            ModelNode operationResult = new ModelNode();
                            this.addOperationAuthorizationResult(context, operationResult, operationToCheck, entry.getKey());
                            ops.get(entry.getKey()).set(operationResult);
                        }
                        result.get("operations").set(ops);
                    }
                }
            }
            this.accessControlResult.set(result);
            context.stepCompleted();
        }

        private void addResourceAuthorizationResults(ModelNode result, ResourceAuthorization authResp) {
            if (this.runtimeResource) {
                this.addResourceAuthorizationResult(result, authResp, Action.ActionEffect.READ_RUNTIME);
                this.addResourceAuthorizationResult(result, authResp, Action.ActionEffect.WRITE_RUNTIME);
            } else {
                this.addResourceAuthorizationResult(result, authResp, Action.ActionEffect.READ_CONFIG);
                this.addResourceAuthorizationResult(result, authResp, Action.ActionEffect.WRITE_CONFIG);
            }
        }

        private void addResourceAuthorizationResult(ModelNode result, ResourceAuthorization authResp, Action.ActionEffect actionEffect) {
            AuthorizationResult authResult = authResp.getResourceResult(actionEffect);
            result.get(actionEffect == Action.ActionEffect.READ_CONFIG || actionEffect == Action.ActionEffect.READ_RUNTIME ? "read" : "write").set(authResult.getDecision() == AuthorizationResult.Decision.PERMIT);
        }

        private void addAttributeAuthorizationResults(ModelNode result, String attributeName, ResourceAuthorization authResp, boolean runtime) {
            if (runtime) {
                this.addAttributeAuthorizationResult(result, attributeName, authResp, Action.ActionEffect.READ_RUNTIME);
                this.addAttributeAuthorizationResult(result, attributeName, authResp, Action.ActionEffect.WRITE_RUNTIME);
            } else {
                this.addAttributeAuthorizationResult(result, attributeName, authResp, Action.ActionEffect.READ_CONFIG);
                this.addAttributeAuthorizationResult(result, attributeName, authResp, Action.ActionEffect.WRITE_CONFIG);
            }
        }

        private void addAttributeAuthorizationResult(ModelNode result, String attributeName, ResourceAuthorization authResp, Action.ActionEffect actionEffect) {
            AuthorizationResult authorizationResult = authResp.getAttributeResult(attributeName, actionEffect);
            if (authorizationResult != null) {
                result.get(actionEffect == Action.ActionEffect.READ_CONFIG || actionEffect == Action.ActionEffect.READ_RUNTIME ? "read" : "write").set(authorizationResult.getDecision() == AuthorizationResult.Decision.PERMIT);
            }
        }

        private void addOperationAuthorizationResult(OperationContext context, ModelNode result, ModelNode operation, String operationName) {
            AuthorizationResult authorizationResult = context.authorizeOperation(operation);
            result.get("execute").set(authorizationResult.getDecision() == AuthorizationResult.Decision.PERMIT);
        }
    }
}

