/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.SubsystemInformation;
import org.jboss.as.controller.registry.OperationTransformerRegistry;
import org.jboss.as.controller.transform.CompositeOperationTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformerEntry;
import org.jboss.as.controller.transform.TransformerRegistry;

public class TransformationTargetImpl
implements TransformationTarget {
    private final ModelVersion version;
    private final ExtensionRegistry extensionRegistry;
    private final TransformerRegistry transformerRegistry;
    private final Map<String, ModelVersion> subsystemVersions = Collections.synchronizedMap(new HashMap());
    private final OperationTransformerRegistry registry;
    private final TransformationTarget.TransformationTargetType type;
    private final TransformationTarget.IgnoredTransformationRegistry transformationExclusion;

    private TransformationTargetImpl(TransformerRegistry transformerRegistry, ModelVersion version, Map<PathAddress, ModelVersion> subsystemVersions, OperationTransformerRegistry transformers, TransformationTarget.IgnoredTransformationRegistry transformationExclusion, TransformationTarget.TransformationTargetType type) {
        this.version = version;
        this.transformerRegistry = transformerRegistry;
        this.extensionRegistry = transformerRegistry.getExtensionRegistry();
        for (Map.Entry<PathAddress, ModelVersion> p : subsystemVersions.entrySet()) {
            String name = p.getKey().getLastElement().getValue();
            this.subsystemVersions.put(name, p.getValue());
        }
        this.registry = transformers;
        this.type = type;
        this.transformationExclusion = transformationExclusion == null ? null : transformationExclusion;
    }

    public static TransformationTargetImpl create(TransformerRegistry transformerRegistry, ModelVersion version, Map<PathAddress, ModelVersion> subsystems, TransformationTarget.IgnoredTransformationRegistry transformationExclusion, TransformationTarget.TransformationTargetType type) {
        OperationTransformerRegistry registry;
        switch (type) {
            case SERVER: {
                registry = transformerRegistry.resolveServer(version, subsystems);
                break;
            }
            default: {
                registry = transformerRegistry.resolveHost(version, subsystems);
            }
        }
        return new TransformationTargetImpl(transformerRegistry, version, subsystems, registry, transformationExclusion, type);
    }

    @Override
    public ModelVersion getVersion() {
        return this.version;
    }

    @Override
    public ModelVersion getSubsystemVersion(String subsystemName) {
        return this.subsystemVersions.get(subsystemName);
    }

    public SubsystemInformation getSubsystemInformation(String subsystemName) {
        return this.extensionRegistry.getSubsystemInfo(subsystemName);
    }

    @Override
    public ResourceTransformer resolveTransformer(PathAddress address) {
        if (this.transformationExclusion != null && this.transformationExclusion.isResourceTransformationIgnored(address)) {
            return ResourceTransformer.DEFAULT;
        }
        OperationTransformerRegistry.ResourceTransformerEntry entry = this.registry.resolveResourceTransformer(address);
        if (entry == null) {
            return ResourceTransformer.DEFAULT;
        }
        return entry.getTransformer();
    }

    @Override
    public TransformerEntry getTransformerEntry(PathAddress address) {
        return this.registry.getTransformerEntry(address);
    }

    @Override
    public List<PathAddressTransformer> getPathTransformation(PathAddress address) {
        return this.registry.getPathTransformations(address);
    }

    @Override
    public OperationTransformer resolveTransformer(PathAddress address, String operationName) {
        if (this.transformationExclusion != null && this.transformationExclusion.isOperationTransformationIgnored(address)) {
            return OperationTransformer.DEFAULT;
        }
        if (address.size() == 0 && "composite".equals(operationName)) {
            return new CompositeOperationTransformer();
        }
        OperationTransformerRegistry.OperationTransformerEntry entry = this.registry.resolveOperationTransformer(address, operationName);
        return entry.getTransformer();
    }

    @Override
    public void addSubsystemVersion(String subsystemName, int majorVersion, int minorVersion) {
        this.addSubsystemVersion(subsystemName, ModelVersion.create(majorVersion, minorVersion));
    }

    @Override
    public void addSubsystemVersion(String subsystemName, ModelVersion version) {
        this.subsystemVersions.put(subsystemName, version);
        this.transformerRegistry.addSubsystem(this.registry, subsystemName, version);
    }

    @Override
    public TransformationTarget.TransformationTargetType getTargetType() {
        return this.type;
    }

    @Override
    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    @Override
    public String getHostName() {
        if (this.transformationExclusion == null) {
            return null;
        }
        return this.transformationExclusion.getHostName();
    }

    @Override
    public boolean isIgnoredResourceListAvailableAtRegistration() {
        return this.version.getMajor() >= 1 && this.version.getMinor() >= 4;
    }
}

