/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.ExpressionPattern;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public interface RejectAttributeChecker {
    public static final RejectAttributeChecker SIMPLE_EXPRESSIONS = new DefaultRejectAttributeChecker(){

        @Override
        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return this.checkForExpression(attributeValue);
        }

        private boolean checkForExpression(ModelNode node) {
            if (!node.isDefined()) {
                return false;
            }
            ModelNode resolved = node.clone();
            if (node.getType() == ModelType.EXPRESSION || node.getType() == ModelType.STRING) {
                return this.checkForExpression(resolved.asString());
            }
            if (node.getType() == ModelType.OBJECT) {
                for (Property prop : resolved.asPropertyList()) {
                    if (!this.checkForExpression(prop.getValue())) continue;
                    return true;
                }
            } else if (node.getType() == ModelType.LIST) {
                for (ModelNode current : resolved.asList()) {
                    if (!this.checkForExpression(current)) continue;
                    return true;
                }
            } else if (node.getType() == ModelType.PROPERTY) {
                return this.checkForExpression(resolved.asProperty().getValue());
            }
            return false;
        }

        private boolean checkForExpression(String value) {
            return ExpressionPattern.EXPRESSION_PATTERN.matcher(value).matches();
        }

        @Override
        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ControllerMessages.MESSAGES.attributesDoNotSupportExpressions(attributes.keySet());
        }
    };
    public static final RejectAttributeChecker DEFINED = new DefaultRejectAttributeChecker(){

        @Override
        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ControllerMessages.MESSAGES.attributesAreNotUnderstoodAndMustBeIgnored(attributes.keySet());
        }

        @Override
        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return attributeValue.isDefined();
        }
    };
    public static final RejectAttributeChecker UNDEFINED = new DefaultRejectAttributeChecker(){

        @Override
        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ControllerMessages.MESSAGES.attributesMustBeDefined(attributes.keySet());
        }

        @Override
        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return !attributeValue.isDefined();
        }
    };

    public boolean rejectOperationParameter(PathAddress var1, String var2, ModelNode var3, ModelNode var4, TransformationContext var5);

    public boolean rejectResourceAttribute(PathAddress var1, String var2, ModelNode var3, TransformationContext var4);

    public String getRejectionLogMessageId();

    public String getRejectionLogMessage(Map<String, ModelNode> var1);

    public static class ObjectFieldsRejectAttributeChecker
    implements RejectAttributeChecker {
        private final Map<String, RejectAttributeChecker> fields = new HashMap<String, RejectAttributeChecker>();

        public ObjectFieldsRejectAttributeChecker(Map<String, RejectAttributeChecker> fields) {
            assert (fields != null) : "Null fields";
            assert (fields.size() > 0) : "Empty fields";
            this.fields.putAll(fields);
        }

        @Override
        public boolean rejectOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            for (Map.Entry<String, RejectAttributeChecker> entry : this.fields.entrySet()) {
                ModelNode fieldValue;
                ModelNode modelNode = fieldValue = attributeValue.hasDefined(entry.getKey()) ? attributeValue.get(entry.getKey()) : new ModelNode();
                if (!entry.getValue().rejectOperationParameter(address, attributeName, fieldValue, operation, context)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean rejectResourceAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            for (Map.Entry<String, RejectAttributeChecker> entry : this.fields.entrySet()) {
                ModelNode fieldValue;
                ModelNode modelNode = fieldValue = attributeValue.hasDefined(entry.getKey()) ? attributeValue.get(entry.getKey()) : new ModelNode();
                if (!entry.getValue().rejectResourceAttribute(address, attributeName, fieldValue, context)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getRejectionLogMessageId() {
            return this.fields.entrySet().iterator().next().getValue().getRejectionLogMessageId();
        }

        @Override
        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return this.fields.entrySet().iterator().next().getValue().getRejectionLogMessage(attributes);
        }
    }

    public static class ListRejectAttributeChecker
    implements RejectAttributeChecker {
        private final RejectAttributeChecker elementChecker;

        public ListRejectAttributeChecker(RejectAttributeChecker elementChecker) {
            this.elementChecker = elementChecker;
        }

        @Override
        public boolean rejectOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            if (attributeValue.isDefined()) {
                for (ModelNode element : attributeValue.asList()) {
                    if (!this.elementChecker.rejectOperationParameter(address, attributeName, element, operation, context)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean rejectResourceAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                for (ModelNode element : attributeValue.asList()) {
                    if (!this.elementChecker.rejectResourceAttribute(address, attributeName, element, context)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getRejectionLogMessageId() {
            return this.elementChecker.getRejectionLogMessageId();
        }

        @Override
        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return this.elementChecker.getRejectionLogMessage(attributes);
        }
    }

    public static abstract class DefaultRejectAttributeChecker
    implements RejectAttributeChecker {
        private volatile String logMessageId;

        protected DefaultRejectAttributeChecker() {
        }

        @Override
        public boolean rejectOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            return this.rejectAttribute(address, attributeName, attributeValue, context);
        }

        @Override
        public boolean rejectResourceAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return this.rejectAttribute(address, attributeName, attributeValue, context);
        }

        protected abstract boolean rejectAttribute(PathAddress var1, String var2, ModelNode var3, TransformationContext var4);

        @Override
        public String getRejectionLogMessageId() {
            String id = this.logMessageId;
            if (id == null) {
                id = this.getRejectionLogMessage(Collections.<String, ModelNode>emptyMap());
            }
            this.logMessageId = id;
            return this.logMessageId;
        }
    }
}

