/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.lob;

import java.io.IOException;
import java.io.InputStream;
import org.teiid.client.lob.LobChunk;
import org.teiid.client.lob.LobChunkProducer;
import org.teiid.core.CorePlugin;

public class LobChunkInputStream
extends InputStream {
    private LobChunkProducer reader;
    private byte[] byteData = null;
    private int currentCounter = 0;
    private boolean lastChunk = false;
    private boolean closed = false;

    public LobChunkInputStream(LobChunkProducer reader) {
        this.reader = reader;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IllegalStateException(CorePlugin.Util.getString("stream_closed"));
        }
        while (this.byteData == null || this.byteData.length <= this.currentCounter) {
            if (this.lastChunk) {
                return -1;
            }
            LobChunk value = this.reader.getNextChunk();
            this.lastChunk = value.isLast();
            this.byteData = value.getBytes();
            this.currentCounter = 0;
        }
        return this.byteData[this.currentCounter++] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.reader.close();
    }
}

