/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.teiid.core.util.StringUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;
import org.teiid.translator.TypeFacility;

public class JDBCMetdataProcessor {
    private boolean importProcedures;
    private boolean importKeys = true;
    private boolean importIndexes;
    private String procedureNamePattern;
    private boolean useFullSchemaName = true;
    private String[] tableTypes;
    private String tableNamePattern;
    private String catalog;
    private String schemaPattern;
    private boolean importApproximateIndexes = true;
    private boolean widenUnsingedTypes = true;
    private boolean quoteNameInSource = true;
    private boolean useProcedureSpecificName;
    private boolean useCatalogName = true;
    private boolean autoCreateUniqueConstraints = true;
    private boolean useQualifiedName = true;
    private Set<String> unsignedTypes = new HashSet<String>();
    private String quoteString;
    private Pattern excludeTables;
    private Pattern excludeProcedures;
    private int excludedTables;

    public void getConnectorMetadata(Connection conn, MetadataFactory metadataFactory) throws SQLException {
        DatabaseMetaData metadata = conn.getMetaData();
        this.quoteString = metadata.getIdentifierQuoteString();
        if (this.quoteString != null && this.quoteString.trim().length() == 0) {
            this.quoteString = null;
        }
        if (this.widenUnsingedTypes) {
            ResultSet rs = metadata.getTypeInfo();
            while (rs.next()) {
                String name = rs.getString(1);
                boolean unsigned = rs.getBoolean(10);
                if (!unsigned) continue;
                this.unsignedTypes.add(name);
            }
        }
        Map<String, TableInfo> tableMap = this.getTables(metadataFactory, metadata);
        LinkedHashSet<TableInfo> tables = new LinkedHashSet<TableInfo>(tableMap.values());
        if (this.importKeys) {
            this.getPrimaryKeys(metadataFactory, metadata, tables);
            this.getIndexes(metadataFactory, metadata, tables, !this.importIndexes);
            this.getForeignKeys(metadataFactory, metadata, tables, tableMap);
        } else if (this.importIndexes) {
            this.getIndexes(metadataFactory, metadata, tables, false);
        }
        if (this.importProcedures) {
            this.getProcedures(metadataFactory, metadata);
        }
    }

    private void getProcedures(MetadataFactory metadataFactory, DatabaseMetaData metadata) throws SQLException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"JDBCMetadataProcessor - Importing procedures"});
        ResultSet procedures = metadata.getProcedures(this.catalog, this.schemaPattern, this.procedureNamePattern);
        int rsColumns = procedures.getMetaData().getColumnCount();
        while (procedures.next()) {
            String procedureName;
            String procedureCatalog = procedures.getString(1);
            String procedureSchema = procedures.getString(2);
            String nameInSource = procedureName = procedures.getString(3);
            if (this.useProcedureSpecificName && rsColumns >= 9 && (procedureName = procedures.getString(9)) == null) {
                procedureName = nameInSource;
            }
            String fullProcedureName = this.getFullyQualifiedName(procedureCatalog, procedureSchema, procedureName);
            if (this.excludeProcedures != null && this.excludeProcedures.matcher(fullProcedureName).matches()) continue;
            Procedure procedure = metadataFactory.addProcedure(this.useFullSchemaName ? fullProcedureName : procedureName);
            procedure.setNameInSource(this.getFullyQualifiedName(procedureCatalog, procedureSchema, nameInSource, true));
            ResultSet columns = metadata.getProcedureColumns(this.catalog, procedureSchema, procedureName, null);
            block8: while (columns.next()) {
                String columnName = columns.getString(4);
                short columnType = columns.getShort(5);
                int sqlType = columns.getInt(6);
                String typeName = columns.getString(7);
                sqlType = this.checkForUnsigned(sqlType, typeName);
                if (columnType == 0) continue;
                ProcedureParameter record = null;
                int precision = columns.getInt(8);
                String runtimeType = this.getRuntimeType(sqlType, typeName, precision);
                switch (columnType) {
                    case 3: {
                        Column column = metadataFactory.addProcedureResultSetColumn(columnName, runtimeType, procedure);
                        record = column;
                        column.setNativeType(typeName);
                        break;
                    }
                    case 1: {
                        record = metadataFactory.addProcedureParameter(columnName, runtimeType, ProcedureParameter.Type.In, procedure);
                        break;
                    }
                    case 2: {
                        record = metadataFactory.addProcedureParameter(columnName, runtimeType, ProcedureParameter.Type.InOut, procedure);
                        break;
                    }
                    case 4: {
                        record = metadataFactory.addProcedureParameter(columnName, runtimeType, ProcedureParameter.Type.Out, procedure);
                        break;
                    }
                    case 5: {
                        record = metadataFactory.addProcedureParameter(columnName, runtimeType, ProcedureParameter.Type.ReturnValue, procedure);
                        break;
                    }
                    default: {
                        continue block8;
                    }
                }
                record.setPrecision(columns.getInt(8));
                record.setLength(columns.getInt(9));
                record.setScale(columns.getInt(10));
                record.setRadix(columns.getInt(11));
                record.setNullType(BaseColumn.NullType.values()[columns.getShort(12)]);
                record.setAnnotation(columns.getString(13));
            }
        }
        procedures.close();
    }

    private int checkForUnsigned(int sqlType, String typeName) {
        if (this.widenUnsingedTypes && this.unsignedTypes.contains(typeName)) {
            switch (sqlType) {
                case -6: {
                    sqlType = 5;
                    break;
                }
                case 5: {
                    sqlType = 4;
                    break;
                }
                case 4: {
                    sqlType = -5;
                }
            }
        }
        return sqlType;
    }

    private Map<String, TableInfo> getTables(MetadataFactory metadataFactory, DatabaseMetaData metadata) throws SQLException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"JDBCMetadataProcessor - Importing tables"});
        ResultSet tables = metadata.getTables(this.catalog, this.schemaPattern, this.tableNamePattern, this.tableTypes);
        HashMap<String, TableInfo> tableMap = new HashMap<String, TableInfo>();
        while (tables.next()) {
            String fullName;
            String remarks;
            String tableName;
            String tableSchema;
            String tableCatalog = tables.getString(1);
            Table table = this.addTable(metadataFactory, tableCatalog, tableSchema = tables.getString(2), tableName = tables.getString(3), remarks = tables.getString(5), fullName = this.getFullyQualifiedName(tableCatalog, tableSchema, tableName));
            if (table == null) continue;
            TableInfo ti = new TableInfo(tableCatalog, tableSchema, tableName, table);
            tableMap.put(fullName, ti);
            tableMap.put(tableName, ti);
        }
        tables.close();
        this.getColumns(metadataFactory, metadata, tableMap);
        return tableMap;
    }

    protected Table addTable(MetadataFactory metadataFactory, String tableCatalog, String tableSchema, String tableName, String remarks, String fullName) {
        if (this.excludeTables != null && this.excludeTables.matcher(fullName).matches()) {
            ++this.excludedTables;
            return null;
        }
        Table table = metadataFactory.addTable(this.useFullSchemaName ? fullName : tableName);
        table.setNameInSource(this.getFullyQualifiedName(tableCatalog, tableSchema, tableName, true));
        table.setSupportsUpdate(true);
        table.setAnnotation(remarks);
        return table;
    }

    private void getColumns(MetadataFactory metadataFactory, DatabaseMetaData metadata, Map<String, TableInfo> tableMap) throws SQLException {
        boolean singleSchema;
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"JDBCMetadataProcessor - Importing columns"});
        boolean bl = singleSchema = this.schemaPattern != null && !this.schemaPattern.contains("_") && !this.schemaPattern.contains("%");
        if (this.excludeTables == null && this.schemaPattern == null && this.tableNamePattern == null || singleSchema && this.tableNamePattern == null && (this.excludeTables == null || (double)(tableMap.size() / 2) > Math.sqrt(tableMap.size() / 2 + this.excludedTables))) {
            ResultSet columns = metadata.getColumns(this.catalog, this.schemaPattern, this.tableNamePattern, null);
            this.processColumns(metadataFactory, tableMap, columns);
        } else {
            for (TableInfo ti : new LinkedHashSet<TableInfo>(tableMap.values())) {
                ResultSet columns = metadata.getColumns(ti.catalog, ti.schema, ti.name, null);
                this.processColumns(metadataFactory, tableMap, columns);
            }
        }
    }

    private void processColumns(MetadataFactory metadataFactory, Map<String, TableInfo> tableMap, ResultSet columns) throws SQLException {
        int rsColumns = columns.getMetaData().getColumnCount();
        while (columns.next()) {
            String tableName;
            String tableSchema;
            String tableCatalog = columns.getString(1);
            String fullTableName = this.getFullyQualifiedName(tableCatalog, tableSchema = columns.getString(2), tableName = columns.getString(3));
            TableInfo tableInfo = tableMap.get(fullTableName);
            if (tableInfo == null && (tableInfo = tableMap.get(tableName)) == null) continue;
            this.addColumn(columns, tableInfo.table, metadataFactory, rsColumns);
        }
        columns.close();
    }

    protected Column addColumn(ResultSet columns, Table table, MetadataFactory metadataFactory, int rsColumns) throws SQLException {
        String columnName = columns.getString(4);
        int type = columns.getInt(5);
        String typeName = columns.getString(6);
        int columnSize = columns.getInt(7);
        String runtimeType = this.getRuntimeType(type, typeName, columnSize);
        Column column = metadataFactory.addColumn(columnName, runtimeType, (ColumnSet)table);
        column.setNameInSource(this.quoteName(columnName));
        column.setPrecision(columnSize);
        column.setLength(columnSize);
        column.setNativeType(typeName);
        column.setRadix(columns.getInt(10));
        column.setNullType(BaseColumn.NullType.values()[columns.getShort(11)]);
        column.setUpdatable(true);
        String remarks = columns.getString(12);
        column.setAnnotation(remarks);
        String defaultValue = columns.getString(13);
        column.setDefaultValue(defaultValue);
        if (defaultValue != null && type == -7 && "boolean".equals(runtimeType)) {
            if (defaultValue.length() == 1) {
                char charIntVal = defaultValue.charAt(0);
                if (charIntVal == '\u0000') {
                    column.setDefaultValue(Boolean.FALSE.toString());
                } else if (charIntVal == '\u0001') {
                    column.setDefaultValue(Boolean.TRUE.toString());
                }
            } else {
                String trimedDefault = defaultValue.trim();
                if (defaultValue.startsWith("(") && defaultValue.endsWith(")")) {
                    trimedDefault = defaultValue.substring(1, defaultValue.length() - 1);
                }
                column.setDefaultValue(trimedDefault);
            }
        }
        column.setCharOctetLength(columns.getInt(16));
        if (rsColumns >= 23) {
            column.setAutoIncremented("YES".equalsIgnoreCase(columns.getString(23)));
        }
        return column;
    }

    protected String getRuntimeType(int type, String typeName, int precision) {
        if (type == -7 && precision > 1) {
            type = -2;
        }
        type = this.checkForUnsigned(type, typeName);
        return TypeFacility.getDataTypeNameFromSQLType((int)type);
    }

    protected String quoteName(String name) {
        if (this.quoteNameInSource && this.quoteString != null) {
            return this.quoteString + StringUtil.replaceAll((String)name, (String)this.quoteString, (String)(this.quoteString + this.quoteString)) + this.quoteString;
        }
        return name;
    }

    private void getPrimaryKeys(MetadataFactory metadataFactory, DatabaseMetaData metadata, Collection<TableInfo> tables) throws SQLException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"JDBCMetadataProcessor - Importing primary keys"});
        for (TableInfo tableInfo : tables) {
            ResultSet pks = metadata.getPrimaryKeys(tableInfo.catalog, tableInfo.schema, tableInfo.name);
            TreeMap<Short, String> keyColumns = null;
            String pkName = null;
            while (pks.next()) {
                String columnName = pks.getString(4);
                short seqNum = pks.getShort(5);
                if (keyColumns == null) {
                    keyColumns = new TreeMap<Short, String>();
                }
                keyColumns.put(seqNum, columnName);
                if (pkName != null || (pkName = pks.getString(6)) != null) continue;
                pkName = "PK_" + tableInfo.table.getName().toUpperCase();
            }
            if (keyColumns != null) {
                metadataFactory.addPrimaryKey(pkName, new ArrayList(keyColumns.values()), tableInfo.table);
            }
            pks.close();
        }
    }

    private void getForeignKeys(MetadataFactory metadataFactory, DatabaseMetaData metadata, Collection<TableInfo> tables, Map<String, TableInfo> tableMap) throws SQLException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"JDBCMetadataProcessor - Importing foreign keys"});
        for (TableInfo tableInfo : tables) {
            ResultSet fks = metadata.getImportedKeys(tableInfo.catalog, tableInfo.schema, tableInfo.name);
            TreeMap<Short, String> keyColumns = null;
            TreeMap<Short, String> referencedKeyColumns = null;
            String fkName = null;
            TableInfo pkTable = null;
            short savedSeqNum = Short.MAX_VALUE;
            while (fks.next()) {
                String tableName;
                String tableSchema;
                String tableCatalog;
                String fullTableName;
                String columnName = fks.getString(8);
                short seqNum = fks.getShort(9);
                String pkColumnName = fks.getString(4);
                if (seqNum <= savedSeqNum) {
                    if (keyColumns != null) {
                        KeyRecord record = this.autoCreateUniqueKeys(this.autoCreateUniqueConstraints, metadataFactory, fkName, referencedKeyColumns, pkTable.table);
                        ForeignKey fk = metadataFactory.addForiegnKey(fkName, new ArrayList(keyColumns.values()), new ArrayList<String>(referencedKeyColumns.values()), pkTable.table.getName(), tableInfo.table);
                        if (record != null) {
                            fk.setPrimaryKey(record);
                        }
                    }
                    keyColumns = new TreeMap<Short, String>();
                    referencedKeyColumns = new TreeMap<Short, String>();
                    fkName = null;
                }
                savedSeqNum = seqNum;
                keyColumns.put(seqNum, columnName);
                referencedKeyColumns.put(seqNum, pkColumnName);
                if (fkName != null || (pkTable = tableMap.get(fullTableName = this.getFullyQualifiedName(tableCatalog = fks.getString(1), tableSchema = fks.getString(2), tableName = fks.getString(3)))) == null || (fkName = fks.getString(12)) != null) continue;
                fkName = "FK_" + tableInfo.table.getName().toUpperCase();
            }
            if (keyColumns != null) {
                KeyRecord record = this.autoCreateUniqueKeys(this.autoCreateUniqueConstraints, metadataFactory, fkName, referencedKeyColumns, pkTable.table);
                ForeignKey fk = metadataFactory.addForiegnKey(fkName, new ArrayList(keyColumns.values()), new ArrayList(referencedKeyColumns.values()), pkTable.table.getName(), tableInfo.table);
                if (record != null) {
                    fk.setPrimaryKey(record);
                }
            }
            fks.close();
        }
    }

    private KeyRecord autoCreateUniqueKeys(boolean create, MetadataFactory factory, String name, TreeMap<Short, String> referencedKeyColumns, Table pkTable) {
        if (referencedKeyColumns != null && pkTable.getPrimaryKey() == null && pkTable.getUniqueKeys().isEmpty()) {
            factory.addIndex(name + "_unique", false, new ArrayList<String>(referencedKeyColumns.values()), pkTable);
        }
        KeyRecord uniqueKey = null;
        if (referencedKeyColumns == null) {
            uniqueKey = pkTable.getPrimaryKey();
        } else {
            for (KeyRecord record : pkTable.getUniqueKeys()) {
                if (!this.keyMatches(new ArrayList<String>(referencedKeyColumns.values()), record)) continue;
                uniqueKey = record;
                break;
            }
            if (uniqueKey == null && pkTable.getPrimaryKey() != null && this.keyMatches(new ArrayList<String>(referencedKeyColumns.values()), pkTable.getPrimaryKey())) {
                uniqueKey = pkTable.getPrimaryKey();
            }
        }
        if (uniqueKey == null && create) {
            uniqueKey = factory.addIndex(name + "_unique", false, new ArrayList<String>(referencedKeyColumns.values()), pkTable);
        }
        return uniqueKey;
    }

    private boolean keyMatches(List<String> names, KeyRecord record) {
        if (names.size() != record.getColumns().size()) {
            return false;
        }
        for (int i = 0; i < names.size(); ++i) {
            if (names.get(i).equals(((Column)record.getColumns().get(i)).getName())) continue;
            return false;
        }
        return true;
    }

    void getIndexes(MetadataFactory metadataFactory, DatabaseMetaData metadata, Collection<TableInfo> tables, boolean uniqueOnly) throws SQLException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"JDBCMetadataProcessor - Importing index info"});
        for (TableInfo tableInfo : tables) {
            ResultSet indexInfo = metadata.getIndexInfo(tableInfo.catalog, tableInfo.schema, tableInfo.name, uniqueOnly, this.importApproximateIndexes);
            TreeMap<Short, String> indexColumns = null;
            String indexName = null;
            short savedOrdinalPosition = Short.MAX_VALUE;
            boolean nonUnique = false;
            boolean valid = true;
            while (indexInfo.next()) {
                short type = indexInfo.getShort(7);
                if (type == 0) {
                    tableInfo.table.setCardinality(indexInfo.getInt(11));
                    continue;
                }
                short ordinalPosition = indexInfo.getShort(8);
                if (ordinalPosition <= savedOrdinalPosition) {
                    if (!(!valid || indexColumns == null || uniqueOnly && nonUnique)) {
                        metadataFactory.addIndex(indexName, nonUnique, new ArrayList(indexColumns.values()), tableInfo.table);
                    }
                    indexColumns = new TreeMap<Short, String>();
                    indexName = null;
                    valid = true;
                }
                savedOrdinalPosition = ordinalPosition;
                String columnName = indexInfo.getString(9);
                if (valid && columnName == null || tableInfo.table.getColumnByName(columnName) == null) {
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Skipping the import of non-simple index", indexInfo.getString(6)});
                    valid = false;
                }
                nonUnique = indexInfo.getBoolean(4);
                indexColumns.put(ordinalPosition, columnName);
                if (indexName != null || (indexName = indexInfo.getString(6)) != null) continue;
                indexName = "NDX_" + tableInfo.table.getName().toUpperCase();
            }
            if (!(!valid || indexColumns == null || uniqueOnly && nonUnique)) {
                metadataFactory.addIndex(indexName, nonUnique, new ArrayList(indexColumns.values()), tableInfo.table);
            }
            indexInfo.close();
        }
    }

    private String getFullyQualifiedName(String catalogName, String schemaName, String objectName) {
        return this.getFullyQualifiedName(catalogName, schemaName, objectName, false);
    }

    private String getFullyQualifiedName(String catalogName, String schemaName, String objectName, boolean quoted) {
        String fullName;
        String string = fullName = quoted ? this.quoteName(objectName) : objectName;
        if (this.useQualifiedName) {
            if (schemaName != null && schemaName.length() > 0) {
                fullName = (quoted ? this.quoteName(schemaName) : schemaName) + '.' + fullName;
            }
            if (this.useCatalogName && catalogName != null && catalogName.length() > 0) {
                fullName = (quoted ? this.quoteName(catalogName) : catalogName) + '.' + fullName;
            }
        }
        return fullName;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setTableTypes(String[] tableTypes) {
        this.tableTypes = tableTypes;
    }

    public void setUseFullSchemaName(boolean useFullSchemaName) {
        this.useFullSchemaName = useFullSchemaName;
    }

    public void setProcedureNamePattern(String procedureNamePattern) {
        this.procedureNamePattern = procedureNamePattern;
    }

    public void setImportIndexes(boolean importIndexes) {
        this.importIndexes = importIndexes;
    }

    public void setImportKeys(boolean importKeys) {
        this.importKeys = importKeys;
    }

    public void setImportProcedures(boolean importProcedures) {
        this.importProcedures = importProcedures;
    }

    public void setImportApproximateIndexes(boolean importApproximateIndexes) {
        this.importApproximateIndexes = importApproximateIndexes;
    }

    public void setWidenUnsingedTypes(boolean widenUnsingedTypes) {
        this.widenUnsingedTypes = widenUnsingedTypes;
    }

    public void setQuoteNameInSource(boolean quoteIdentifiers) {
        this.quoteNameInSource = quoteIdentifiers;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchemaPattern(String schema) {
        this.schemaPattern = schema;
    }

    public void setUseProcedureSpecificName(boolean useProcedureSpecificName) {
        this.useProcedureSpecificName = useProcedureSpecificName;
    }

    public void setUseCatalogName(boolean useCatalog) {
        this.useCatalogName = useCatalog;
    }

    public void setAutoCreateUniqueConstraints(boolean autoCreateUniqueConstraints) {
        this.autoCreateUniqueConstraints = autoCreateUniqueConstraints;
    }

    public void setExcludeProcedures(String excludeProcedures) {
        this.excludeProcedures = Pattern.compile(excludeProcedures, 34);
    }

    public void setExcludeTables(String excludeTables) {
        this.excludeTables = Pattern.compile(excludeTables, 34);
    }

    public void setUseQualifiedName(boolean useQualifiedName) {
        this.useQualifiedName = useQualifiedName;
    }

    static class TableInfo {
        private String catalog;
        private String schema;
        private String name;
        private Table table;

        public TableInfo(String catalog, String schema, String name, Table table) {
            this.catalog = catalog;
            this.schema = schema;
            this.name = name;
            this.table = table;
        }
    }
}

