/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.util.List;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.Parameter;
import org.teiid.language.visitor.CollectorVisitor;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.SQLConversionVisitor;

public class TranslatedCommand {
    private String sql;
    private boolean prepared;
    private List preparedValues;
    private JDBCExecutionFactory executionFactory;
    private ExecutionContext context;

    public TranslatedCommand(ExecutionContext context, JDBCExecutionFactory executionFactory) {
        this.executionFactory = executionFactory;
        this.context = context;
    }

    public void translateCommand(Command command) throws TranslatorException {
        SQLConversionVisitor sqlConversionVisitor = this.executionFactory.getSQLConversionVisitor();
        sqlConversionVisitor.setExecutionContext(this.context);
        if (this.executionFactory.usePreparedStatements() || this.hasBindValue(command)) {
            sqlConversionVisitor.setPrepared(true);
        }
        sqlConversionVisitor.append((LanguageObject)command);
        this.sql = sqlConversionVisitor.toString();
        this.preparedValues = sqlConversionVisitor.getPreparedValues();
        this.prepared = sqlConversionVisitor.isPrepared();
    }

    private boolean hasBindValue(Command command) {
        if (!CollectorVisitor.collectObjects(Parameter.class, (LanguageObject)command).isEmpty()) {
            return true;
        }
        for (Literal l : CollectorVisitor.collectObjects(Literal.class, (LanguageObject)command)) {
            if (!TranslatedCommand.isBindEligible(l)) continue;
            return true;
        }
        return false;
    }

    static boolean isBindEligible(Literal l) {
        return TypeFacility.RUNTIME_TYPES.XML.equals(l.getType()) || TypeFacility.RUNTIME_TYPES.CLOB.equals(l.getType()) || TypeFacility.RUNTIME_TYPES.BLOB.equals(l.getType()) || TypeFacility.RUNTIME_TYPES.OBJECT.equals(l.getType());
    }

    public List getPreparedValues() {
        return this.preparedValues;
    }

    public String getSql() {
        return this.sql;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.prepared) {
            sb.append("Prepared Values: ").append(this.preparedValues).append(" ");
        }
        sb.append("SQL: ").append(this.sql);
        return sb.toString();
    }
}

