/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.access;

import java.util.ArrayList;
import java.util.List;
import org.teiid.language.AggregateFunction;
import org.teiid.language.Function;
import org.teiid.language.LanguageObject;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.sybase.BaseSybaseExecutionFactory;

@Translator(name="access", description="A translator for Microsoft Access Database")
public class AccessExecutionFactory
extends BaseSybaseExecutionFactory {
    public AccessExecutionFactory() {
        this.setSupportsOrderBy(false);
        this.setMaxInCriteriaSize(1000);
        this.setMaxDependentInPredicates(10);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("ascii", new AliasModifier("Asc"));
        this.registerFunctionModifier("char", new AliasModifier("Chr"));
        this.registerFunctionModifier("concat", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                ArrayList<String> result = new ArrayList<String>(function.getParameters().size() * 2 - 1);
                for (int i = 0; i < function.getParameters().size(); ++i) {
                    if (i > 0) {
                        result.add(" & ");
                    }
                    result.add((String)function.getParameters().get(i));
                }
                return result;
            }
        });
        this.registerFunctionModifier("length", new AliasModifier("Len"));
    }

    @Override
    public String translateLiteralBoolean(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return "-1";
        }
        return "0";
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        if (obj instanceof AggregateFunction) {
            AggregateFunction af = (AggregateFunction)obj;
            if (af.getName().equals("STDDEV_POP")) {
                af.setName("StDevP");
            } else if (af.getName().equals("STDDEV_SAMP")) {
                af.setName("StDev");
            } else if (af.getName().equals("VAR_POP")) {
                af.setName("VarP");
            } else if (af.getName().equals("VAR_SAMP")) {
                af.setName("Var");
            }
        }
        return super.translate(obj, context);
    }

    @Override
    public boolean addSourceComment() {
        return false;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("exp");
        supportedFunctions.add("ascii");
        supportedFunctions.add("char");
        supportedFunctions.add("concat");
        supportedFunctions.add("lcase");
        supportedFunctions.add("left");
        supportedFunctions.add("length");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("right");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("trim");
        supportedFunctions.add("ucase");
        return supportedFunctions;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }
}

