/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.mysql;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Literal;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.mysql.MySQLExecutionFactory;

@Translator(name="mysql5", description="A translator for open source MySQL5 Database")
public class MySQL5ExecutionFactory
extends MySQLExecutionFactory {
    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("char", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("char(", function.getParameters().get(0), " USING ASCII)");
            }
        });
        this.registerFunctionModifier("timestampadd", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                Literal intervalType = (Literal)function.getParameters().get(0);
                String interval = ((String)intervalType.getValue()).toUpperCase();
                if (interval.equals("SQL_TSI_FRAC_SECOND")) {
                    intervalType.setValue((Object)"MICROSECOND");
                    Expression[] args = new Expression[]{(Expression)function.getParameters().get(1), MySQL5ExecutionFactory.this.getLanguageFactory().createLiteral((Object)1000, TypeFacility.RUNTIME_TYPES.INTEGER)};
                    function.getParameters().set(1, MySQL5ExecutionFactory.this.getLanguageFactory().createFunction("/", args, TypeFacility.RUNTIME_TYPES.INTEGER));
                }
                return null;
            }
        });
        this.addPushDownFunction("mysql", "timestampdiff", "integer", new String[]{"string", "timestamp", "timestamp"});
        this.registerFunctionModifier("timestampdiff", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                Literal intervalType = (Literal)function.getParameters().get(0);
                String interval = ((String)intervalType.getValue()).toUpperCase();
                if (interval.equals("SQL_TSI_FRAC_SECOND")) {
                    intervalType.setValue((Object)"MICROSECOND");
                    return Arrays.asList(function, " * 1000");
                }
                return null;
            }
        });
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("timestampadd");
        return supportedFunctions;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    public boolean supportsLikeRegex() {
        return true;
    }

    @Override
    public String getLikeRegexString() {
        return "REGEXP";
    }

    @Override
    public Object retrieveValue(ResultSet results, int columnIndex, Class<?> expectedType) throws SQLException {
        Object result = super.retrieveValue(results, columnIndex, expectedType);
        if (expectedType == TypeFacility.RUNTIME_TYPES.STRING && (result instanceof Blob || result instanceof byte[])) {
            return results.getString(columnIndex);
        }
        return result;
    }

    @Override
    public Object retrieveValue(CallableStatement results, int parameterIndex, Class<?> expectedType) throws SQLException {
        Object result = super.retrieveValue(results, parameterIndex, expectedType);
        if (expectedType == TypeFacility.RUNTIME_TYPES.STRING && (result instanceof Blob || result instanceof byte[])) {
            return results.getString(parameterIndex);
        }
        return result;
    }
}

