/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.teiid;

import java.util.ArrayList;
import java.util.List;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.Version;

@Translator(name="teiid", description="A translator for Teiid 7.0 or later")
public class TeiidExecutionFactory
extends JDBCExecutionFactory {
    public static final Version SEVEN_0 = Version.getVersion("7.0");
    public static final Version SEVEN_1 = Version.getVersion("7.1");
    public static final Version SEVEN_2 = Version.getVersion("7.2");
    public static final Version SEVEN_3 = Version.getVersion("7.3");
    public static final Version SEVEN_4 = Version.getVersion("7.4");
    public static final Version SEVEN_5 = Version.getVersion("7.5");
    public static final Version SEVEN_6 = Version.getVersion("7.6");
    public static final Version EIGHT_3 = Version.getVersion("8.3");

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ABS");
        supportedFunctions.add("ACOS");
        supportedFunctions.add("ASIN");
        supportedFunctions.add("ATAN");
        supportedFunctions.add("ATAN2");
        supportedFunctions.add("CEILING");
        supportedFunctions.add("COS");
        supportedFunctions.add("COT");
        supportedFunctions.add("DEGREES");
        supportedFunctions.add("EXP");
        supportedFunctions.add("FLOOR");
        supportedFunctions.add("FORMATBIGDECIMAL");
        supportedFunctions.add("FORMATBIGINTEGER");
        supportedFunctions.add("FORMATDOUBLE");
        supportedFunctions.add("FORMATFLOAT");
        supportedFunctions.add("FORMATINTEGER");
        supportedFunctions.add("FORMATLONG");
        supportedFunctions.add("LOG");
        supportedFunctions.add("LOG10");
        supportedFunctions.add("MOD");
        supportedFunctions.add("PARSEBIGDECIMAL");
        supportedFunctions.add("PARSEBIGINTEGER");
        supportedFunctions.add("PARSEDOUBLE");
        supportedFunctions.add("PARSEFLOAT");
        supportedFunctions.add("PARSEINTEGER");
        supportedFunctions.add("PARSELONG");
        supportedFunctions.add("PI");
        supportedFunctions.add("POWER");
        supportedFunctions.add("RADIANS");
        supportedFunctions.add("RAND");
        supportedFunctions.add("ROUND");
        supportedFunctions.add("SIGN");
        supportedFunctions.add("SIN");
        supportedFunctions.add("SQRT");
        supportedFunctions.add("TAN");
        supportedFunctions.add("ASCII");
        supportedFunctions.add("CHAR");
        supportedFunctions.add("CHR");
        supportedFunctions.add("CONCAT");
        supportedFunctions.add("CONCAT2");
        supportedFunctions.add("||");
        supportedFunctions.add("INITCAP");
        supportedFunctions.add("INSERT");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LOCATE");
        supportedFunctions.add("LPAD");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("REPEAT");
        supportedFunctions.add("REPLACE");
        supportedFunctions.add("RPAD");
        supportedFunctions.add("RIGHT");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SUBSTRING");
        supportedFunctions.add("TRANSLATE");
        supportedFunctions.add("UCASE");
        supportedFunctions.add("CURDATE");
        supportedFunctions.add("CURTIME");
        supportedFunctions.add("NOW");
        supportedFunctions.add("DAYNAME");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("DAYOFWEEK");
        supportedFunctions.add("DAYOFYEAR");
        supportedFunctions.add("FORMATDATE");
        supportedFunctions.add("FORMATTIME");
        supportedFunctions.add("FORMATTIMESTAMP");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("MONTHNAME");
        supportedFunctions.add("PARSEDATE");
        supportedFunctions.add("PARSETIME");
        supportedFunctions.add("PARSETIMESTAMP");
        supportedFunctions.add("SECOND");
        supportedFunctions.add("TIMESTAMPADD");
        supportedFunctions.add("TIMESTAMPDIFF");
        supportedFunctions.add("WEEK");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("MODIFYTIMEZONE");
        supportedFunctions.add("DECODESTRING");
        supportedFunctions.add("DECODEINTEGER");
        supportedFunctions.add("IFNULL");
        supportedFunctions.add("NVL");
        supportedFunctions.add("CAST");
        supportedFunctions.add("CONVERT");
        supportedFunctions.add("USER");
        supportedFunctions.add("FROM_UNIXTIME");
        supportedFunctions.add("NULLIF");
        supportedFunctions.add("COALESCE");
        if (this.getVersion().compareTo(SEVEN_3) >= 0) {
            supportedFunctions.add("unescape");
        }
        if (this.getVersion().compareTo(SEVEN_4) >= 0) {
            supportedFunctions.add("uuid");
            supportedFunctions.add("array_get");
            supportedFunctions.add("array_length");
        }
        if (this.getVersion().compareTo(SEVEN_5) >= 0) {
            supportedFunctions.add("trim");
        }
        if (this.getVersion().compareTo(EIGHT_3) >= 0) {
            supportedFunctions.add("endswith");
        }
        return supportedFunctions;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsFunctionsInGroupBy() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return this.getVersion().compareTo(SEVEN_1) >= 0;
    }

    @Override
    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        return ExecutionFactory.NullOrder.UNKNOWN;
    }

    @Override
    public boolean supportsBulkUpdate() {
        return true;
    }

    public boolean supportsCommonTableExpressions() {
        return this.getVersion().compareTo(SEVEN_2) >= 0;
    }

    public boolean supportsAdvancedOlapOperations() {
        return this.getVersion().compareTo(SEVEN_5) >= 0;
    }

    public boolean supportsElementaryOlapOperations() {
        return this.getVersion().compareTo(SEVEN_5) >= 0;
    }

    public boolean supportsArrayAgg() {
        return this.getVersion().compareTo(SEVEN_5) >= 0;
    }

    public boolean supportsLikeRegex() {
        return this.getVersion().compareTo(SEVEN_5) >= 0;
    }

    public boolean supportsSimilarTo() {
        return this.getVersion().compareTo(SEVEN_5) >= 0;
    }

    public boolean supportsWindowDistinctAggregates() {
        return this.getVersion().compareTo(SEVEN_6) >= 0;
    }

    public boolean supportsWindowOrderByWithAggregates() {
        return this.getVersion().compareTo(SEVEN_5) >= 0;
    }

    public boolean supportsFormatLiteral(String literal, ExecutionFactory.Format format) {
        return true;
    }

    @Override
    public boolean supportsGeneratedKeys() {
        return this.getVersion().compareTo(EIGHT_3) >= 0;
    }

    @Override
    public boolean supportsInsertWithQueryExpression() {
        return true;
    }

    public boolean supportsOrderByNullOrdering() {
        return true;
    }

    @Override
    protected boolean usesDatabaseVersion() {
        return true;
    }
}

