/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.teiid.core.CorePlugin;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;

public class StringToSQLXMLTransform
extends Transform {
    @Override
    public Object transformDirect(Object value) throws TransformationException {
        String xml = (String)value;
        StringReader reader = new StringReader(xml);
        XMLType.Type type = StringToSQLXMLTransform.isXml(reader);
        XMLType result = new XMLType(new SQLXMLImpl(xml));
        result.setType(type);
        return result;
    }

    public static XMLType.Type isXml(Reader reader) throws TransformationException {
        XMLType.Type type = XMLType.Type.ELEMENT;
        XMLInputFactory inputFactory = XMLType.getXmlInputFactory();
        try {
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(reader);
            int event = xmlReader.getEventType();
            if (event == 7 && xmlReader.getLocation().getColumnNumber() != 1) {
                type = XMLType.Type.DOCUMENT;
            }
            while (xmlReader.hasNext()) {
                xmlReader.next();
            }
        }
        catch (Exception e) {
            throw new TransformationException(CorePlugin.Event.TEIID10070, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10070, new Object[0]));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
        return type;
    }

    @Override
    public Class<?> getSourceType() {
        return DataTypeManager.DefaultDataClasses.STRING;
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.XML;
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

