/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.jdbc.ContinuousStatementCallback;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.StatementCallback;
import org.teiid.jdbc.StatementImpl;

public class NonBlockingRowProcessor
implements ResultsFuture.CompletionListener<Boolean> {
    private static Logger logger = Logger.getLogger(NonBlockingRowProcessor.class.getName());
    private StatementImpl stmt;
    private StatementCallback callback;

    public NonBlockingRowProcessor(StatementImpl stmt, StatementCallback callback) {
        this.stmt = stmt;
        this.callback = callback;
    }

    @Override
    public void onCompletion(ResultsFuture<Boolean> future) {
        try {
            boolean hasResultSet = future.get();
            if (!hasResultSet) {
                this.callback.onComplete(this.stmt);
                return;
            }
            final ResultSetImpl resultSet = this.stmt.getResultSet();
            resultSet.asynch = true;
            Runnable rowProcessor = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ResultsFuture<Boolean> hasNext;
                        do {
                            if (NonBlockingRowProcessor.this.stmt.isClosed()) {
                                NonBlockingRowProcessor.this.callback.onComplete(NonBlockingRowProcessor.this.stmt);
                                break;
                            }
                            ResultsFuture<Boolean> resultsFuture = hasNext = resultSet.submitNext();
                            synchronized (resultsFuture) {
                                if (!hasNext.isDone()) {
                                    hasNext.addCompletionListener(new ResultsFuture.CompletionListener<Boolean>(){

                                        @Override
                                        public void onCompletion(ResultsFuture<Boolean> f) {
                                            if (NonBlockingRowProcessor.this.processRow(f)) {
                                                this.run();
                                            }
                                        }
                                    });
                                    break;
                                }
                            }
                        } while (NonBlockingRowProcessor.this.processRow(hasNext));
                    }
                    catch (Exception e) {
                        NonBlockingRowProcessor.this.onException(e);
                    }
                }
            };
            rowProcessor.run();
        }
        catch (Exception e) {
            this.onException(e);
        }
    }

    boolean processRow(ResultsFuture<Boolean> hasNext) {
        try {
            if (!hasNext.get().booleanValue()) {
                this.callback.onComplete(this.stmt);
                return false;
            }
            List<?> row = this.stmt.getResultSet().getCurrentRecord();
            if (row == null) {
                if (this.callback instanceof ContinuousStatementCallback) {
                    ((ContinuousStatementCallback)this.callback).beforeNextExecution(this.stmt);
                }
                return true;
            }
            this.callback.onRow(this.stmt, this.stmt.getResultSet());
            return true;
        }
        catch (Exception e) {
            this.onException(e);
            return false;
        }
        catch (Throwable t) {
            this.onException(new TeiidRuntimeException(t));
            return false;
        }
    }

    private void onException(Exception e) {
        ExecutionException ee;
        if (e instanceof ExecutionException && (ee = (ExecutionException)e).getCause() instanceof Exception) {
            e = (Exception)ee.getCause();
        }
        try {
            this.callback.onException(this.stmt, e);
        }
        catch (Exception e1) {
            logger.log(Level.WARNING, "Unhandled exception from StatementCallback", e);
        }
    }
}

