/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.input;

import com.google.gdata.data.ParseSource;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.io.base.UnicodeReader;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.input.AbstractParser;
import com.google.gdata.wireformats.input.InputProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CharacterParser<T>
extends AbstractParser<T> {
    protected CharacterParser(AltFormat altFormat, Class<T> resultClass) {
        super(altFormat, resultClass);
    }

    protected String getCharset(InputProperties inProps) {
        return inProps.getContentType().getCharset();
    }

    @Override
    public <R extends T> R parse(ParseSource parseSource, InputProperties inProps, Class<R> targetClass) throws IOException, ServiceException {
        Reader reader = parseSource.getReader();
        if (reader == null) {
            InputStream inputStream = parseSource.getInputStream();
            if (inputStream != null) {
                try {
                    String charset = this.getCharset(inProps);
                    if (charset == null) {
                        charset = "UTF-8";
                    }
                    if (charset.toLowerCase().startsWith("utf-")) {
                        reader = new UnicodeReader(inputStream, charset);
                    }
                    reader = new InputStreamReader(inputStream, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ParseException("Unsupported encoding: " + e.getLocalizedMessage(), (Throwable)e);
                }
            } else {
                throw new IllegalStateException("XML event source not supported");
            }
        }
        return this.parse(reader, inProps, targetClass);
    }

    public abstract <R extends T> R parse(Reader var1, InputProperties var2, Class<R> var3) throws IOException, ServiceException;
}

