/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.hive;

import java.util.List;
import org.teiid.language.ColumnReference;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.OrderBy;
import org.teiid.language.Select;
import org.teiid.language.SetQuery;
import org.teiid.language.TableReference;
import org.teiid.translator.hive.HiveExecutionFactory;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.SQLConversionVisitor;

public class HiveSQLConversionVisitor
extends SQLConversionVisitor {
    public HiveSQLConversionVisitor(HiveExecutionFactory hef) {
        super((JDBCExecutionFactory)hef);
    }

    public void visit(Join obj) {
        TableReference leftItem = obj.getLeftItem();
        if (this.useParensForJoins() && leftItem instanceof Join) {
            this.buffer.append("(");
            this.append((LanguageObject)leftItem);
            this.buffer.append(")");
        } else {
            this.append((LanguageObject)leftItem);
        }
        this.buffer.append(" ");
        switch (obj.getJoinType()) {
            case CROSS_JOIN: {
                this.buffer.append("CROSS");
                break;
            }
            case FULL_OUTER_JOIN: {
                this.buffer.append("FULL").append(" ").append("OUTER");
                break;
            }
            case INNER_JOIN: {
                break;
            }
            case LEFT_OUTER_JOIN: {
                this.buffer.append("LEFT").append(" ").append("OUTER");
                break;
            }
            case RIGHT_OUTER_JOIN: {
                this.buffer.append("RIGHT").append(" ").append("OUTER");
                break;
            }
            default: {
                this.buffer.append("<undefined>");
            }
        }
        this.buffer.append(" ").append("JOIN").append(" ");
        TableReference rightItem = obj.getRightItem();
        if (rightItem instanceof Join && (this.useParensForJoins() || obj.getJoinType() == Join.JoinType.CROSS_JOIN)) {
            this.buffer.append("(");
            this.append((LanguageObject)rightItem);
            this.buffer.append(")");
        } else {
            this.append((LanguageObject)rightItem);
        }
        Condition condition = obj.getCondition();
        if (condition != null) {
            this.buffer.append(" ").append("ON").append(" ");
            this.append((LanguageObject)condition);
        }
    }

    public void addColumns(List<DerivedColumn> items) {
        if (items != null && items.size() != 0) {
            this.addColumn(items.get(0));
            for (int i = 1; i < items.size(); ++i) {
                this.buffer.append(",").append(" ");
                this.addColumn(items.get(i));
            }
        }
    }

    private void addColumn(DerivedColumn dc) {
        if (dc.getAlias() != null) {
            this.buffer.append(dc.getAlias());
        } else {
            Expression expr = dc.getExpression();
            if (expr instanceof ColumnReference) {
                this.buffer.append(((ColumnReference)expr).getName());
            } else {
                this.append((LanguageObject)expr);
            }
        }
    }

    public void visit(SetQuery obj) {
        Limit limit;
        if (obj.getWith() != null) {
            this.append((LanguageObject)obj.getWith());
        }
        Select select = (Select)obj.getLeftQuery();
        this.buffer.append("SELECT").append(" ");
        if (!obj.isAll()) {
            this.buffer.append("DISTINCT").append(" ");
        }
        this.addColumns(select.getDerivedColumns());
        this.buffer.append(" ");
        this.buffer.append("FROM").append(" ");
        this.buffer.append("(");
        this.appendSetQuery(obj, obj.getLeftQuery(), false);
        this.buffer.append(" ");
        this.appendSetOperation(obj.getOperation());
        this.buffer.append(" ");
        this.buffer.append("ALL");
        this.buffer.append(" ");
        this.appendSetQuery(obj, obj.getRightQuery(), true);
        OrderBy orderBy = obj.getOrderBy();
        if (orderBy != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)orderBy);
        }
        if ((limit = obj.getLimit()) != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)limit);
        }
        this.buffer.append(")");
        this.buffer.append(" ");
        this.buffer.append("X__");
    }
}

