/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.binary;

import java.io.IOException;
import java.io.OutputStream;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nux.xom.binary.BinaryXMLCodec;
import nux.xom.binary.StreamingVerifier;
import nux.xom.io.StreamingSerializer;

final class StreamingBinaryXMLSerializer
implements StreamingSerializer {
    private final BinaryXMLCodec codec;
    private final OutputStream out;
    private final int zlibCompressionLevel;
    private final StreamingVerifier verifier;
    private static final boolean DEBUG = false;

    StreamingBinaryXMLSerializer(BinaryXMLCodec codec, OutputStream out, int zlibCompressionLevel) {
        if (codec == null) {
            throw new IllegalArgumentException("codec must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("output stream must not be null");
        }
        if (zlibCompressionLevel < 0 || zlibCompressionLevel > 9) {
            throw new IllegalArgumentException("Compression level must be 0..9");
        }
        this.codec = codec;
        this.out = out;
        this.zlibCompressionLevel = zlibCompressionLevel;
        this.verifier = new StreamingVerifier();
    }

    private void reset() {
        this.verifier.reset();
    }

    public void flush() throws IOException {
        if (this.verifier.depth() > 0) {
            this.codec.flush(false);
        }
    }

    public void writeStartTag(Element elem) throws IOException {
        this.verifier.writeStartTag(elem);
        this.codec.writeStartTag(elem);
    }

    public void writeEndTag() throws IOException {
        this.verifier.writeEndTag();
        this.codec.writeEndTag();
    }

    public void write(Document doc) throws IOException {
        this.writeXMLDeclaration();
        int i = 0;
        while (i < doc.getChildCount()) {
            this.writeChild(doc.getChild(i));
            ++i;
        }
        this.writeEndDocument();
    }

    public void write(Element element) throws IOException {
        this.verifier.writeStartTag(element);
        this.codec.writeElement(element);
        this.verifier.writeEndTag();
    }

    public void write(Text text) throws IOException {
        this.verifier.write(text);
        this.codec.writeText(text);
    }

    public void write(Comment comment) throws IOException {
        this.verifier.write(comment);
        this.codec.writeComment(comment);
    }

    public void write(ProcessingInstruction instruction) throws IOException {
        this.verifier.write(instruction);
        this.codec.writeProcessingInstruction(instruction);
    }

    public void write(DocType docType) throws IOException {
        this.verifier.write(docType);
        this.codec.writeDocType(docType);
    }

    public void writeEndDocument() throws IOException {
        int i = this.verifier.depth();
        while (--i >= 0) {
            this.writeEndTag();
        }
        this.verifier.writeEndDocument();
        this.codec.writeEndDocument();
        this.reset();
    }

    public void writeXMLDeclaration() throws IOException {
        this.verifier.writeXMLDeclaration();
        this.reset();
        this.verifier.writeXMLDeclaration();
        this.codec.setOutputStream(this.zlibCompressionLevel, this.out);
        this.codec.writeXMLDeclaration("");
    }

    private void writeChild(Node node) throws IOException {
        if (node instanceof Element) {
            this.write((Element)node);
        } else if (node instanceof Text) {
            this.write((Text)node);
        } else if (node instanceof Comment) {
            this.write((Comment)node);
        } else if (node instanceof ProcessingInstruction) {
            this.write((ProcessingInstruction)node);
        } else if (node instanceof DocType) {
            this.write((DocType)node);
        } else {
            throw new IllegalAddException("Cannot write node type: " + node);
        }
    }
}

