/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.binary;

final class UnicodeUtil {
    public static final int UCS4_MIN = 65536;
    public static final int UCS4_MAX = 0x10FFFF;

    private UnicodeUtil() {
    }

    public static boolean isHighSurrogate(int c) {
        return 55296 <= c && c <= 56319;
    }

    public static boolean isLowSurrogate(int c) {
        return 56320 <= c && c <= 57343;
    }

    public static boolean isSurrogate(int c) {
        return 55296 <= c && c <= 57343;
    }

    public static char highSurrogate(int uc) {
        return (char)(0xD800 | uc - 65536 >> 10 & 0x3FF);
    }

    public static char lowSurrogate(int uc) {
        return (char)(0xDC00 | uc - 65536 & 0x3FF);
    }

    public static int toUCS4(char x, char y) {
        return ((x & 0x3FF) << 10 | y & 0x3FF) + 65536;
    }
}

