/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.io;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ParsingException;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.WellformednessException;
import nu.xom.XMLException;
import nux.xom.binary.NodeBuilder;
import nux.xom.io.StaxUtil;

public class StaxParser {
    private final XMLStreamReader reader;
    private final NodeFactory factory;
    private NodeBuilder nodeBuilder;
    private static final Nodes NONE = new Nodes();
    private static final HashMap attrTypes = StaxParser.createAttributeTypes();
    private static final boolean DEBUG = false;
    private static final String MISSING_StAX2 = new String("missing_stax2");
    static /* synthetic */ Class class$0;

    public StaxParser(XMLStreamReader reader, NodeFactory factory) {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        this.reader = reader;
        if (factory == null) {
            factory = new NodeFactory();
        }
        this.factory = factory;
        if (!StaxParser.isNamespaceAware(reader)) {
            throw new IllegalArgumentException("reader must be namespace aware");
        }
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.reader;
    }

    public Document build() throws ParsingException {
        return this.build(false);
    }

    public Document buildFragment() throws ParsingException {
        return this.build(true);
    }

    public Node buildNode() throws ParsingException {
        if (this.nodeBuilder == null) {
            this.nodeBuilder = new NodeBuilder();
        }
        switch (this.reader.getEventType()) {
            case 1: {
                Element elem = this.readStartTag();
                this.addAttributes(elem);
                this.addNamespaceDeclarations(elem);
                return elem;
            }
            case 2: {
                Element elem = this.readStartTag();
                this.addNamespaceDeclarations(elem);
                return elem;
            }
            case 10: {
                Element elem = this.nodeBuilder.createElement("dummy", "");
                this.addAttributes(elem);
                return elem.getAttribute(0).copy();
            }
            case 7: 
            case 8: {
                return new NodeFactory().startMakingDocument();
            }
            case 3: {
                return new ProcessingInstruction(this.reader.getPITarget(), this.reader.getPIData());
            }
            case 5: {
                return new Comment(this.reader.getText());
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                return this.readText();
            }
            case 11: {
                Nodes nodes = null;
                try {
                    nodes = this.readDocType(new NodeFactory());
                }
                catch (XMLStreamException e) {
                    StaxUtil.wrapException(e);
                }
                if (nodes.size() > 0) {
                    return nodes.get(0);
                }
                return null;
            }
            case 15: {
                return null;
            }
            case 14: {
                return null;
            }
        }
        throw new XMLException("Unrecognized event type: " + this.reader.getEventType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document build(boolean isFragmentMode) throws ParsingException {
        try {
            Document document;
            block5: {
                try {
                    document = this.buildTree(isFragmentMode);
                    Object var2_3 = null;
                    if (isFragmentMode) return document;
                    if (this.reader == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    if (!isFragmentMode && this.reader != null) {
                        this.reader.close();
                    }
                    throw throwable;
                }
                this.reader.close();
            }
            return document;
        }
        catch (XMLStreamException e) {
            StaxUtil.wrapException(e);
            return null;
        }
    }

    private Document buildTree(boolean isFragmentMode) throws XMLStreamException {
        if (isFragmentMode) {
            this.reader.require(1, null, null);
        } else {
            this.reader.require(7, null, null);
        }
        Document doc = this.factory.startMakingDocument();
        boolean hasRootElement = false;
        boolean done = false;
        int i = 0;
        while (!done && this.reader.getEventType() != 8) {
            Nodes nodes;
            switch (this.reader.getEventType()) {
                case 1: {
                    Element root;
                    if (hasRootElement) {
                        throw new IllegalAddException("StAX reader must not return multiple root elements");
                    }
                    Class<?> clazz = this.factory.getClass();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("nu.xom.NodeFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz2) {
                        if (this.nodeBuilder == null) {
                            this.nodeBuilder = new NodeBuilder();
                        }
                        root = this.readStartTag();
                        this.addAttributes(root);
                        this.addNamespaceDeclarations(root);
                        this.readElement(root);
                        nodes = new Nodes((Node)root);
                    } else {
                        root = this.readStartTagF(true);
                        if (root == null) {
                            throw new NullPointerException("Factory failed to create root element.");
                        }
                        doc.setRootElement(root);
                        this.addAttributesF(root);
                        this.addNamespaceDeclarations(root);
                        this.readElementF(root);
                        nodes = this.factory.finishMakingElement(root);
                    }
                    this.reader.require(2, null, null);
                    if (!isFragmentMode) break;
                    done = true;
                    break;
                }
                case 2: {
                    throw new IllegalAddException("A document must not have more than one root element");
                }
                case 3: {
                    nodes = this.factory.makeProcessingInstruction(this.reader.getPITarget(), this.reader.getPIData());
                    break;
                }
                case 4: {
                    nodes = NONE;
                    break;
                }
                case 5: {
                    nodes = this.factory.makeComment(this.reader.getText());
                    break;
                }
                case 6: {
                    nodes = NONE;
                    break;
                }
                case 7: {
                    nodes = NONE;
                    break;
                }
                case 8: {
                    throw new IllegalStateException("unreachable");
                }
                case 12: {
                    nodes = NONE;
                    break;
                }
                case 10: {
                    throw new IllegalAddException("Illegal attribute in prolog/epilog");
                }
                case 13: {
                    throw new IllegalAddException("Illegal namespace declaration in prolog/epilog");
                }
                case 11: {
                    nodes = this.readDocType(this.factory);
                    break;
                }
                case 15: {
                    nodes = NONE;
                    break;
                }
                case 14: {
                    nodes = NONE;
                    break;
                }
                case 9: {
                    nodes = NONE;
                    break;
                }
                default: {
                    throw new XMLException("Unrecognized Stax event type: " + this.reader.getEventType());
                }
            }
            int j = 0;
            while (j < nodes.size()) {
                Node node = nodes.get(j);
                if (node instanceof Element) {
                    if (hasRootElement) {
                        throw new IllegalAddException("Factory returned multiple root elements");
                    }
                    doc.setRootElement((Element)node);
                    hasRootElement = true;
                } else {
                    doc.insertChild(node, i);
                }
                ++i;
                ++j;
            }
            if (isFragmentMode) continue;
            this.reader.next();
        }
        if (!isFragmentMode) {
            this.reader.require(8, null, null);
        }
        if (!hasRootElement) {
            throw new WellformednessException("Factory attempted to remove the root element");
        }
        this.factory.finishMakingDocument(doc);
        if ("".equals(doc.getBaseURI())) {
            String baseURI;
            Location loc = this.reader.getLocation();
            String string = baseURI = loc == null ? null : loc.getSystemId();
            if (baseURI != null && baseURI.length() > 0) {
                doc.setBaseURI(baseURI);
            }
        }
        return doc;
    }

    private void readElement(Element current) throws XMLStreamException {
        block7: while (true) {
            Text node = null;
            switch (this.reader.next()) {
                case 1: {
                    Element elem = this.readStartTag();
                    current.insertChild((Node)elem, current.getChildCount());
                    this.addAttributes(elem);
                    this.addNamespaceDeclarations(elem);
                    current = elem;
                    continue block7;
                }
                case 2: {
                    if ((current = (Element)current.getParent()) != null) continue block7;
                    return;
                }
                case 3: {
                    node = new ProcessingInstruction(this.reader.getPITarget(), this.reader.getPIData());
                    break;
                }
                case 5: {
                    node = new Comment(this.reader.getText());
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 12: {
                    node = this.readText();
                    break;
                }
                default: {
                    throw new XMLException("Unrecognized Stax event type: " + this.reader.getEventType());
                }
            }
            current.insertChild((Node)node, current.getChildCount());
        }
    }

    private void readElementF(Element current) throws XMLStreamException {
        ArrayList<Element> stack = new ArrayList<Element>();
        stack.add(current);
        block7: while (true) {
            Nodes nodes;
            switch (this.reader.next()) {
                case 1: {
                    Element elem = this.readStartTagF(false);
                    stack.add(elem);
                    if (elem == null) continue block7;
                    current.appendChild((Node)elem);
                    this.addAttributesF(elem);
                    this.addNamespaceDeclarations(elem);
                    current = elem;
                    continue block7;
                }
                case 2: {
                    Element elem = (Element)stack.remove(stack.size() - 1);
                    if (elem == null) continue block7;
                    ParentNode parent = elem.getParent();
                    if (parent == null) {
                        StaxParser.throwTamperedWithParent();
                    }
                    if (parent instanceof Document) {
                        return;
                    }
                    current = (Element)parent;
                    nodes = this.factory.finishMakingElement(elem);
                    if (nodes.size() == 1 && nodes.get(0) == elem) continue block7;
                    if (current.getChildCount() - 1 < 0) {
                        StaxParser.throwTamperedWithParent();
                    }
                    current.removeChild(current.getChildCount() - 1);
                    break;
                }
                case 3: {
                    nodes = this.factory.makeProcessingInstruction(this.reader.getPITarget(), this.reader.getPIData());
                    break;
                }
                case 5: {
                    nodes = this.factory.makeComment(this.reader.getText());
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 12: {
                    nodes = this.factory.makeText(this.reader.getText());
                    break;
                }
                default: {
                    throw new XMLException("Unrecognized Stax event type: " + this.reader.getEventType());
                }
            }
            StaxParser.appendNodes(current, nodes);
        }
    }

    private Element readStartTag() {
        String prefix = this.reader.getPrefix();
        String qname = this.reader.getLocalName();
        if (prefix != null && prefix.length() > 0) {
            qname = String.valueOf(prefix) + ':' + qname;
        }
        String namespaceURI = this.reader.getNamespaceURI();
        return this.nodeBuilder.createElement(qname, namespaceURI);
    }

    private Element readStartTagF(boolean isRoot) {
        String namespaceURI;
        String prefix = this.reader.getPrefix();
        String qname = this.reader.getLocalName();
        if (prefix != null && prefix.length() > 0) {
            qname = String.valueOf(prefix) + ':' + qname;
        }
        if ((namespaceURI = this.reader.getNamespaceURI()) == null) {
            namespaceURI = "";
        }
        return isRoot ? this.factory.makeRootElement(qname, namespaceURI) : this.factory.startMakingElement(qname, namespaceURI);
    }

    private static void appendNodes(Element elem, Nodes nodes) {
        if (nodes != null) {
            int size = nodes.size();
            int i = 0;
            while (i < size) {
                Node node = nodes.get(i);
                if (node instanceof Attribute) {
                    elem.addAttribute((Attribute)node);
                } else {
                    elem.insertChild(node, elem.getChildCount());
                }
                ++i;
            }
        }
    }

    private static void throwTamperedWithParent() {
        throw new XMLException("Factory has tampered with a parent pointer of ancestor-or-self in finishMakingElement()");
    }

    private void addNamespaceDeclarations(Element elem) {
        int count = this.reader.getNamespaceCount();
        int i = 0;
        while (i < count) {
            boolean isAbsent;
            String prefix = this.reader.getNamespacePrefix(i);
            if (prefix == null) {
                prefix = "";
            }
            String uri = this.reader.getNamespaceURI(i);
            String uriInScope = elem.getNamespaceURI(prefix);
            boolean bl = isAbsent = uriInScope == null || !uriInScope.equals(uri);
            if (isAbsent) {
                elem.addNamespaceDeclaration(prefix, uri);
            }
            ++i;
        }
    }

    private void addAttributes(Element elem) {
        int count = this.reader.getAttributeCount();
        int i = 0;
        while (i < count) {
            String prefix = this.reader.getAttributePrefix(i);
            String qname = this.reader.getAttributeLocalName(i);
            if (prefix != null && prefix.length() > 0) {
                qname = String.valueOf(prefix) + ':' + qname;
            }
            String namespaceURI = this.reader.getAttributeNamespace(i);
            String value = this.reader.getAttributeValue(i);
            Attribute.Type type = StaxParser.convertAttributeType(this.reader.getAttributeType(i));
            Attribute attr = this.nodeBuilder.createAttribute(qname, namespaceURI, value, type);
            elem.addAttribute(attr);
            ++i;
        }
    }

    private void addAttributesF(Element elem) {
        int count = this.reader.getAttributeCount();
        int i = 0;
        while (i < count) {
            String namespaceURI;
            String prefix = this.reader.getAttributePrefix(i);
            String qname = this.reader.getAttributeLocalName(i);
            if (prefix != null && prefix.length() > 0) {
                qname = String.valueOf(prefix) + ':' + qname;
            }
            if ((namespaceURI = this.reader.getAttributeNamespace(i)) == null) {
                namespaceURI = "";
            }
            String value = this.reader.getAttributeValue(i);
            Attribute.Type type = StaxParser.convertAttributeType(this.reader.getAttributeType(i));
            StaxParser.appendNodes(elem, this.factory.makeAttribute(qname, namespaceURI, value, type));
            ++i;
        }
    }

    private static Attribute.Type convertAttributeType(String staxType) {
        Attribute.Type xomType;
        if (staxType != null && staxType.length() > 0 && (xomType = (Attribute.Type)attrTypes.get(staxType)) != null) {
            return xomType;
        }
        return Attribute.Type.UNDECLARED;
    }

    private Text readText() {
        return new Text(this.reader.getText());
    }

    private Nodes readDocType(NodeFactory nodeFactory) throws XMLStreamException {
        Object info = StaxParser.invoke(this.reader, "getDTDInfo");
        if (info == null || info == MISSING_StAX2) {
            return NONE;
        }
        String rootName = (String)StaxParser.invoke(info, "getDTDRootName");
        if (rootName == MISSING_StAX2) {
            return NONE;
        }
        String publicID = (String)StaxParser.invoke(info, "getDTDPublicId");
        if (publicID == MISSING_StAX2) {
            return NONE;
        }
        String systemID = (String)StaxParser.invoke(info, "getDTDSystemId");
        if (systemID == MISSING_StAX2) {
            return NONE;
        }
        Nodes nodes = nodeFactory.makeDocType(rootName, publicID, systemID);
        int k = 0;
        while (k < nodes.size()) {
            DocType docType;
            Node node = nodes.get(k);
            if (node instanceof DocType && (docType = (DocType)node).getInternalDTDSubset().length() == 0) {
                String subset = (String)StaxParser.invoke(info, "getDTDInternalSubset");
                if (subset == MISSING_StAX2) {
                    return nodes;
                }
                docType.setInternalDTDSubset(subset);
            }
            ++k;
        }
        return nodes;
    }

    private static Object invoke(Object obj, String methodName) throws XMLStreamException {
        try {
            return obj.getClass().getMethod(methodName, null).invoke(obj, null);
        }
        catch (IllegalArgumentException e) {
            return MISSING_StAX2;
        }
        catch (SecurityException e) {
            return MISSING_StAX2;
        }
        catch (IllegalAccessException e) {
            return MISSING_StAX2;
        }
        catch (NoSuchMethodException e) {
            return MISSING_StAX2;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof XMLStreamException) {
                throw (XMLStreamException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static HashMap createAttributeTypes() {
        HashMap<String, Attribute.Type> typeMappings = new HashMap<String, Attribute.Type>();
        typeMappings.put("CDATA", Attribute.Type.CDATA);
        typeMappings.put("cdata", Attribute.Type.CDATA);
        typeMappings.put("ID", Attribute.Type.ID);
        typeMappings.put("id", Attribute.Type.ID);
        typeMappings.put("IDREF", Attribute.Type.IDREF);
        typeMappings.put("idref", Attribute.Type.IDREF);
        typeMappings.put("IDREFS", Attribute.Type.IDREFS);
        typeMappings.put("idrefs", Attribute.Type.IDREFS);
        typeMappings.put("ENTITY", Attribute.Type.ENTITY);
        typeMappings.put("entity", Attribute.Type.ENTITY);
        typeMappings.put("ENTITIES", Attribute.Type.ENTITIES);
        typeMappings.put("entities", Attribute.Type.ENTITIES);
        typeMappings.put("NMTOKEN", Attribute.Type.NMTOKEN);
        typeMappings.put("nmtoken", Attribute.Type.NMTOKEN);
        typeMappings.put("NMTOKENS", Attribute.Type.NMTOKENS);
        typeMappings.put("nmtokens", Attribute.Type.NMTOKENS);
        typeMappings.put("NOTATION", Attribute.Type.NOTATION);
        typeMappings.put("notation", Attribute.Type.NOTATION);
        typeMappings.put("ENUMERATED", Attribute.Type.ENUMERATION);
        typeMappings.put("enumerated", Attribute.Type.ENUMERATION);
        return typeMappings;
    }

    private static boolean isNamespaceAware(XMLStreamReader reader) {
        Boolean isNamespaceAware = (Boolean)reader.getProperty("javax.xml.stream.isNamespaceAware");
        return isNamespaceAware != null && isNamespaceAware != false;
    }

    private Nodes buildSequence() throws ParsingException {
        try {
            Nodes results = new Nodes();
            while (this.reader.hasNext()) {
                Document node;
                switch (this.reader.next()) {
                    case 7: {
                        node = this.build();
                        break;
                    }
                    case 1: {
                        node = this.buildFragment();
                        break;
                    }
                    default: {
                        node = this.buildNode();
                    }
                }
                results.append((Node)node);
            }
            return results;
        }
        catch (XMLStreamException e) {
            StaxUtil.wrapException(e);
            return null;
        }
    }
}

