/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.net.URI;
import java.util.Map;
import nu.xom.Builder;
import nux.xom.pool.BuilderFactory;
import nux.xom.pool.Pool;
import nux.xom.pool.PoolConfig;
import org.xml.sax.EntityResolver;

public class BuilderPool {
    public static final BuilderPool GLOBAL_POOL = new BuilderPool();
    private final ThreadLocal threadlocal;
    private final BuilderFactory factory;

    public BuilderPool() {
        this(new PoolConfig(), new BuilderFactory());
    }

    public BuilderPool(PoolConfig config, BuilderFactory factory) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.factory = factory;
        this.threadlocal = BuilderPool.createThreadLocal(config.copy());
    }

    public Builder getBuilder(boolean validate) {
        Boolean key = validate ? Boolean.TRUE : Boolean.FALSE;
        Map entries = (Map)this.threadlocal.get();
        Builder builder = (Builder)entries.get(key);
        if (builder == null) {
            builder = this.factory.createBuilder(validate);
            entries.put(key, builder);
        }
        return builder;
    }

    public Builder getDTDBuilder(EntityResolver resolver) {
        Map entries;
        Builder builder;
        Object key = resolver;
        if (key == null) {
            key = Pool.createHashKeys(new Object[]{resolver});
        }
        if ((builder = (Builder)(entries = (Map)this.threadlocal.get()).get(key)) == null) {
            builder = this.factory.createDTDBuilder(resolver);
            entries.put(key, builder);
        }
        return builder;
    }

    public Builder getW3CBuilder(Map schemaLocations) {
        Object[] objectArray = new Object[2];
        objectArray[0] = schemaLocations;
        Object key = Pool.createHashKeys(objectArray);
        Map entries = (Map)this.threadlocal.get();
        Builder builder = (Builder)entries.get(key);
        if (builder == null) {
            builder = this.factory.createW3CBuilder(schemaLocations);
            entries.put(key, builder);
        }
        return builder;
    }

    public Builder getMSVBuilder(URI schema) {
        if (schema == null) {
            throw new IllegalArgumentException("schema must not be null");
        }
        URI key = schema;
        Map entries = (Map)this.threadlocal.get();
        Builder builder = (Builder)entries.get(key);
        if (builder == null) {
            builder = this.factory.createMSVBuilder(null, schema);
            entries.put(key, builder);
        }
        return builder;
    }

    private static ThreadLocal createThreadLocal(final PoolConfig config) {
        return new ThreadLocal(){

            protected Object initialValue() {
                return Pool.createPool(config);
            }
        };
    }
}

