/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import nux.xom.pool.XOMUtil;

public class PoolConfig {
    private int compressionLevel = DEFAULT_COMPRESSION_LEVEL;
    private long capacity = DEFAULT_CAPACITY;
    private int maxEntries = DEFAULT_MAX_ENTRIES;
    private long maxIdleTime = DEFAULT_MAX_IDLE_TIME;
    private long maxLifeTime = DEFAULT_MAX_LIFE_TIME;
    private boolean fileMonitoring = DEFAULT_FILE_MONITORING;
    private static final int DEFAULT_COMPRESSION_LEVEL = XOMUtil.getSystemProperty("nux.xom.pool.PoolConfig.compressionLevel", 0);
    private static final int DEFAULT_MAX_ENTRIES = XOMUtil.getSystemProperty("nux.xom.pool.PoolConfig.maxEntries", 10000);
    private static final long DEFAULT_MAX_IDLE_TIME = XOMUtil.getSystemProperty("nux.xom.pool.PoolConfig.maxIdleTime", 300000L);
    private static final long DEFAULT_MAX_LIFE_TIME = XOMUtil.getSystemProperty("nux.xom.pool.PoolConfig.maxLifeTime", Long.MAX_VALUE);
    private static final boolean DEFAULT_FILE_MONITORING = XOMUtil.getSystemProperty("nux.xom.pool.PoolConfig.fileMonitoring", false);
    private static final long DEFAULT_INVALIDATION_PERIOD = XOMUtil.getSystemProperty("nux.xom.pool.PoolConfig.invalidationPeriod", 10000L);
    private static final long DEFAULT_CAPACITY = PoolConfig.getDefaultCapacity();

    private static long getDefaultCapacity() {
        long def = Runtime.getRuntime().maxMemory();
        if (def != Long.MAX_VALUE) {
            def /= 2L;
        }
        return XOMUtil.getSystemProperty("nux.xom.pool.PoolConfig.capacity", def);
    }

    public PoolConfig() {
    }

    protected PoolConfig(PoolConfig src) {
        this.setCompressionLevel(src.getCompressionLevel());
        this.setCapacity(src.getCapacity());
        this.setMaxEntries(src.getMaxEntries());
        this.setMaxIdleTime(src.getMaxIdleTime());
        this.setMaxLifeTime(src.getMaxLifeTime());
        this.setFileMonitoring(src.getFileMonitoring());
    }

    public PoolConfig copy() {
        return new PoolConfig(this);
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public PoolConfig setCompressionLevel(int compressionLevel) {
        if (compressionLevel < -1 || compressionLevel > 9) {
            throw new IllegalArgumentException("Compression level must be -1..9");
        }
        this.compressionLevel = compressionLevel;
        return this;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public PoolConfig setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
        return this;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public PoolConfig setCapacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public PoolConfig setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
        return this;
    }

    public long getMaxLifeTime() {
        return this.maxLifeTime;
    }

    public PoolConfig setMaxLifeTime(long maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
        return this;
    }

    public PoolConfig setFileMonitoring(boolean fileMonitoring) {
        this.fileMonitoring = fileMonitoring;
        return this;
    }

    public boolean getFileMonitoring() {
        return this.fileMonitoring;
    }

    long getInvalidationPeriod() {
        return DEFAULT_INVALIDATION_PERIOD;
    }
}

