/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.WellformednessException;
import nu.xom.XMLException;
import nu.xom.canonical.Canonicalizer;
import nu.xom.converters.DOMConverter;
import nux.xom.binary.BinaryXMLCodec;
import nux.xom.binary.NodeBuilder;
import nux.xom.io.StreamingSerializer;
import nux.xom.pool.BuilderPool;
import nux.xom.pool.SoftThreadLocal;
import nux.xom.xquery.ResultSequenceSerializer;
import org.w3c.dom.DOMImplementation;

public class XOMUtil {
    private static final String TABS = XOMUtil.repeatString("\t", 128);
    private static final ThreadLocal LOCAL_CODEC = new SoftThreadLocal(){

        protected Object initialSoftValue() {
            return new BinaryXMLCodec();
        }
    };
    private static final ThreadLocal LOCAL_DOC_BUILDER = new SoftThreadLocal(){

        protected Object initialSoftValue() {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                return docBuilder;
            }
            catch (ParserConfigurationException e) {
                throw new XMLException("Can't find or create DOM DocumentBuilder - check your classpath", (Throwable)e);
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private XOMUtil() {
    }

    static BinaryXMLCodec getBinaryXMLCodec() {
        return (BinaryXMLCodec)LOCAL_CODEC.get();
    }

    public static DOMImplementation getDOMImplementation() {
        return ((DocumentBuilder)LOCAL_DOC_BUILDER.get()).getDOMImplementation();
    }

    public static String toPrettyXML(Node node) {
        String xml;
        if (!(node instanceof ParentNode)) {
            return node.toXML();
        }
        ResultSequenceSerializer serializer = new ResultSequenceSerializer();
        serializer.setIndent(4);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Nodes nodes = new Nodes();
        nodes.append(node);
        try {
            serializer.write(nodes, out);
            xml = out.toString("UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("should never happen", e);
        }
        xml = xml.substring(xml.indexOf(62) + 1);
        if (xml.startsWith("\r\n")) {
            xml = xml.substring(2);
        }
        int j = xml.length();
        if (xml.endsWith("\r\n")) {
            j -= 2;
        } else if (xml.endsWith("\n")) {
            --j;
        }
        return xml.substring(0, j);
    }

    public static byte[] toCanonicalXML(Document doc) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Canonicalizer canon = new Canonicalizer((OutputStream)out);
        try {
            canon.write((Node)doc);
        }
        catch (IOException e) {
            throw new RuntimeException("should never happen", e);
        }
        catch (NoSuchMethodError e) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("nu.xom.canonical.Canonicalizer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("nu.xom.Document");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                clazz.getMethod("write", classArray);
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
        return out.toByteArray();
    }

    public static String toDebugString(Node node) {
        int depth = 0;
        String indent = TABS.substring(0, depth);
        StringBuffer result = new StringBuffer(128);
        result.append(indent);
        result.append(node);
        result.append('\n');
        if (node instanceof ParentNode) {
            XOMUtil.toDebugString((ParentNode)node, depth + 1, result);
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    private static void toDebugString(ParentNode node, int depth, StringBuffer result) {
        String indent = TABS.substring(0, depth);
        if (node instanceof Element) {
            Element elem = (Element)node;
            int i = 0;
            while (i < elem.getAttributeCount()) {
                result.append(indent);
                result.append(elem.getAttribute(i).toString());
                result.append('\n');
                ++i;
            }
        }
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChild(i);
            result.append(indent);
            result.append(child.toString());
            result.append('\n');
            if (child instanceof Element) {
                XOMUtil.toDebugString((ParentNode)((Element)child), depth + 1, result);
            }
            ++i;
        }
    }

    private static String repeatString(String str, int times) {
        StringBuffer buf = new StringBuffer(str.length() * times);
        int i = 0;
        while (i < times) {
            buf.append(str);
            ++i;
        }
        return buf.toString();
    }

    public static Document toDocument(String xml) {
        try {
            return BuilderPool.GLOBAL_POOL.getBuilder(false).build(xml, "");
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), (Throwable)e);
        }
    }

    public static NodeFactory getIgnoreWhitespaceOnlyTextNodeFactory() {
        return new NodeFactory(){
            private final Nodes NONE = new Nodes();

            public Nodes makeText(String text) {
                return Normalizer.isWhitespaceOnly(text) ? this.NONE : super.makeText(text);
            }
        };
    }

    public static NodeFactory getLoggingNodeFactory(final NodeFactory child, final PrintStream log, final String logName) {
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (log == null) {
            throw new IllegalArgumentException("logStream must not be null");
        }
        return new NodeFactory(){
            private int level = 0;

            public Nodes makeAttribute(String name, String URI2, String value, Attribute.Type type) {
                this.log("", new Attribute(name, URI2, value, type));
                return child.makeAttribute(name, URI2, value, type);
            }

            public Nodes makeComment(String data) {
                this.log("", new Comment(data));
                return child.makeComment(data);
            }

            public Nodes makeDocType(String rootElementName, String publicID, String systemID) {
                this.log("", new DocType(rootElementName, publicID, systemID));
                return child.makeDocType(rootElementName, publicID, systemID);
            }

            public Nodes makeProcessingInstruction(String target, String data) {
                this.log("", new ProcessingInstruction(target, data));
                return child.makeProcessingInstruction(target, data);
            }

            public Nodes makeText(String text) {
                this.log("", new Text(text));
                return child.makeText(text);
            }

            public Element makeRootElement(String name, String namespace) {
                this.log("startRoot", new Element(name, namespace));
                ++this.level;
                return child.makeRootElement(name, namespace);
            }

            public Element startMakingElement(String name, String namespace) {
                this.log("start", new Element(name, namespace));
                Element elem = child.startMakingElement(name, namespace);
                if (elem == null) {
                    this.log("SKIP ", new Element(name, namespace));
                } else {
                    ++this.level;
                }
                return elem;
            }

            public Nodes finishMakingElement(Element element) {
                --this.level;
                this.log("finish", element);
                ParentNode parent = null;
                if (element != null) {
                    parent = element.getParent();
                }
                String parents = "{";
                while (parent != null) {
                    parents = String.valueOf(parents) + parent.toString() + ",";
                    parent = parent.getParent();
                }
                if (parents.endsWith(",")) {
                    parents = parents.substring(0, parents.length() - 1);
                }
                parents = String.valueOf(parents) + "}";
                this.log("parents", parents);
                return child.finishMakingElement(element);
            }

            public Document startMakingDocument() {
                this.level = 0;
                this.log("startDoc", null);
                return child.startMakingDocument();
            }

            public void finishMakingDocument(Document document) {
                this.log("finishDoc", document);
                this.level = 0;
                child.finishMakingDocument(document);
            }

            private void log(String msg, Object node) {
                if (msg == null) {
                    msg = "";
                }
                String indent = this.level <= TABS.length() ? TABS.substring(0, Math.max(0, this.level)) : XOMUtil.repeatString("\t", this.level);
                String s = String.valueOf(indent) + logName;
                if (msg.length() > 0) {
                    s = String.valueOf(s) + ":" + msg;
                }
                s = String.valueOf(s) + ":" + node;
                log.println(s);
            }
        };
    }

    public static NodeFactory getTextTrimmingNodeFactory() {
        return new NodeFactory(){
            private final Nodes NONE = new Nodes();

            public Nodes makeText(String text) {
                return (text = Normalizer.trim(text)).length() == 0 ? this.NONE : super.makeText(text);
            }
        };
    }

    public static NodeFactory getNullNodeFactory() {
        return new NodeFactory(){
            private final Nodes NONE = new Nodes();

            public Nodes makeAttribute(String name, String URI2, String value, Attribute.Type type) {
                return this.NONE;
            }

            public Nodes makeComment(String data) {
                return this.NONE;
            }

            public Nodes makeDocType(String rootElementName, String publicID, String systemID) {
                return this.NONE;
            }

            public Nodes makeProcessingInstruction(String target, String data) {
                return this.NONE;
            }

            public Element makeRootElement(String name, String namespace) {
                return new Element(name, namespace);
            }

            public Nodes makeText(String text) {
                return this.NONE;
            }

            public Element startMakingElement(String name, String namespace) {
                return null;
            }

            public Document startMakingDocument() {
                return new Document(new Element("dummy"));
            }
        };
    }

    public static NodeFactory getRedirectingNodeFactory(final StreamingSerializer serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException("Streaming serializer must not be null");
        }
        return new NodeFactory(){
            private Element buffer = null;
            private final Nodes NONE = new Nodes();
            private final NodeBuilder nodeBuilder = new NodeBuilder();

            public Nodes makeAttribute(String name, String namespace, String value, Attribute.Type type) {
                this.buffer.addAttribute(this.nodeBuilder.createAttribute(name, namespace, value, type));
                return this.NONE;
            }

            public Nodes makeComment(String data) {
                this.flush();
                try {
                    serializer.write(new Comment(data));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.NONE;
            }

            public Nodes makeDocType(String rootElementName, String publicID, String systemID) {
                this.flush();
                try {
                    serializer.write(new DocType(rootElementName, publicID, systemID));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.NONE;
            }

            public Nodes makeProcessingInstruction(String target, String data) {
                this.flush();
                try {
                    serializer.write(new ProcessingInstruction(target, data));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.NONE;
            }

            public Nodes makeText(String text) {
                this.flush();
                try {
                    serializer.write(new Text(text));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.NONE;
            }

            public Element startMakingElement(String name, String namespace) {
                this.flush();
                this.buffer = this.nodeBuilder.createElement(name, namespace);
                return this.buffer;
            }

            public Nodes finishMakingElement(Element element) {
                this.flush();
                try {
                    serializer.writeEndTag();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (element.getParent() instanceof Document) {
                    return new Nodes((Node)element);
                }
                return this.NONE;
            }

            public Document startMakingDocument() {
                this.buffer = null;
                try {
                    serializer.writeXMLDeclaration();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new Document(new Element("dummy"));
            }

            public void finishMakingDocument(Document document) {
                this.buffer = null;
                try {
                    serializer.writeEndDocument();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            private void flush() {
                if (this.buffer != null) {
                    try {
                        serializer.writeStartTag(this.buffer);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.buffer = null;
                }
            }
        };
    }

    static String getSystemProperty(String key, String defaults) {
        try {
            return System.getProperty(key, defaults);
        }
        catch (Throwable e) {
            return defaults;
        }
    }

    static boolean getSystemProperty(String key, boolean defaults) {
        try {
            return "true".equalsIgnoreCase(System.getProperty(key, String.valueOf(defaults)));
        }
        catch (Throwable e) {
            return defaults;
        }
    }

    static int getSystemProperty(String key, int defaults) {
        try {
            return Integer.getInteger(key, defaults);
        }
        catch (Throwable e) {
            return defaults;
        }
    }

    static long getSystemProperty(String key, long defaults) {
        try {
            return Long.getLong(key, defaults);
        }
        catch (Throwable e) {
            return defaults;
        }
    }

    static int getMemorySize(Node node) {
        int PTR = 4;
        int HEADER = 3 * PTR;
        int STR = HEADER + 12 + PTR + HEADER + 4;
        int ARR = HEADER + 4;
        int size = HEADER + PTR + 4;
        if (node instanceof ParentNode) {
            ParentNode parent = (ParentNode)node;
            size += PTR + PTR + 4;
            int count = parent.getChildCount();
            if (count > 0) {
                size += ARR + count * PTR;
            }
            int i = count;
            while (--i >= 0) {
                size += XOMUtil.getMemorySize(parent.getChild(i));
            }
            if (node instanceof Element) {
                Element elem = (Element)node;
                size += 5 * PTR + 4;
                count = elem.getAttributeCount();
                if (count > 0) {
                    size += ARR + count * PTR;
                }
                int i2 = count;
                while (--i2 >= 0) {
                    size += XOMUtil.getMemorySize((Node)elem.getAttribute(i2));
                }
            }
        } else if (node instanceof Attribute) {
            size += 5 * PTR;
            size += STR + 2 * node.getValue().length();
        } else {
            size += PTR;
            size += STR + 2 * node.getValue().length();
        }
        return size;
    }

    public static Document jaxbMarshal(Marshaller marshaller, Object jaxbObj) throws JAXBException {
        if (jaxbObj == null) {
            throw new IllegalArgumentException("jaxbObj must not be null");
        }
        if (marshaller == null) {
            throw new IllegalArgumentException("marshaller must not be null");
        }
        return DOMConverter.convert((org.w3c.dom.Document)XOMUtil.jaxbMarshalDOM(marshaller, jaxbObj));
    }

    public static Object jaxbUnmarshal(Unmarshaller unmarshaller, ParentNode node) throws JAXBException {
        Document doc;
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        if (unmarshaller == null) {
            throw new IllegalArgumentException("unmarshaller must not be null");
        }
        if (node instanceof Document) {
            doc = (Document)node;
        } else if (node instanceof Element) {
            doc = new Document((Element)node.copy());
        } else {
            throw new IllegalArgumentException("Illegal XOM node type" + node);
        }
        return XOMUtil.jaxbUnmarshalDOM(unmarshaller, DOMConverter.convert((Document)doc, (DOMImplementation)XOMUtil.getDOMImplementation()));
    }

    private static org.w3c.dom.Document jaxbMarshalDOM(Marshaller marshaller, Object jaxbObj) throws JAXBException {
        DocumentBuilder docBuilder = (DocumentBuilder)LOCAL_DOC_BUILDER.get();
        org.w3c.dom.Document doc = docBuilder.newDocument();
        marshaller.marshal(jaxbObj, (org.w3c.dom.Node)doc);
        return doc;
    }

    private static Object jaxbUnmarshalDOM(Unmarshaller unmarshaller, org.w3c.dom.Node node) throws JAXBException {
        return unmarshaller.unmarshal(node);
    }

    private static final class NodeFactoryPusher {
        static /* synthetic */ Class class$0;

        private NodeFactoryPusher() {
        }

        public Document build(Document doc, NodeFactory factory) {
            block24: {
                block23: {
                    if (doc == null) {
                        throw new IllegalArgumentException("doc must not be null");
                    }
                    if (factory == null) break block23;
                    Class<?> clazz = factory.getClass();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("nu.xom.NodeFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz != clazz2) break block24;
                }
                return new Document(doc);
            }
            Document result = factory.startMakingDocument();
            boolean hasRootElement = false;
            int k = 0;
            int i = 0;
            while (i < doc.getChildCount()) {
                Nodes nodes;
                Node child = doc.getChild(i);
                if (child instanceof Element) {
                    Element elem = (Element)child;
                    Element root = factory.makeRootElement(elem.getQualifiedName(), elem.getNamespaceURI());
                    if (root == null) {
                        throw new NullPointerException("Factory failed to create root element.");
                    }
                    result.setRootElement(root);
                    NodeFactoryPusher.appendNamespaces(elem, root);
                    NodeFactoryPusher.appendAttributes(elem, factory, root);
                    NodeFactoryPusher.build(elem, factory, root);
                    nodes = factory.finishMakingElement(root);
                } else if (child instanceof Comment) {
                    nodes = factory.makeComment(child.getValue());
                } else if (child instanceof ProcessingInstruction) {
                    ProcessingInstruction pi = (ProcessingInstruction)child;
                    nodes = factory.makeProcessingInstruction(pi.getTarget(), pi.getValue());
                } else if (child instanceof DocType) {
                    DocType docType = (DocType)child;
                    nodes = factory.makeDocType(docType.getRootElementName(), docType.getPublicID(), docType.getSystemID());
                } else {
                    throw new IllegalArgumentException("Unrecognized node type");
                }
                int j = 0;
                while (j < nodes.size()) {
                    Node node = nodes.get(j);
                    if (node instanceof Element) {
                        if (hasRootElement) {
                            throw new IllegalAddException("Factory returned multiple root elements");
                        }
                        result.setRootElement((Element)node);
                        hasRootElement = true;
                    } else {
                        result.insertChild(node, k);
                    }
                    ++k;
                    ++j;
                }
                ++i;
            }
            if (!hasRootElement) {
                throw new WellformednessException("Factory attempted to remove the root element");
            }
            factory.finishMakingDocument(result);
            return result;
        }

        private static void build(Element parent, NodeFactory factory, Element result) {
            int i = 0;
            while (i < parent.getChildCount()) {
                block10: {
                    Nodes nodes;
                    block11: {
                        Node child;
                        block9: {
                            child = parent.getChild(i);
                            if (!(child instanceof Element)) break block9;
                            Element elem = (Element)child;
                            Element copy = factory.startMakingElement(elem.getQualifiedName(), elem.getNamespaceURI());
                            if (copy != null) {
                                result.appendChild((Node)copy);
                                result = copy;
                                NodeFactoryPusher.appendNamespaces(elem, result);
                                NodeFactoryPusher.appendAttributes(elem, factory, result);
                            }
                            NodeFactoryPusher.build(elem, factory, result);
                            if (copy == null) break block10;
                            result = (Element)copy.getParent();
                            nodes = factory.finishMakingElement(copy);
                            if (nodes.size() == 1 && nodes.get(0) == copy) break block10;
                            if (result.getChildCount() - 1 < 0) {
                                throw new XMLException("Factory has tampered with a parent pointer of ancestor-or-self in finishMakingElement()");
                            }
                            result.removeChild(result.getChildCount() - 1);
                            break block11;
                        }
                        if (child instanceof Text) {
                            nodes = factory.makeText(child.getValue());
                        } else if (child instanceof Comment) {
                            nodes = factory.makeComment(child.getValue());
                        } else if (child instanceof ProcessingInstruction) {
                            ProcessingInstruction pi = (ProcessingInstruction)child;
                            nodes = factory.makeProcessingInstruction(pi.getTarget(), pi.getValue());
                        } else {
                            throw new IllegalArgumentException("Unrecognized node type");
                        }
                    }
                    NodeFactoryPusher.appendNodes(result, nodes);
                }
                ++i;
            }
        }

        private static void appendNamespaces(Element elem, Element result) {
            int count = elem.getNamespaceDeclarationCount();
            if (count == 1) {
                return;
            }
            int i = 0;
            while (i < count) {
                String prefix = elem.getNamespacePrefix(i);
                String uri = elem.getNamespaceURI(prefix);
                if (!prefix.equals(elem.getNamespacePrefix()) || !uri.equals(elem.getNamespaceURI())) {
                    result.addNamespaceDeclaration(prefix, uri);
                }
                ++i;
            }
        }

        private static void appendAttributes(Element elem, NodeFactory factory, Element result) {
            int i = 0;
            while (i < elem.getAttributeCount()) {
                Attribute attr = elem.getAttribute(i);
                NodeFactoryPusher.appendNodes(result, factory.makeAttribute(attr.getQualifiedName(), attr.getNamespaceURI(), attr.getValue(), attr.getType()));
                ++i;
            }
        }

        private static void appendNodes(Element elem, Nodes nodes) {
            if (nodes != null) {
                int size = nodes.size();
                int i = 0;
                while (i < size) {
                    Node node = nodes.get(i);
                    if (node instanceof Attribute) {
                        elem.addAttribute((Attribute)node);
                    } else {
                        elem.insertChild(node, elem.getChildCount());
                    }
                    ++i;
                }
            }
        }
    }

    public static class Normalizer {
        public static final Normalizer PRESERVE = new Normalizer();
        public static final Normalizer REPLACE = new ReplaceNormalizer();
        public static final Normalizer COLLAPSE = new CollapseNormalizer();
        public static final Normalizer TRIM = new TrimNormalizer();
        public static final Normalizer STRIP = new StripNormalizer();

        private Normalizer() {
        }

        String normalizeWhitespace(String str) {
            return str;
        }

        public final void normalize(ParentNode node) {
            int i = node.getChildCount();
            while (--i >= 0) {
                Node child = node.getChild(i);
                if (child instanceof Element) {
                    this.normalize((ParentNode)((Element)child));
                    continue;
                }
                if (!(child instanceof Text)) continue;
                int j = i;
                while (--i >= 0 && node.getChild(i) instanceof Text) {
                }
                if (j != ++i) {
                    this.merge(node, i, j);
                    continue;
                }
                String value = child.getValue();
                String norm = this.normalizeWhitespace(value);
                if (norm.length() == 0) {
                    node.removeChild(i);
                    continue;
                }
                if (norm.equals(value)) continue;
                ((Text)child).setValue(norm);
            }
        }

        private void merge(ParentNode node, int i, int j) {
            int k = i;
            StringBuffer buf = new StringBuffer(node.getChild(k++).getValue());
            while (k <= j) {
                buf.append(node.getChild(k++).getValue());
            }
            k = j;
            while (k >= i) {
                node.removeChild(k--);
            }
            String norm = this.normalizeWhitespace(buf.toString());
            if (norm.length() > 0) {
                node.insertChild((Node)new Text(norm), i);
            }
        }

        private static boolean isWhitespace(char c) {
            switch (c) {
                case '\t': {
                    return true;
                }
                case '\n': {
                    return true;
                }
                case '\r': {
                    return true;
                }
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        private static boolean isWhitespaceOnly(String str) {
            int i = str.length();
            while (--i >= 0) {
                if (Normalizer.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private static String trim(String str) {
            int j = str.length();
            int i = 0;
            while (i < j && Normalizer.isWhitespace(str.charAt(i))) {
                ++i;
            }
            while (i < j && Normalizer.isWhitespace(str.charAt(j - 1))) {
                --j;
            }
            return i > 0 || j < str.length() ? str.substring(i, j) : str;
        }

        private static final class TrimNormalizer
        extends Normalizer {
            private TrimNormalizer() {
            }

            String normalizeWhitespace(String str) {
                return Normalizer.trim(str);
            }
        }

        private static final class StripNormalizer
        extends Normalizer {
            private StripNormalizer() {
            }

            String normalizeWhitespace(String str) {
                return Normalizer.isWhitespaceOnly(str) ? "" : str;
            }
        }

        private static final class ReplaceNormalizer
        extends Normalizer {
            private ReplaceNormalizer() {
            }

            String normalizeWhitespace(String str) {
                int len = str.length();
                StringBuffer buf = new StringBuffer(len);
                boolean modified = false;
                int i = 0;
                while (i < len) {
                    int c = str.charAt(i);
                    if (c != 32 && Normalizer.isWhitespace((char)c)) {
                        c = 32;
                        modified = true;
                    }
                    buf.append((char)c);
                    ++i;
                }
                return modified ? buf.toString() : str;
            }
        }

        private static final class CollapseNormalizer
        extends Normalizer {
            private CollapseNormalizer() {
            }

            String normalizeWhitespace(String str) {
                int len = str.length();
                StringBuffer buf = new StringBuffer(len);
                boolean modified = false;
                int i = 0;
                while (i < len) {
                    int c = str.charAt(i);
                    if (Normalizer.isWhitespace((char)c)) {
                        int j = i;
                        while (++i < len && Normalizer.isWhitespace(str.charAt(i))) {
                        }
                        if (!(modified || c == 32 && j == --i)) {
                            modified = true;
                        }
                        c = 32;
                    }
                    buf.append((char)c);
                    ++i;
                }
                len = buf.length();
                if (len > 0 && buf.charAt(len - 1) == ' ') {
                    buf.deleteCharAt(len - 1);
                    modified = true;
                }
                if (buf.length() > 0 && buf.charAt(0) == ' ') {
                    buf.deleteCharAt(0);
                    modified = true;
                }
                return modified ? buf.toString() : str;
            }
        }
    }
}

