/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nux.xom.pool.BuilderPool;
import nux.xom.pool.XOMUtil;

class XMLMatrix {
    private Document doc;
    private File file;

    public XMLMatrix(File file, boolean append) throws ParsingException, IOException {
        this.file = file;
        this.doc = append && file.exists() ? BuilderPool.GLOBAL_POOL.getBuilder(false).build(file) : new Document(new Element(file.getName()));
    }

    public void put(String rowName, String columnName, String value) {
        Elements cols;
        Elements rows = this.doc.getRootElement().getChildElements(rowName);
        if (rows.size() == 0) {
            this.doc.getRootElement().appendChild((Node)new Element(rowName));
            rows = this.doc.getRootElement().getChildElements(rowName);
        }
        if ((cols = rows.get(0).getChildElements(columnName)).size() == 0) {
            rows.get(0).appendChild((Node)new Element(columnName));
            cols = rows.get(0).getChildElements(columnName);
        }
        Element col = cols.get(0);
        col.removeChildren();
        col.appendChild(value);
    }

    public String get(String rowName, String columnName) {
        Elements cols;
        Elements rows = this.doc.getRootElement().getChildElements(rowName);
        if (rows.size() > 0 && (cols = rows.get(0).getChildElements(columnName)).size() > 0) {
            return cols.get(0).getValue();
        }
        return "";
    }

    public void saveAsXML() throws IOException {
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
        }
        FileOutputStream out = new FileOutputStream(this.file);
        Serializer ser = new Serializer((OutputStream)out);
        ser.setIndent(4);
        ser.write(this.doc);
        ((OutputStream)out).close();
    }

    public void saveAsCSV() throws IOException {
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
        }
        FileOutputStream out = new FileOutputStream(new File(this.file.getParentFile(), String.valueOf(this.file.getName()) + ".csv"));
        ((OutputStream)out).write(this.toCSV().getBytes());
        out.flush();
        ((OutputStream)out).close();
    }

    public String toString() {
        return XOMUtil.toPrettyXML((Node)this.doc);
    }

    public String[] columnNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        Elements rows = this.doc.getRootElement().getChildElements();
        int i = 0;
        while (i < rows.size()) {
            Elements cols = rows.get(i).getChildElements();
            int j = 0;
            while (j < cols.size()) {
                names.add(cols.get(j).getLocalName());
                ++j;
            }
            ++i;
        }
        String[] columnNames = new String[names.size()];
        names.toArray(columnNames);
        return columnNames;
    }

    public String[] rowNames() {
        Elements rows = this.doc.getRootElement().getChildElements();
        String[] rowNames = new String[rows.size()];
        int i = 0;
        while (i < rowNames.length) {
            rowNames[i] = rows.get(i).getLocalName();
            ++i;
        }
        return rowNames;
    }

    public String toCSV() {
        String[] rowNames = this.rowNames();
        String[] columnNames = this.columnNames();
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < columnNames.length) {
            buf.append(',');
            buf.append(columnNames[j]);
            ++j;
        }
        int i = 0;
        while (i < rowNames.length) {
            buf.append('\r');
            buf.append(rowNames[i]);
            int j2 = 0;
            while (j2 < columnNames.length) {
                buf.append(',');
                buf.append(this.get(rowNames[i], columnNames[j2]));
                ++j2;
            }
            ++i;
        }
        return buf.toString();
    }
}

