/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.xquery;

import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nux.xom.pool.XOMUtil;
import nux.xom.xquery.StreamingPathFilterException;
import nux.xom.xquery.StreamingTransform;

public class StreamingPathFilter {
    private final String[] _namespaceURIs;
    private final String[] _localNames;

    public StreamingPathFilter(String locationPath, Map prefixes) throws StreamingPathFilterException {
        if (locationPath == null) {
            throw new StreamingPathFilterException("locationPath must not be null");
        }
        if (locationPath.indexOf("//") >= 0) {
            throw new StreamingPathFilterException("DESCENDANT axis is not supported");
        }
        String path = locationPath.trim();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((path = path.trim()).equals("")) {
            path = "*:*";
        }
        String[] localNames = path.split("/");
        String[] namespaceURIs = new String[localNames.length];
        int i = 0;
        while (i < localNames.length) {
            int k = localNames[i].indexOf(58);
            if (k >= 0 && localNames[i].indexOf(58, k + 1) >= 0) {
                throw new StreamingPathFilterException("QName must not contain more than one colon: qname='" + localNames[i] + "', path='" + path + "'");
            }
            if (k <= 0) {
                namespaceURIs[i] = "";
            } else {
                String prefix = localNames[i].substring(0, k).trim();
                if (k >= localNames[i].length() - 1) {
                    throw new StreamingPathFilterException("Missing localName for prefix: prefix='" + prefix + "', path='" + path + "', prefixes=" + prefixes);
                }
                if (prefix.equals("*")) {
                    namespaceURIs[i] = null;
                } else {
                    if (prefixes == null) {
                        throw new StreamingPathFilterException("prefixes must not be null");
                    }
                    Object uri = prefixes.get(prefix);
                    if (uri == null) {
                        throw new StreamingPathFilterException("Missing namespace for prefix: prefix='" + prefix + "', path='" + path + "', prefixes=" + prefixes);
                    }
                    namespaceURIs[i] = uri.toString().trim();
                }
            }
            localNames[i] = localNames[i].substring(k + 1).trim();
            if (localNames[i].equals("*")) {
                localNames[i] = null;
            }
            ++i;
        }
        this._localNames = localNames;
        this._namespaceURIs = namespaceURIs;
    }

    public NodeFactory createNodeFactory(NodeFactory childFactory, StreamingTransform transform) {
        if (childFactory == null) {
            childFactory = XOMUtil.getIgnoreWhitespaceOnlyTextNodeFactory();
        }
        return new StreamingPathFilterNodeFactory(this._localNames, this._namespaceURIs, childFactory, transform);
    }

    private static final class StreamingPathFilterNodeFactory
    extends NodeFactory {
        private final String[] namespaceURIs;
        private final String[] localNames;
        private final StreamingTransform transform;
        private final NodeFactory child;
        private int level;
        private Element mismatch;
        private final Nodes NONE = new Nodes();
        private static final boolean DEBUG = false;

        public StreamingPathFilterNodeFactory(String[] localNames, String[] namespaceURIs, NodeFactory child, StreamingTransform transform) {
            this.localNames = localNames;
            this.namespaceURIs = namespaceURIs;
            this.child = child;
            this.transform = transform;
        }

        public Document startMakingDocument() {
            this.level = -1;
            this.mismatch = null;
            return this.child.startMakingDocument();
        }

        public Element startMakingElement(String qname, String namespaceURI) {
            ++this.level;
            if (this.mismatch == null && this.level < this.localNames.length && !this.isMatch(qname, namespaceURI)) {
                this.mismatch = super.startMakingElement(qname, namespaceURI);
                return this.mismatch;
            }
            if (this.mismatch == null) {
                return super.startMakingElement(qname, namespaceURI);
            }
            --this.level;
            return null;
        }

        private boolean isMatch(String qname, String namespaceURI) {
            int i = qname.indexOf(58) + 1;
            String name = this.localNames[this.level];
            String uri = this.namespaceURIs[this.level];
            return !(name != null && !name.regionMatches(0, qname, i, Math.max(qname.length() - i, name.length())) || uri != null && !uri.equals(namespaceURI));
        }

        public Nodes finishMakingElement(Element elem) {
            if (this.level == 0) {
                this.mismatch = null;
                --this.level;
                return super.finishMakingElement(elem);
            }
            if (elem == this.mismatch) {
                this.mismatch = null;
                --this.level;
                return this.NONE;
            }
            if (this.level == this.localNames.length - 1) {
                return this.transformMatch(elem);
            }
            --this.level;
            if (this.level < this.localNames.length - 1 && !this.hasChildElements(elem)) {
                return this.NONE;
            }
            return super.finishMakingElement(elem);
        }

        private Nodes transformMatch(Element elem) {
            --this.level;
            if (this.transform == null) {
                return super.finishMakingElement(elem);
            }
            Nodes results = this.transform.transform(elem);
            int i = results.size();
            while (--i >= 0) {
                Node node = results.get(i);
                if (node == elem) continue;
                node.detach();
            }
            return results;
        }

        private boolean hasChildElements(Element elem) {
            int i = elem.getChildCount();
            while (--i >= 0) {
                if (!(elem.getChild(i) instanceof Element)) continue;
                return true;
            }
            return false;
        }

        public Nodes makeComment(String data) {
            return this.mismatch == null ? this.child.makeComment(data) : this.NONE;
        }

        public Nodes makeText(String data) {
            if (this.mismatch == null) {
                if (this.level == 0 && StreamingPathFilterNodeFactory.isWhitespaceOnly(data)) {
                    return this.NONE;
                }
                return this.child.makeText(data);
            }
            return this.NONE;
        }

        public Nodes makeAttribute(String qname, String URI2, String value, Attribute.Type type) {
            return this.mismatch == null ? this.child.makeAttribute(qname, URI2, value, type) : this.NONE;
        }

        public Nodes makeProcessingInstruction(String target, String data) {
            return this.mismatch == null ? this.child.makeProcessingInstruction(target, data) : this.NONE;
        }

        public Nodes makeDocType(String rootElementName, String publicID, String systemID) {
            return this.child.makeDocType(rootElementName, publicID, systemID);
        }

        public void finishMakingDocument(Document document) {
            this.child.finishMakingDocument(document);
        }

        private static boolean isWhitespace(char c) {
            switch (c) {
                case '\t': {
                    return true;
                }
                case '\n': {
                    return true;
                }
                case '\r': {
                    return true;
                }
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        private static boolean isWhitespaceOnly(String str) {
            int i = str.length();
            while (--i >= 0) {
                if (StreamingPathFilterNodeFactory.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }
}

