/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.lucene.analysis.LetterTokenizer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.index.memory.MemoryIndexTest;
import org.apache.lucene.index.memory.PatternAnalyzer;

public class PatternAnalyzerTest
extends TestCase {
    private static final Charset DEFAULT_PLATFORM_CHARSET = Charset.forName(new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding());

    public static void main(String[] args) throws Throwable {
        new PatternAnalyzerTest().run(args);
    }

    public void testMany() throws Throwable {
        String[] files = MemoryIndexTest.listFiles(new String[]{"../../*.txt", "../../*.html", "../../*.xml", "../../xdocs/*.xml", "../../src/test/org/apache/lucene/queryParser/*.java", "src/java/org/apache/lucene/index/memory/*.java"});
        System.out.println("files = " + Arrays.asList(files));
        String[] xargs = new String[]{"1", "1", "patluc", "1", "2", "2"};
        String[] args = new String[xargs.length + files.length];
        System.arraycopy(xargs, 0, args, 0, xargs.length);
        System.arraycopy(files, 0, args, xargs.length, files.length);
        this.run(args);
    }

    private void run(String[] args) throws Throwable {
        int k = -1;
        int iters = 1;
        if (args.length > ++k) {
            iters = Math.max(1, Integer.parseInt(args[k]));
        }
        int runs = 1;
        if (args.length > ++k) {
            runs = Math.max(1, Integer.parseInt(args[k]));
        }
        String cmd = "patluc";
        if (args.length > ++k) {
            cmd = args[k];
        }
        boolean usePattern = cmd.indexOf("pat") >= 0;
        boolean useLucene = cmd.indexOf("luc") >= 0;
        int maxLetters = 1;
        if (args.length > ++k) {
            maxLetters = Integer.parseInt(args[k]);
        }
        int maxToLower = 2;
        if (args.length > ++k) {
            maxToLower = Integer.parseInt(args[k]);
        }
        int maxStops = 2;
        if (args.length > ++k) {
            maxStops = Integer.parseInt(args[k]);
        }
        File[] files = new File[]{new File("CHANGES.txt"), new File("LICENSE.txt")};
        if (args.length > ++k) {
            files = new File[args.length - k];
            int i = k;
            while (i < args.length) {
                files[i - k] = new File(args[i]);
                ++i;
            }
        }
        int iter = 0;
        while (iter < iters) {
            System.out.println("\n########### iteration=" + iter);
            long start = System.currentTimeMillis();
            long bytes = 0L;
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.exists() && !file.isDirectory()) {
                    bytes += file.length();
                    String text = PatternAnalyzerTest.toString(new FileInputStream(file), null);
                    System.out.println("\n*********** FILE=" + file);
                    int letters = 0;
                    while (letters < maxLetters) {
                        boolean lettersOnly = letters == 0;
                        int stops = 0;
                        while (stops < maxStops) {
                            Set stopWords = null;
                            if (stops != 0) {
                                stopWords = StopFilter.makeStopSet((String[])StopAnalyzer.ENGLISH_STOP_WORDS);
                            }
                            int toLower = 0;
                            while (toLower < maxToLower) {
                                boolean toLowerCase = toLower != 0;
                                int run = 0;
                                while (run < runs) {
                                    List tokens1 = null;
                                    List tokens2 = null;
                                    try {
                                        if (usePattern) {
                                            tokens1 = this.getTokens(this.patternTokenStream(text, lettersOnly, toLowerCase, stopWords));
                                        }
                                        if (useLucene) {
                                            tokens2 = this.getTokens(this.luceneTokenStream(text, lettersOnly, toLowerCase, stopWords));
                                        }
                                        if (usePattern && useLucene) {
                                            this.assertEquals(tokens1, tokens2);
                                        }
                                    }
                                    catch (Throwable t) {
                                        if (t instanceof OutOfMemoryError) {
                                            t.printStackTrace();
                                        }
                                        System.out.println("fatal error at file=" + file + ", letters=" + lettersOnly + ", toLowerCase=" + toLowerCase + ", stopwords=" + (stopWords != null ? "english" : "none"));
                                        System.out.println("\n\ntokens1=" + this.toString(tokens1));
                                        System.out.println("\n\ntokens2=" + this.toString(tokens2));
                                        throw t;
                                    }
                                    ++run;
                                }
                                ++toLower;
                            }
                            ++stops;
                        }
                        ++letters;
                    }
                    long end = System.currentTimeMillis();
                    System.out.println("\nsecs = " + (float)(end - start) / 1000.0f);
                    System.out.println("files/sec= " + 1.0f * (float)runs * (float)maxLetters * (float)maxToLower * (float)maxStops * (float)files.length / ((float)(end - start) / 1000.0f));
                    float mb = 1.0f * (float)bytes * (float)runs * (float)maxLetters * (float)maxToLower * (float)maxStops / 1048576.0f;
                    System.out.println("MB/sec = " + mb / ((float)(end - start) / 1000.0f));
                }
                ++i;
            }
            ++iter;
        }
        if (usePattern && useLucene) {
            System.out.println("No bug found. done.");
        } else {
            System.out.println("Done benchmarking (without checking correctness).");
        }
    }

    private TokenStream patternTokenStream(String text, boolean letters, boolean toLowerCase, Set stopWords) {
        Pattern pattern = letters ? PatternAnalyzer.NON_WORD_PATTERN : PatternAnalyzer.WHITESPACE_PATTERN;
        PatternAnalyzer analyzer = new PatternAnalyzer(pattern, toLowerCase, stopWords);
        return analyzer.tokenStream("", text);
    }

    private TokenStream luceneTokenStream(String text, boolean letters, boolean toLowerCase, Set stopWords) {
        Object stream = letters ? new LetterTokenizer((Reader)new StringReader(text)) : new WhitespaceTokenizer((Reader)new StringReader(text));
        if (toLowerCase) {
            stream = new LowerCaseFilter((TokenStream)stream);
        }
        if (stopWords != null) {
            stream = new StopFilter((TokenStream)stream, stopWords);
        }
        return stream;
    }

    private List getTokens(TokenStream stream) throws IOException {
        Token token;
        ArrayList<Token> tokens = new ArrayList<Token>();
        while ((token = stream.next()) != null) {
            tokens.add(token);
        }
        return tokens;
    }

    private void assertEquals(List tokens1, List tokens2) {
        int size = Math.min(tokens1.size(), tokens2.size());
        int i = 0;
        try {
            while (i < size) {
                Token t1 = (Token)tokens1.get(i);
                Token t2 = (Token)tokens2.get(i);
                if (!t1.termText().equals(t2.termText())) {
                    throw new IllegalStateException("termText");
                }
                if (t1.startOffset() != t2.startOffset()) {
                    throw new IllegalStateException("startOffset");
                }
                if (t1.endOffset() != t2.endOffset()) {
                    throw new IllegalStateException("endOffset");
                }
                if (!t1.type().equals(t2.type())) {
                    throw new IllegalStateException("type");
                }
                ++i;
            }
            if (tokens1.size() != tokens2.size()) {
                throw new IllegalStateException("size1=" + tokens1.size() + ", size2=" + tokens2.size());
            }
        }
        catch (IllegalStateException e) {
            if (size > 0) {
                System.out.println("i=" + i + ", size=" + size);
                System.out.println("t1[size]='" + ((Token)tokens1.get(size - 1)).termText() + "'");
                System.out.println("t2[size]='" + ((Token)tokens2.get(size - 1)).termText() + "'");
            }
            throw e;
        }
    }

    private String toString(List tokens) {
        if (tokens == null) {
            return "null";
        }
        String str = "[";
        int i = 0;
        while (i < tokens.size()) {
            Token t1 = (Token)tokens.get(i);
            str = String.valueOf(str) + "'" + t1.termText() + "', ";
            ++i;
        }
        return String.valueOf(str) + "]";
    }

    private static String toString(InputStream input, Charset charset) throws IOException {
        if (charset == null) {
            charset = DEFAULT_PLATFORM_CHARSET;
        }
        byte[] data = PatternAnalyzerTest.toByteArray(input);
        return charset.decode(ByteBuffer.wrap(data)).toString();
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        byte[] byArray;
        block8: {
            byte[] output;
            byte[] buffer;
            int len;
            block6: {
                byte[] byArray2;
                block7: {
                    try {
                        int n;
                        len = Math.max(256, input.available());
                        buffer = new byte[len];
                        output = new byte[len];
                        len = 0;
                        while ((n = input.read(buffer)) >= 0) {
                            if (len + n > output.length) {
                                byte[] tmp = new byte[Math.max(output.length << 1, len + n)];
                                System.arraycopy(output, 0, tmp, 0, len);
                                System.arraycopy(buffer, 0, tmp, len, n);
                                buffer = output;
                                output = tmp;
                            } else {
                                System.arraycopy(buffer, 0, output, len, n);
                            }
                            len += n;
                        }
                        if (len != output.length) break block6;
                        byArray2 = output;
                        Object var6_8 = null;
                        if (input == null) break block7;
                    }
                    catch (Throwable throwable) {
                        block9: {
                            Object var6_10 = null;
                            if (input == null) break block9;
                            input.close();
                        }
                        throw throwable;
                    }
                    input.close();
                }
                return byArray2;
            }
            buffer = null;
            buffer = new byte[len];
            System.arraycopy(output, 0, buffer, 0, len);
            byArray = buffer;
            Object var6_9 = null;
            if (input == null) break block8;
            input.close();
        }
        return byArray;
    }
}

