/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.transformation.InputSet;
import com.metamatrix.metamodels.transformation.SqlAlias;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metadata.runtime.ColumnRecord;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.core.metadata.runtime.ProcedureParameterRecord;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnSetAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.internal.core.metadata.runtime.ColumnRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.TableRecordImpl;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlConstants;
import com.metamatrix.modeler.internal.transformation.util.SqlConverter;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.aspects.sql.InputParameterSqlAspect;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadataFactory;
import com.metamatrix.modeler.transformation.validation.SqlTransformationResult;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.query.o.f.j;
import com.metamatrix.query.o.h.aa;
import com.metamatrix.query.o.h.g;
import com.metamatrix.query.o.h.k;
import com.metamatrix.query.o.i.a;
import com.metamatrix.query.o.i.b;
import com.metamatrix.query.o.i.c;
import com.metamatrix.query.o.i.d;
import com.metamatrix.query.o.i.e;
import com.metamatrix.query.o.i.f;
import com.metamatrix.query.o.i.s;
import com.metamatrix.query.o.j.ad;
import com.metamatrix.query.o.j.ai;
import com.metamatrix.query.o.j.aj;
import com.metamatrix.query.o.j.al;
import com.metamatrix.query.o.j.ao;
import com.metamatrix.query.o.j.i;
import com.metamatrix.query.o.j.n;
import com.metamatrix.query.o.j.p;
import com.metamatrix.query.o.j.q;
import com.metamatrix.query.o.j.u;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class TransformationSqlHelper
implements SqlConstants {
    private static final TransformationSqlHelper INSTANCE = new TransformationSqlHelper();
    private static final String NEW_CONVERSION_NAME = "conversion";
    static /* synthetic */ Class class$java$lang$String;

    public static TransformationSqlHelper getInstance() {
        return INSTANCE;
    }

    public static boolean canAddGroupToSelectSql(EObject transMappingRoot) {
        boolean canUpdate = false;
        if (TransformationHelper.isValidQuery((Object)transMappingRoot) || TransformationHelper.isValidSetQuery((Object)transMappingRoot) || TransformationHelper.isSelectFromString((Object)transMappingRoot) || TransformationHelper.isInitialSelect((Object)transMappingRoot) || TransformationHelper.isEmptySelect((Object)transMappingRoot)) {
            canUpdate = true;
        }
        return canUpdate;
    }

    public static boolean canRemoveGroupFromSelectSql(EObject transMappingRoot) {
        boolean canUpdate = false;
        if (TransformationHelper.isValidQuery((Object)transMappingRoot) || TransformationHelper.isInitialSelect((Object)transMappingRoot) || TransformationHelper.isEmptySelect((Object)transMappingRoot)) {
            canUpdate = true;
        }
        return canUpdate;
    }

    public static void updateAllSqlOnSqlAliasGroupAdded(EObject transMappingRoot, EObject sqlAliasGroup, boolean addElemsToSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupAdded(transMappingRoot, sqlAliasGroup, addElemsToSelect, source);
    }

    public static void updateAllSqlOnSqlAliasGroupsAdded(EObject transMappingRoot, List sqlAliasGroups, boolean addElemsToSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupsAdded(transMappingRoot, sqlAliasGroups, addElemsToSelect, source);
    }

    public static void updateAllSqlOnSqlAliasGroupRemoved(EObject transMappingRoot, EObject sqlAliasGroup, boolean removeElemsFromSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupRemoved(transMappingRoot, sqlAliasGroup, removeElemsFromSelect, source);
    }

    public static void updateAllSqlOnSqlAliasGroupsRemoved(EObject transMappingRoot, List sqlAliasGroups, boolean removeElemsFromSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupsRemoved(transMappingRoot, sqlAliasGroups, removeElemsFromSelect, source);
    }

    public static void updateAllSqlOnElementsRemoved(EObject transMappingRoot, List elementEObjs, Object source) {
        TransformationSqlHelper.updateSqlOnElementsRemoved(transMappingRoot, elementEObjs, source);
    }

    public static void updateSelectSqlOnSqlAliasGroupAdded(EObject transMappingRoot, EObject sqlAliasGroup, boolean addElemsToSelect, Object source) {
        if (SqlAspectHelper.isTable((EObject)sqlAliasGroup) && (TransformationHelper.isParsableQuery((Object)transMappingRoot) || TransformationHelper.isInitialSelect((Object)transMappingRoot)) && sqlAliasGroup != null) {
            ArrayList<EObject> groups = new ArrayList<EObject>(1);
            groups.add(sqlAliasGroup);
            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
            TransformationSqlHelper.addSqlAliasGroupsToSelectStatement(transMappingRoot, groups, addElemsToSelect, source, validator);
        }
    }

    public static void updateSelectSqlOnSqlAliasGroupsAdded(EObject transMappingRoot, List sqlAliasGroups, boolean addElemsToSelect, Object source) {
        if (TransformationHelper.isParsableQuery((Object)transMappingRoot) || TransformationHelper.isInitialSelect((Object)transMappingRoot) || TransformationHelper.isEmptySelect((Object)transMappingRoot) || TransformationHelper.isSelectFromString((Object)transMappingRoot)) {
            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
            TransformationSqlHelper.addSqlAliasGroupsToSelectStatement(transMappingRoot, sqlAliasGroups, addElemsToSelect, source, validator);
        }
    }

    public static void updateSelectSqlOnSqlAliasGroupRemoved(EObject transMappingRoot, EObject sqlAliasGroup, boolean removeElemsFromSelect, Object source) {
        if (SqlAspectHelper.isTable((EObject)sqlAliasGroup)) {
            if (source == null) {
                source = TransformationSqlHelper.getInstance();
            }
            if ((TransformationHelper.isParsableQuery((Object)transMappingRoot) || TransformationHelper.isInitialSelect((Object)transMappingRoot)) && sqlAliasGroup != null) {
                ArrayList<EObject> groups = new ArrayList<EObject>(1);
                groups.add(sqlAliasGroup);
                TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
                TransformationSqlHelper.removeSqlAliasGroupsFromSelectStatement(transMappingRoot, groups, removeElemsFromSelect, source, validator);
            }
        }
    }

    public static void updateSelectSqlOnSqlAliasGroupsRemoved(EObject transMappingRoot, List sqlAliasGroups, boolean removeElemsFromSelect, Object source) {
        if (TransformationHelper.isParsableQuery((Object)transMappingRoot)) {
            if (source == null) {
                source = TransformationSqlHelper.getInstance();
            }
            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
            TransformationSqlHelper.removeSqlAliasGroupsFromSelectStatement(transMappingRoot, sqlAliasGroups, removeElemsFromSelect, source, validator);
        }
    }

    public static void updateSqlOnElementsRemoved(EObject transMappingRoot, List elementEObjs, Object source) {
        if (TransformationHelper.isParsableQuery((Object)transMappingRoot)) {
            if (source == null) {
                source = TransformationSqlHelper.getInstance();
            }
            TransformationSqlHelper.removeElementsFromStatement(transMappingRoot, elementEObjs, source);
        }
    }

    public static void updateUnionSelectOnGroupsAdded(EObject transMappingRoot, List sourceGroups, boolean useAll, Object txnSource) {
        if (TransformationHelper.isParsableQuery((Object)transMappingRoot) || TransformationHelper.isParsableSetQuery((Object)transMappingRoot) || TransformationHelper.isInitialSelect((Object)transMappingRoot) || TransformationHelper.isEmptySelect((Object)transMappingRoot)) {
            com.metamatrix.query.o.j.k command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
            if (command != null) {
                if (command instanceof ao) {
                    p newQuery = TransformationSqlHelper.createSetQueryAddUnionSources((ao)command, sourceGroups, useAll);
                    TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)newQuery.toString(), (boolean)false, (Object)txnSource);
                }
            } else {
                p newQuery = TransformationSqlHelper.createSetQueryAddUnionSources((ao)new p(0), sourceGroups, useAll);
                TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)newQuery.toString(), (boolean)false, (Object)txnSource);
            }
        }
    }

    public static void updateUnionSelectAddGroupsToSegment(EObject transMappingRoot, List sourceGroups, int nSegmentIndex, Object txnSource) {
        com.metamatrix.query.o.j.k command;
        if (TransformationHelper.isParsableSetQuery((Object)transMappingRoot) && (command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot)) != null && command instanceof p) {
            p newSetQuery = (p)command.clone();
            List queries = ((p)command).i1();
            ao queryCommand = (ao)queries.get(nSegmentIndex);
            if (queryCommand instanceof ad) {
                ad query = (ad)queryCommand;
                ad newQuery = TransformationSqlHelper.createQueryAddGroupsToFrom(query, sourceGroups);
                newSetQuery.iw();
                for (int i2 = 0; i2 < queries.size(); ++i2) {
                    if (i2 == nSegmentIndex) {
                        newSetQuery.iv((ao)newQuery);
                        continue;
                    }
                    newSetQuery.iv((ao)queries.get(i2));
                }
                TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)newSetQuery.toString(), (boolean)false, (Object)txnSource);
            }
        }
    }

    private static void addSqlAliasGroupsToSelectStatement(EObject transMappingRoot, List sqlAliasGroups, boolean addElemsToSelect, Object txnSource, TransformationValidator validator) {
        if (transMappingRoot == null || sqlAliasGroups == null) {
            return;
        }
        if (txnSource == null) {
            txnSource = TransformationSqlHelper.getInstance();
        }
        boolean isValid = SqlMappingRootCache.isSelectValid((Object)transMappingRoot);
        com.metamatrix.query.o.j.k command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
        if (isValid && command instanceof ad) {
            ad query = (ad)command;
            ad newQuery = TransformationSqlHelper.createQueryAddSqlAliasGroups(query, sqlAliasGroups, addElemsToSelect, 0, validator);
            TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)newQuery.toString(), (boolean)false, (Object)txnSource);
        } else if (TransformationHelper.isInitialSelect((Object)transMappingRoot) || TransformationHelper.isEmptySelect((Object)transMappingRoot)) {
            EObject targetGrp = TransformationHelper.getTransformationLinkTarget((EObject)transMappingRoot);
            if (!TransformationHelper.isSqlProcedure((Object)targetGrp)) {
                ad qry = TransformationSqlHelper.createDefaultQuery(null);
                qry = TransformationSqlHelper.createQueryAddSqlAliasGroups(qry, sqlAliasGroups, addElemsToSelect, 0, validator);
                TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)qry.toString(), (boolean)false, (Object)txnSource);
            } else if (sqlAliasGroups.size() == 1) {
                SqlAlias sqlAlias = (SqlAlias)sqlAliasGroups.get(0);
                EObject aliasedEObject = sqlAlias.getAliasedObject();
                if (TransformationHelper.isSqlProcedure((Object)aliasedEObject)) {
                    u proc = TransformationSqlHelper.createStoredProc((EObject)sqlAlias);
                    if (proc != null) {
                        com.metamatrix.query.o.f.d cCommand = TransformationSqlHelper.createVirtualProcCommmandForCommand((com.metamatrix.query.o.j.k)proc);
                        TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)cCommand.toString(), (boolean)false, (Object)txnSource);
                    }
                } else {
                    ad qry = TransformationSqlHelper.createDefaultQuery(null);
                    qry = TransformationSqlHelper.createQueryAddSqlAliasGroups(qry, sqlAliasGroups, addElemsToSelect, 0, validator);
                    com.metamatrix.query.o.f.d cCommand = TransformationSqlHelper.createVirtualProcCommmandForCommand((com.metamatrix.query.o.j.k)qry);
                    TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)cCommand.toString(), (boolean)false, (Object)txnSource);
                }
            } else {
                ad qry = TransformationSqlHelper.createDefaultQuery(null);
                qry = TransformationSqlHelper.createQueryAddSqlAliasGroups(qry, sqlAliasGroups, addElemsToSelect, 0, validator);
                com.metamatrix.query.o.f.d cCommand = TransformationSqlHelper.createVirtualProcCommmandForCommand((com.metamatrix.query.o.j.k)qry);
                TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)cCommand.toString(), (boolean)false, (Object)txnSource);
            }
        } else if (TransformationHelper.isSelectFromString((Object)transMappingRoot)) {
            StringBuffer sb = new StringBuffer(TransformationHelper.getSelectSqlString((Object)transMappingRoot));
            sb.append(" ");
            List clausesToAdd = TransformationSqlHelper.createFromClauses(sqlAliasGroups);
            Iterator iter = clausesToAdd.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)sb.toString(), (boolean)false, (Object)txnSource);
        }
    }

    public static com.metamatrix.query.o.f.d createVirtualProcCommmandForCommand(com.metamatrix.query.o.j.k command) {
        com.metamatrix.query.o.f.c cmdStmt;
        com.metamatrix.query.o.f.e block = new com.metamatrix.query.o.f.e();
        if (command.gj() == 6) {
            if (command.gc().size() > 0) {
                com.metamatrix.query.o.j.b subquery = new com.metamatrix.query.o.j.b("PROC", command);
                i from = new i();
                from.fw((ai)subquery);
                q select = new q();
                select.j0((b)new com.metamatrix.query.o.i.q());
                ad query = new ad(select, from, null, null, null);
                query.gf(true);
                block.l((j)new com.metamatrix.query.o.f.c((com.metamatrix.query.o.j.k)query));
            } else {
                cmdStmt = new com.metamatrix.query.o.f.c(command);
                block.l((j)cmdStmt);
                q select = new q();
                select.j0((b)new d("RESULT", (com.metamatrix.query.o.i.j)new com.metamatrix.query.o.i.n("RESULT", (s)new c((Object)Boolean.TRUE))));
                ad query = new ad(select, null, null, null, null);
                query.gf(true);
                block.l((j)new com.metamatrix.query.o.f.c((com.metamatrix.query.o.j.k)query));
            }
        } else {
            cmdStmt = new com.metamatrix.query.o.f.c(command);
            block.l((j)cmdStmt);
        }
        com.metamatrix.query.o.f.d cCommand = new com.metamatrix.query.o.f.d(block);
        cCommand.gz(false);
        return cCommand;
    }

    private static ad createQueryAddSqlAliasGroupElemsToSelect(ad resolvedQuery, List addedSqlAliasGroups) {
        ad result = null;
        if (!TransformationSqlHelper.isSelectStar(resolvedQuery.i9())) {
            result = (ad)resolvedQuery.clone();
            q select = resolvedQuery.i9();
            List currentSelectSymbols = select.j9();
            List newElementSymbols = TransformationSqlHelper.createElemSymbols(addedSqlAliasGroups);
            ArrayList selectSymbols = new ArrayList();
            selectSymbols.addAll(currentSelectSymbols);
            selectSymbols.addAll(newElementSymbols);
            List newSelectSymbols = TransformationSqlHelper.renameConflictingSymbols(selectSymbols);
            if (newSelectSymbols.size() == 0) {
                newSelectSymbols.add(new com.metamatrix.query.o.i.q());
                select.jx(newSelectSymbols);
            } else {
                select.jx(newSelectSymbols);
            }
            result.jc(select);
        }
        return result;
    }

    private static ad createQueryAddSqlAliasGroupsToFrom(ad resolvedQuery, List sqlAliasGroups) {
        ad result = null;
        if (resolvedQuery != null && sqlAliasGroups != null) {
            result = (ad)resolvedQuery.clone();
            i from = resolvedQuery.jf();
            i newFrom = from != null ? (i)from.clone() : new i();
            ArrayList currentGroupSymbols = new ArrayList();
            com.metamatrix.query.o.h.d.ea((com.metamatrix.query.o.d)resolvedQuery, currentGroupSymbols);
            List clausesToAdd = TransformationSqlHelper.createFromClauses(sqlAliasGroups);
            Iterator iter = clausesToAdd.iterator();
            while (iter.hasNext()) {
                newFrom.fw((ai)iter.next());
            }
            result.i3(newFrom);
        }
        return result;
    }

    private static ad createQueryAddGroupsToFrom(ad query, List grpEObjs) {
        ad result = null;
        if (query != null && grpEObjs != null) {
            result = (ad)query.clone();
            i from = query.jf();
            i newFrom = from != null ? (i)from.clone() : new i();
            for (int i2 = 0; i2 < grpEObjs.size(); ++i2) {
                EObject grpEObj = (EObject)grpEObjs.get(i2);
                ai fClause = TransformationSqlHelper.createFromClause(grpEObj);
                newFrom.fw(fClause);
            }
            result.i3(newFrom);
        }
        return result;
    }

    private static ad createQueryAddSqlAliasGroups(ad resolvedQuery, List sqlAliasGroups, boolean addGroupElemsToSelect, int cmdType, TransformationValidator validator) {
        ad result = null;
        if (resolvedQuery != null && sqlAliasGroups != null) {
            SqlTransformationResult resolverResult;
            result = TransformationSqlHelper.createQueryAddSqlAliasGroupsToFrom(resolvedQuery, sqlAliasGroups);
            SqlTransformationResult parserResult = TransformationValidator.parseSQL((String)result.toString());
            ad resultQuery = (ad)parserResult.getCommand();
            boolean isResolvable = false;
            boolean isValid = false;
            if (resultQuery != null && (isResolvable = (resolverResult = validator.resolveCommand((com.metamatrix.query.o.j.k)resultQuery, cmdType)).isResolvable())) {
                SqlTransformationResult validationResult = validator.validateCommand((com.metamatrix.query.o.j.k)resultQuery);
                isValid = validationResult.isValidatable();
            }
            if (isValid) {
                q select = resultQuery.i9();
                result = TransformationSqlHelper.isSelectStar(select) ? TransformationSqlHelper.createQueryFixNameConflicts(resultQuery) : (addGroupElemsToSelect ? TransformationSqlHelper.createQueryAddSqlAliasGroupElemsToSelect(resultQuery, sqlAliasGroups) : resultQuery);
            }
        }
        return result;
    }

    private static p createSetQueryAddUnionSources(ao queryCommand, List unionSourceGrps, boolean useAll) {
        p result = null;
        if (queryCommand != null) {
            if (queryCommand instanceof ad) {
                result = new p(0);
                result.iv((ao)((ad)queryCommand.clone()));
            } else if (queryCommand instanceof p) {
                result = (p)queryCommand.clone();
            }
            Iterator iter = unionSourceGrps.iterator();
            while (iter.hasNext()) {
                EObject sourceGroup = (EObject)iter.next();
                ad qry = TransformationSqlHelper.createDefaultQuery(sourceGroup);
                result.it((ao)qry, useAll);
            }
        }
        return result;
    }

    private static void removeSqlAliasGroupsFromSelectStatement(EObject transMappingRoot, List sqlAliasGroups, boolean removeElemsFromSelect, Object txnSource, TransformationValidator validator) {
        if (transMappingRoot == null || sqlAliasGroups == null) {
            return;
        }
        if (txnSource == null) {
            txnSource = TransformationSqlHelper.getInstance();
        }
        boolean isValid = SqlMappingRootCache.isSelectValid((Object)transMappingRoot);
        com.metamatrix.query.o.j.k command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
        if (isValid && command instanceof ad) {
            ad query = (ad)command;
            ad newQuery = TransformationSqlHelper.createQueryRemoveSqlAliasGroups(query, sqlAliasGroups, removeElemsFromSelect, 0, validator);
            TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)newQuery.toString(), (boolean)false, (Object)txnSource);
        } else {
            TransformationSqlHelper.rebuildQueryRemovingSqlAliasGroups(transMappingRoot, sqlAliasGroups);
        }
    }

    private static void removeElementsFromStatement(EObject transMappingRoot, List elementEObjs, Object txnSource) {
        ad query;
        ad newQuery;
        if (transMappingRoot == null || elementEObjs == null) {
            return;
        }
        if (txnSource == null) {
            txnSource = TransformationSqlHelper.getInstance();
        }
        boolean isValid = SqlMappingRootCache.isSelectValid((Object)transMappingRoot);
        com.metamatrix.query.o.j.k command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
        if (isValid && command instanceof ad && (newQuery = TransformationSqlHelper.createQueryRemoveElems(query = (ad)command, elementEObjs)) != null) {
            TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)newQuery.toString(), (boolean)false, (Object)txnSource);
        }
    }

    private static void rebuildQueryRemovingSqlAliasGroups(EObject transMappingRoot, List sqlAliasGroups) {
        if (transMappingRoot == null || sqlAliasGroups == null) {
            return;
        }
    }

    private static ad createQueryRemoveSqlAliasGroupElemsFromSelect(ad resolvedQuery, List removeSqlAliasGroups) {
        ad result = null;
        if (TransformationSqlHelper.hasSqlAliasGroupAttributes(resolvedQuery, removeSqlAliasGroups)) {
            result = (ad)resolvedQuery.clone();
            List aliasGroupSymbols = TransformationSqlHelper.createGroupSymbols(removeSqlAliasGroups);
            q select = resolvedQuery.i9();
            List currentSelectSymbols = select.j9();
            ArrayList<Object> newSelectSymbols = new ArrayList<Object>(currentSelectSymbols.size());
            Iterator iter = currentSelectSymbols.iterator();
            while (iter.hasNext()) {
                b selectSymbol = (b)iter.next();
                Collection symbolGroups = aa.gz((com.metamatrix.query.o.d)selectSymbol);
                Iterator symbolGroupIter = symbolGroups.iterator();
                boolean removeSymbol = false;
                while (symbolGroupIter.hasNext()) {
                    f symbGroup = (f)symbolGroupIter.next();
                    Iterator removeGroupIter = aliasGroupSymbols.iterator();
                    while (removeGroupIter.hasNext()) {
                        f removeGroupSymbol = (f)removeGroupIter.next();
                        if (!symbGroup.equals((Object)removeGroupSymbol)) continue;
                        removeSymbol = true;
                        break;
                    }
                    if (!removeSymbol) continue;
                    break;
                }
                if (removeSymbol) continue;
                newSelectSymbols.add(selectSymbol);
            }
            if (newSelectSymbols.size() == 0) {
                newSelectSymbols.add(new com.metamatrix.query.o.i.q());
                select.jx(newSelectSymbols);
            } else {
                select.jx(newSelectSymbols);
            }
            result.jc(select);
        }
        return result;
    }

    protected static ad createQueryRemoveElems(ad resolvedQuery, List removeElements) {
        ad result = resolvedQuery;
        ArrayList<String> removeNames = new ArrayList<String>(removeElements.size());
        Iterator iter = removeElements.iterator();
        while (iter.hasNext()) {
            Object remElem = iter.next();
            if (!(remElem instanceof EObject) || !SqlAspectHelper.isColumn((EObject)((EObject)remElem))) continue;
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)((EObject)remElem));
            removeNames.add(columnAspect.getName((EObject)remElem));
        }
        if (TransformationSqlHelper.hasSqlElemSymbols(resolvedQuery, removeElements)) {
            result = (ad)resolvedQuery.clone();
            q select = resolvedQuery.i9();
            List currentSelectSymbols = resolvedQuery.gc();
            List newSelectSymbols = TransformationSqlHelper.removeSymbols(currentSelectSymbols, removeNames);
            select.jx(newSelectSymbols);
            result.jc(select);
        }
        if (result.i6() != null) {
            aj groupBy = result.i6();
            List currentGroupBySymbols = groupBy.kc();
            List newGroupBySymbols = TransformationSqlHelper.removeSymbols(currentGroupBySymbols, removeNames);
            groupBy.kg((Collection)newGroupBySymbols);
            if (groupBy.kb() == 0) {
                result.ja(null);
            } else {
                result.ja(groupBy);
            }
        }
        if (result.ir() != null) {
            com.metamatrix.query.o.j.g orderBy = result.ir();
            Iterator iter2 = orderBy.fh().iterator();
            while (iter2.hasNext()) {
                com.metamatrix.query.o.i.j seSymbol;
                String name;
                Object next = iter2.next();
                if (!(next instanceof com.metamatrix.query.o.i.j) || !removeNames.contains(name = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol = (com.metamatrix.query.o.i.j)next, false))) continue;
                iter2.remove();
            }
            if (orderBy.fj() == 0) {
                result.is(null);
            } else {
                result.is(orderBy);
            }
        }
        return result;
    }

    private static List removeSymbols(List currentSymbols, List symbolNamesToRemove) {
        if (currentSymbols == null || symbolNamesToRemove == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<com.metamatrix.query.o.i.j> result = new ArrayList<com.metamatrix.query.o.i.j>(currentSymbols.size());
        Iterator iter = currentSymbols.iterator();
        while (iter.hasNext()) {
            com.metamatrix.query.o.i.j seSymbol;
            String symName;
            Object next = iter.next();
            if (!(next instanceof com.metamatrix.query.o.i.j) || symbolNamesToRemove.contains(symName = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol = (com.metamatrix.query.o.i.j)next, false))) continue;
            result.add(seSymbol);
        }
        return result;
    }

    private static ad createQueryRemoveSqlAliasGroupsFromFrom(ad resolvedQuery, List removedSqlAliasGrps) {
        ad result = null;
        if (resolvedQuery != null) {
            result = (ad)resolvedQuery.clone();
            i from = resolvedQuery.jf();
            List currentFromClauses = from.ft();
            ArrayList<ai> newFromClauses = new ArrayList<ai>(currentFromClauses.size());
            Iterator iter = currentFromClauses.iterator();
            while (iter.hasNext()) {
                ai fromClause = (ai)iter.next();
                boolean removeIt = false;
                Iterator removeSqlAliasGrpIter = removedSqlAliasGrps.iterator();
                while (removeSqlAliasGrpIter.hasNext()) {
                    EObject removeGroupEObj = (EObject)removeSqlAliasGrpIter.next();
                    if (fromClause instanceof n) {
                        f gSymbol = ((n)fromClause).cs();
                        f removeGroupSymbol = TransformationSqlHelper.createGroupSymbol(removeGroupEObj);
                        if (gSymbol == null || !gSymbol.equals((Object)removeGroupSymbol)) continue;
                        removeIt = true;
                        break;
                    }
                    if (!(fromClause instanceof com.metamatrix.query.o.j.b)) continue;
                    com.metamatrix.query.o.j.b sqf = (com.metamatrix.query.o.j.b)fromClause;
                    if (!(removeGroupEObj instanceof SqlAlias) || !TransformationSqlHelper.isMatch(sqf, (SqlAlias)removeGroupEObj)) continue;
                    removeIt = true;
                    break;
                }
                if (removeIt) continue;
                newFromClauses.add(fromClause);
            }
            from.fu(newFromClauses);
            result.i3(from);
        }
        return result;
    }

    public static boolean isMatch(com.metamatrix.query.o.j.b subqueryFrom, SqlAlias sqlAlias) {
        boolean isMatch = false;
        if (subqueryFrom != null && sqlAlias != null) {
            com.metamatrix.query.o.j.k fromClauseQuery = subqueryFrom.r();
            String fromClauseName = subqueryFrom.c4();
            if (fromClauseQuery instanceof u) {
                u fromClauseProc = (u)fromClauseQuery;
                String fromClauseProcName = fromClauseProc.ho();
                String sqlAliasName = sqlAlias.getAlias();
                EObject sqlAliasEObj = sqlAlias.getAliasedObject();
                if (fromClauseName != null && fromClauseName.equalsIgnoreCase(sqlAliasName) && TransformationHelper.isSqlProcedure((Object)sqlAliasEObj)) {
                    com.metamatrix.query.m.a procInfo = TransformationSqlHelper.getProcInfo(TransformationHelper.getSqlEObjectFullName((EObject)sqlAliasEObj), sqlAliasEObj);
                    String sqlAliasProcName = procInfo.b();
                    if (fromClauseProcName != null && fromClauseProcName.equalsIgnoreCase(sqlAliasProcName)) {
                        isMatch = true;
                    }
                }
            }
        }
        return isMatch;
    }

    public static boolean isMatch(u storedProc, SqlAlias sqlAlias) {
        boolean isMatch = false;
        if (storedProc != null && sqlAlias != null) {
            com.metamatrix.query.m.a procInfo;
            String sqlAliasProcName;
            String procName = storedProc.ho();
            String sqlAliasName = sqlAlias.getAlias();
            EObject sqlAliasEObj = sqlAlias.getAliasedObject();
            if (procName != null && procName.equalsIgnoreCase(sqlAliasName) && TransformationHelper.isSqlProcedure((Object)sqlAliasEObj) && procName.equalsIgnoreCase(sqlAliasProcName = (procInfo = TransformationSqlHelper.getProcInfo(TransformationHelper.getSqlEObjectFullName((EObject)sqlAliasEObj), sqlAliasEObj)).b())) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    private static ad createQueryRemoveSqlAliasGroups(ad resolvedQuery, List sqlAliasGroups, boolean removeGroupElemsFromSelect, int cmdType, TransformationValidator validator) {
        ad result = null;
        if (resolvedQuery != null && sqlAliasGroups != null) {
            if (!TransformationSqlHelper.isSelectStar(resolvedQuery.i9()) && TransformationSqlHelper.hasSqlAliasGroupAttributes(resolvedQuery, sqlAliasGroups)) {
                result = removeGroupElemsFromSelect ? TransformationSqlHelper.createQueryRemoveSqlAliasGroupElemsFromSelect(resolvedQuery, sqlAliasGroups) : resolvedQuery;
            }
            ad resultQuery = null;
            boolean isValid = false;
            if (result != null) {
                SqlTransformationResult resolverResult;
                SqlTransformationResult parserResult = TransformationValidator.parseSQL((String)result.toString());
                resultQuery = (ad)parserResult.getCommand();
                boolean isResolvable = false;
                if (result != null && (isResolvable = (resolverResult = validator.resolveCommand((com.metamatrix.query.o.j.k)resultQuery, cmdType)).isResolvable())) {
                    SqlTransformationResult validationResult = validator.validateCommand((com.metamatrix.query.o.j.k)resultQuery);
                    isValid = validationResult.isValidatable();
                }
            } else {
                resultQuery = resolvedQuery;
                isValid = true;
            }
            if (isValid) {
                result = TransformationSqlHelper.createQueryRemoveSqlAliasGroupsFromFrom(resolvedQuery, sqlAliasGroups);
            }
        }
        return result;
    }

    public static ad createQueryFixNameConflicts(ad resolvedQuery) {
        ad modifiedQuery = null;
        if (resolvedQuery != null) {
            modifiedQuery = (ad)resolvedQuery.clone();
            if (TransformationSqlHelper.hasProjectedSymbolNameConflict((com.metamatrix.query.o.j.k)resolvedQuery)) {
                List currentSymbols = resolvedQuery.i9().j9();
                List newSymbols = TransformationSqlHelper.renameConflictingSymbols(currentSymbols);
                q newSelect = new q(newSymbols);
                modifiedQuery.jc(newSelect);
            }
        }
        return modifiedQuery;
    }

    public static ad createDefaultQuery(EObject source) {
        ai clause;
        q newSelect = new q();
        newSelect.j0((b)new com.metamatrix.query.o.i.q());
        i newFrom = new i();
        if (source != null && (clause = TransformationSqlHelper.createFromClause(source)) != null) {
            newFrom.fw(clause);
        }
        ad query = new ad();
        query.jc(newSelect);
        query.i3(newFrom);
        return query;
    }

    public static boolean hasProjectedSymbolNameConflict(com.metamatrix.query.o.j.k command) {
        boolean hasConflict = false;
        if (command != null) {
            ArrayList<String> attrNames = new ArrayList<String>();
            List symbols = command.gc();
            Iterator symbolIter = symbols.iterator();
            while (symbolIter.hasNext()) {
                com.metamatrix.query.o.i.j seSymbol = (com.metamatrix.query.o.i.j)symbolIter.next();
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol, false);
                String uniqueName = TransformationSqlHelper.getUniqueName(name, attrNames);
                if (!uniqueName.equals(name)) {
                    hasConflict = true;
                    break;
                }
                attrNames.add(uniqueName);
            }
        }
        return hasConflict;
    }

    public static List getProjectedSymbolNames(com.metamatrix.query.o.j.k command) {
        if (command == null) {
            return Collections.EMPTY_LIST;
        }
        List projectedSymbols = command.gc();
        ArrayList<String> symbolNames = null;
        if (projectedSymbols == null || projectedSymbols.isEmpty()) {
            symbolNames = Collections.EMPTY_LIST;
        } else {
            symbolNames = new ArrayList<String>(projectedSymbols.size());
            Iterator symbolIter = projectedSymbols.iterator();
            while (symbolIter.hasNext()) {
                com.metamatrix.query.o.i.j symbol = (com.metamatrix.query.o.i.j)symbolIter.next();
                String shortName = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                if (shortName == null) continue;
                symbolNames.add(shortName);
            }
        }
        return symbolNames;
    }

    public static String getSingleElementSymbolShortName(com.metamatrix.query.o.i.j symbol, boolean showExpression) {
        String symbolName = "";
        if (symbol != null) {
            if (symbol instanceof com.metamatrix.query.o.i.n) {
                s expr = ((com.metamatrix.query.o.i.n)symbol).a6();
                if (expr instanceof e) {
                    e func = (e)expr;
                    if (func.bv()) {
                        Collection elementSymbols = k.e4((com.metamatrix.query.o.d)func, (boolean)true);
                        if (elementSymbols.size() == 1) {
                            a element = (a)elementSymbols.iterator().next();
                            symbolName = element.a3();
                        } else {
                            symbolName = showExpression ? symbol.toString() : symbol.a3();
                        }
                    } else {
                        symbolName = showExpression ? symbol.toString() : symbol.a3();
                    }
                } else {
                    symbolName = showExpression ? symbol.toString() : symbol.a3();
                }
            } else {
                symbolName = symbol.a3();
            }
        }
        return symbolName;
    }

    public static List getProjectedSymbolUniqueNames(com.metamatrix.query.o.j.k command) {
        ArrayList<String> uniqueNames = new ArrayList<String>();
        List selectNames = TransformationSqlHelper.getProjectedSymbolNames(command);
        Iterator iter = selectNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!uniqueNames.contains(name)) {
                uniqueNames.add(name);
                continue;
            }
            String uniqueName = TransformationSqlHelper.getUniqueName(name, uniqueNames);
            uniqueNames.add(uniqueName);
        }
        return uniqueNames;
    }

    public static List getProjectedSymbolAndProcInputUniqueNames(com.metamatrix.query.o.j.k command) {
        List uniqueNames = TransformationSqlHelper.getProjectedSymbolUniqueNames(command);
        List paramNames = TransformationSqlHelper.getProcedureInputParamNames(command);
        uniqueNames.addAll(paramNames);
        return uniqueNames;
    }

    public static List getProcedureInputParamNames(com.metamatrix.query.o.j.k command) {
        List params = TransformationSqlHelper.getProcedureInputParams(command);
        ArrayList<String> result = new ArrayList<String>(params.size());
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            al param = (al)iter.next();
            String paramName = null;
            if (param.s() == null) {
                paramName = param.r() != null ? param.r() : "?";
            } else {
                s exp = param.s();
                if (exp instanceof a) {
                    paramName = ((a)exp).a3();
                }
            }
            if (paramName == null || TransformationSqlHelper.containsIgnoreCase(result, paramName)) continue;
            result.add(paramName);
        }
        return result;
    }

    private static boolean containsIgnoreCase(List strList, String str) {
        boolean contains = false;
        Iterator iter = strList.iterator();
        while (iter.hasNext()) {
            String listStr = (String)iter.next();
            if (listStr == null || !listStr.equalsIgnoreCase(str)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static List getProcedureInputParams(com.metamatrix.query.o.j.k command) {
        if (command == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<al> inputParams = new ArrayList<al>();
        if (command instanceof u) {
            List procInParams = ((u)command).h0();
            inputParams.addAll(procInParams);
        }
        List commands = com.metamatrix.query.o.h.c.d7((com.metamatrix.query.o.d)command);
        Iterator iter = commands.iterator();
        while (iter.hasNext()) {
            com.metamatrix.query.o.j.k currentCommand = (com.metamatrix.query.o.j.k)iter.next();
            if (!(currentCommand instanceof u)) continue;
            List params = ((u)currentCommand).h0();
            Iterator pIter = params.iterator();
            while (pIter.hasNext()) {
                al parm = (al)pIter.next();
                if (TransformationSqlHelper.spParamListContains(inputParams, parm)) continue;
                inputParams.add(parm);
            }
        }
        return inputParams;
    }

    private static boolean spParamListContains(List spParams, al newParam) {
        boolean containsParam = false;
        if (spParams != null) {
            Iterator iter = spParams.iterator();
            while (iter.hasNext()) {
                al param = (al)iter.next();
                if (!param.equals((Object)newParam)) continue;
                Object id1 = param.j();
                Object id2 = newParam.j();
                if (id1 == null || !id1.equals(id2)) continue;
                containsParam = true;
            }
        }
        return containsParam;
    }

    public static Map getProcInputParamEObjects(u storedProc) {
        HashMap<String, EObject> symbolEObjMap = new HashMap<String, EObject>();
        if (storedProc != null) {
            List inputParams = storedProc.h0();
            Iterator iter = inputParams.iterator();
            while (iter.hasNext()) {
                al param = (al)iter.next();
                a symbol = param.w();
                String name = symbol.a3();
                EObject eObj = TransformationSqlHelper.getElementSymbolEObject(symbol);
                if (eObj == null) continue;
                symbolEObjMap.put(name, eObj);
            }
        }
        return symbolEObjMap;
    }

    public static String getUniqueName(String name, Collection collection) {
        if (collection == null) {
            collection = Collections.EMPTY_SET;
        }
        String result = name;
        int incr = 1;
        boolean nameIsInCollection = false;
        block0: do {
            nameIsInCollection = false;
            Iterator i2 = collection.iterator();
            while (i2.hasNext()) {
                if (!result.equalsIgnoreCase((String)i2.next())) continue;
                nameIsInCollection = true;
                result = name + "_" + incr;
                ++incr;
                continue block0;
            }
        } while (nameIsInCollection);
        return result;
    }

    public static Map getProjectedSymbolUniqueTypes(com.metamatrix.query.o.j.k command) {
        if (command != null) {
            HashMap<String, Object> symbolTypeMap = new HashMap<String, Object>();
            List symbols = command.gc();
            Iterator symbolIter = symbols.iterator();
            while (symbolIter.hasNext()) {
                com.metamatrix.query.o.i.j symbol = (com.metamatrix.query.o.i.j)symbolIter.next();
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                Object typeObj = TransformationSqlHelper.getElementSymbolType(symbol);
                Set currentNames = symbolTypeMap.size() != 0 ? symbolTypeMap.keySet() : Collections.EMPTY_SET;
                String uniqueName = TransformationSqlHelper.getUniqueName(name, currentNames);
                symbolTypeMap.put(uniqueName, typeObj);
            }
            return symbolTypeMap;
        }
        return Collections.EMPTY_MAP;
    }

    public static Map getProjectedSymbolAndProcInputUniqueTypes(com.metamatrix.query.o.j.k command) {
        if (command != null) {
            Map symbolTypeMap = TransformationSqlHelper.getProjectedSymbolUniqueTypes(command);
            List inputParams = TransformationSqlHelper.getProcedureInputParams(command);
            Iterator iter = inputParams.iterator();
            while (iter.hasNext()) {
                al param = (al)iter.next();
                a symbol = param.w();
                String name = symbol.a3();
                Object eObj = TransformationSqlHelper.getElementSymbolType((com.metamatrix.query.o.i.j)symbol);
                symbolTypeMap.put(name, eObj);
            }
            return symbolTypeMap;
        }
        return Collections.EMPTY_MAP;
    }

    public static Map getProjectedSymbolEObjects(com.metamatrix.query.o.j.k command) {
        HashMap<String, EObject> symbolEObjMap = new HashMap<String, EObject>();
        if (command != null) {
            List symbols = command.gc();
            Iterator symbolIter = symbols.iterator();
            while (symbolIter.hasNext()) {
                com.metamatrix.query.o.i.j symbol = (com.metamatrix.query.o.i.j)symbolIter.next();
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                EObject eObj = null;
                if (symbol instanceof a) {
                    eObj = TransformationSqlHelper.getElementSymbolEObject((a)symbol);
                }
                Set currentNames = symbolEObjMap.size() != 0 ? symbolEObjMap.keySet() : Collections.EMPTY_SET;
                String uniqueName = TransformationSqlHelper.getUniqueName(name, currentNames);
                if (eObj == null) continue;
                symbolEObjMap.put(uniqueName, eObj);
            }
        }
        return symbolEObjMap;
    }

    public static Map getProjectedSymbolAndProcInputEObjects(com.metamatrix.query.o.j.k command) {
        Map projectedSymbolEObjMap = TransformationSqlHelper.getProjectedSymbolEObjects(command);
        if (command != null) {
            List inputParams = TransformationSqlHelper.getProcedureInputParams(command);
            Iterator iter = inputParams.iterator();
            while (iter.hasNext()) {
                al param = (al)iter.next();
                a symbol = param.w();
                String name = symbol.a3();
                EObject eObj = TransformationSqlHelper.getElementSymbolEObject(symbol);
                if (eObj == null) continue;
                projectedSymbolEObjMap.put(name, eObj);
            }
        }
        return projectedSymbolEObjMap;
    }

    public static Map getProjectedSymbolLengths(com.metamatrix.query.o.j.k command, boolean hasXMLDocSource) {
        HashMap symbolLengthMap = new HashMap();
        if (command != null) {
            List symbols = command.gc();
            Iterator symbolIter = symbols.iterator();
            while (symbolIter.hasNext()) {
                com.metamatrix.query.o.i.j symbol = (com.metamatrix.query.o.i.j)symbolIter.next();
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                Object typeObj = TransformationSqlHelper.getElementSymbolType(symbol);
                boolean xmlDocSourceCase = hasXMLDocSource && command instanceof com.metamatrix.query.o.f.d;
                Set currentNames = symbolLengthMap.size() != 0 ? symbolLengthMap.keySet() : Collections.EMPTY_SET;
                String uniqueName = TransformationSqlHelper.getUniqueName(name, currentNames);
                TransformationSqlHelper.updateTypeLengthMap(symbolLengthMap, uniqueName, typeObj, symbol, xmlDocSourceCase);
            }
        }
        return symbolLengthMap;
    }

    public static Map getProjectedSymbolAndProcInputLengths(com.metamatrix.query.o.j.k command, boolean hasXMLDocSource) {
        Map symbolLengthMap = TransformationSqlHelper.getProjectedSymbolLengths(command, hasXMLDocSource);
        if (command != null) {
            List inputParams = TransformationSqlHelper.getProcedureInputParams(command);
            Iterator paramIter = inputParams.iterator();
            while (paramIter.hasNext()) {
                al param = (al)paramIter.next();
                a symbol = param.w();
                String name = symbol.a3();
                Object typeObj = TransformationSqlHelper.getElementSymbolType((com.metamatrix.query.o.i.j)symbol);
                boolean xmlDocSourceCase = hasXMLDocSource && command instanceof com.metamatrix.query.o.f.d;
                TransformationSqlHelper.updateTypeLengthMap(symbolLengthMap, name, typeObj, (com.metamatrix.query.o.i.j)symbol, xmlDocSourceCase);
            }
        }
        return symbolLengthMap;
    }

    private static void updateTypeLengthMap(Map theMap, String name, Object typeObj, com.metamatrix.query.o.i.j symbol, boolean xmlDocSourceCase) {
        if (typeObj != null && typeObj instanceof XSDSimpleTypeDefinition) {
            String dtName = ((XSDSimpleTypeDefinition)typeObj).getName();
            if (("string".equals(dtName) || "char".equals(dtName)) && ModelerCore.getWorkspaceDatatypeManager().isBuiltInDatatype((EObject)((XSDSimpleTypeDefinition)typeObj))) {
                int length = TransformationSqlHelper.getElementSymbolLength(symbol);
                theMap.put(name, new Integer(length));
            } else {
                theMap.put(name, new Integer(-1));
            }
        } else if (typeObj != null) {
            if (typeObj instanceof Class) {
                if (xmlDocSourceCase) {
                    theMap.put(name, new Integer(Integer.MAX_VALUE));
                } else {
                    String className = ((Class)typeObj).getName();
                    if (className.equalsIgnoreCase("java.lang.String")) {
                        int stringLength = TransformationSqlHelper.getSymbolLength(symbol);
                        if (stringLength > 0) {
                            theMap.put(name, new Integer(stringLength));
                        } else {
                            theMap.put(name, new Integer(ModelerCore.getTransformationPreferences().getDefaultStringLength()));
                        }
                    } else if (className.equalsIgnoreCase("java.lang.Character")) {
                        theMap.put(name, new Integer(1));
                    } else {
                        theMap.put(name, new Integer(-1));
                    }
                }
            }
        } else {
            theMap.put(name, new Integer(-1));
        }
    }

    private static e isStringFunction(com.metamatrix.query.o.i.j symbol) {
        com.metamatrix.query.o.i.n expressionSymbol = null;
        e function = null;
        if (symbol instanceof d && ((d)symbol).a4() instanceof com.metamatrix.query.o.i.n) {
            expressionSymbol = (com.metamatrix.query.o.i.n)((d)symbol).a4();
        } else if (symbol instanceof com.metamatrix.query.o.i.n) {
            expressionSymbol = (com.metamatrix.query.o.i.n)symbol;
        }
        if (expressionSymbol != null && expressionSymbol.a6() instanceof e) {
            function = (e)expressionSymbol.a6();
            if (function.bx().equalsIgnoreCase("CONCAT") || function.bx().equalsIgnoreCase("||")) {
                return function;
            }
            if (TransformationSqlHelper.isDecodeOrSubString(function)) {
                return function;
            }
            return null;
        }
        return function;
    }

    private static boolean isDecodeOrSubString(e function) {
        return function.bx().equalsIgnoreCase("decodestring") || function.bx().equalsIgnoreCase("substring");
    }

    private static int concatSymbolLength(s exprObject) {
        s[] args = null;
        a elSymbol = null;
        int stringLength = 0;
        if (exprObject instanceof e) {
            e myFunc = (e)exprObject;
            if (TransformationSqlHelper.isDecodeOrSubString(myFunc)) {
                return stringLength += TransformationSqlHelper.getMaxStringLength(myFunc);
            }
            if (myFunc.bx().equalsIgnoreCase("chr")) {
                return ++stringLength;
            }
            args = myFunc.bz();
            for (int i2 = 0; i2 < args.length; ++i2) {
                s symbol = args[i2];
                if (symbol instanceof e) {
                    stringLength += TransformationSqlHelper.concatSymbolLength(symbol);
                }
                if (symbol instanceof a && (elSymbol = (a)symbol) != null) {
                    Object mID = elSymbol.bf();
                    if (mID != null && mID instanceof ColumnRecord) {
                        int length = ((ColumnRecord)mID).getLength();
                        stringLength += length;
                    } else if (mID != null && mID instanceof ProcedureParameterRecord) {
                        int length = ((ProcedureParameterRecord)mID).getLength();
                        stringLength += length;
                    } else {
                        stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength();
                    }
                }
                if (!(symbol instanceof c)) continue;
                c constant = (c)args[i2];
                Object value = constant.bp();
                if (value != null && value instanceof String) {
                    stringLength += ((String)value).length();
                    continue;
                }
                stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength();
            }
        } else if (exprObject instanceof a) {
            elSymbol = (a)exprObject;
            if (elSymbol != null) {
                Object mID = elSymbol.bf();
                if (mID != null && mID instanceof ColumnRecord) {
                    int length = ((ColumnRecord)mID).getLength();
                    stringLength += length;
                } else if (mID != null && mID instanceof ProcedureParameterRecord) {
                    int length = ((ProcedureParameterRecord)mID).getLength();
                    stringLength += length;
                } else {
                    stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength();
                }
            }
        } else if (exprObject instanceof c) {
            c constant = (c)exprObject;
            Object value = constant.bp();
            stringLength = value != null && value instanceof String ? (stringLength += ((String)value).length()) : (stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength());
        }
        return stringLength += 0;
    }

    public static int getSymbolLength(com.metamatrix.query.o.i.j symbol) {
        int stringLength = 0;
        e function = null;
        function = TransformationSqlHelper.isStringFunction(symbol);
        if (function != null) {
            if (!TransformationSqlHelper.isDecodeOrSubString(function)) {
                s[] args = function.bz();
                a elSymbol = null;
                for (int i2 = 0; i2 < args.length; ++i2) {
                    c constant;
                    s exprSymbol = args[i2];
                    if (exprSymbol instanceof e) {
                        stringLength += TransformationSqlHelper.concatSymbolLength(exprSymbol);
                    }
                    if (exprSymbol instanceof a && (elSymbol = (a)exprSymbol) != null) {
                        stringLength += TransformationSqlHelper.concatSymbolLength((s)elSymbol);
                    }
                    if (!(exprSymbol instanceof c) || (constant = (c)exprSymbol) == null) continue;
                    stringLength += TransformationSqlHelper.concatSymbolLength((s)constant);
                }
            } else if (TransformationSqlHelper.isDecodeOrSubString(function)) {
                stringLength += TransformationSqlHelper.getMaxStringLength(function);
            }
        } else {
            stringLength += 0;
        }
        return stringLength;
    }

    private static int getMaxStringLength(e function) {
        s[] args = function.bz();
        s exprSymbol = args[0];
        if (function.bx().equalsIgnoreCase("decodestring")) {
            return TransformationSqlHelper.getDecodeLength(function);
        }
        return TransformationSqlHelper.concatSymbolLength(exprSymbol);
    }

    private static int getDecodeLength(e function) {
        c constSym;
        Object constObj;
        a elmSymbol;
        s[] args = function.bz();
        s exprSymbol = null;
        int maxLength = 0;
        exprSymbol = args[0];
        if (exprSymbol instanceof a && (elmSymbol = (a)exprSymbol) != null) {
            int length;
            Object mID = elmSymbol.bf();
            maxLength = mID != null && mID instanceof ColumnRecord ? (length = ((ColumnRecord)mID).getLength()) : (mID != null && mID instanceof ProcedureParameterRecord ? (length = ((ProcedureParameterRecord)mID).getLength()) : ModelerCore.getTransformationPreferences().getDefaultStringLength());
        }
        if ((exprSymbol = args[1]) instanceof c && (constObj = (constSym = (c)exprSymbol).bp()) != null && constObj instanceof String) {
            String decodes = (String)constObj;
            String delimiter = ",";
            if (args.length == 3 && (constObj = (constSym = (c)(exprSymbol = args[2])).bp()) != null && constObj instanceof String) {
                delimiter = (String)constObj;
            }
            StringTokenizer strTok = new StringTokenizer(decodes, delimiter);
            while (strTok.hasMoreTokens()) {
                String word = strTok.nextToken().trim();
                if (word.length() <= maxLength) continue;
                maxLength = word.length();
            }
        }
        return maxLength;
    }

    public static List getProjectedSymbolTypes(com.metamatrix.query.o.j.k command) {
        ArrayList<Object> selectTypes = new ArrayList<Object>();
        if (command != null) {
            List symbols = command.gc();
            Iterator iter = symbols.iterator();
            while (iter.hasNext()) {
                com.metamatrix.query.o.i.j symbol = (com.metamatrix.query.o.i.j)iter.next();
                selectTypes.add(TransformationSqlHelper.getElementSymbolType(symbol));
            }
        }
        return selectTypes;
    }

    public static Map getRenamedSymbolsMap(List symbols) {
        HashMap<String, com.metamatrix.query.o.i.j> renameMap = new HashMap<String, com.metamatrix.query.o.i.j>();
        ArrayList<Object> seSymbols = new ArrayList<Object>();
        Iterator symbolIter = symbols.iterator();
        while (symbolIter.hasNext()) {
            b sSymbol = (b)symbolIter.next();
            if (sSymbol instanceof com.metamatrix.query.o.i.i) {
                List meSymbols = ((com.metamatrix.query.o.i.i)sSymbol).az();
                if (meSymbols == null) continue;
                Iterator meIter = meSymbols.iterator();
                while (meIter.hasNext()) {
                    a eSymbol = (a)meIter.next();
                    if (eSymbol == null) continue;
                    seSymbols.add(eSymbol);
                }
                continue;
            }
            if (!(sSymbol instanceof com.metamatrix.query.o.i.j)) continue;
            seSymbols.add(sSymbol);
        }
        ArrayList<String> elementNames = new ArrayList<String>();
        symbolIter = seSymbols.iterator();
        while (symbolIter.hasNext()) {
            String name;
            com.metamatrix.query.o.i.j seSymbol = (com.metamatrix.query.o.i.j)symbolIter.next();
            String uniqueName = name = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol, false);
            com.metamatrix.query.o.i.j underlyingSymbol = seSymbol;
            if (seSymbol instanceof d) {
                underlyingSymbol = ((d)seSymbol).a4();
            }
            if (underlyingSymbol instanceof a) {
                a eSymbol = (a)underlyingSymbol;
                uniqueName = TransformationSqlHelper.getUniqueName(name, elementNames);
                Object idObj = eSymbol.bf();
                if (idObj != null && idObj instanceof MetadataRecord) {
                    elementNames.add(uniqueName);
                }
            } else if (underlyingSymbol instanceof com.metamatrix.query.o.i.n) {
                uniqueName = TransformationSqlHelper.getUniqueName(name, elementNames);
                elementNames.add(uniqueName);
            }
            if (uniqueName.equals(name)) continue;
            renameMap.put(uniqueName, seSymbol);
        }
        return renameMap;
    }

    private static List createFromClauses(List sqlAliases) {
        ArrayList<Object> result = new ArrayList<Object>(sqlAliases.size());
        Iterator iter = sqlAliases.iterator();
        while (iter.hasNext()) {
            com.metamatrix.query.o.j.b clause;
            SqlAlias sqlAlias = (SqlAlias)iter.next();
            EObject aliasedEObject = sqlAlias.getAliasedObject();
            if (TransformationHelper.isSqlTable((Object)aliasedEObject)) {
                f gSymbol = TransformationSqlHelper.createGroupSymbol((EObject)sqlAlias);
                result.add(new n(gSymbol));
                continue;
            }
            if (!TransformationHelper.isSqlProcedure((Object)aliasedEObject) || (clause = TransformationSqlHelper.createSubqueryFromClause((EObject)sqlAlias)) == null) continue;
            result.add(clause);
        }
        return result;
    }

    private static ai createFromClause(EObject eObject) {
        ArgCheck.isNotNull((Object)eObject);
        EObject theEObj = eObject;
        if (eObject instanceof SqlAlias) {
            theEObj = ((SqlAlias)eObject).getAliasedObject();
        }
        n fromClause = null;
        if (TransformationHelper.isSqlTable((Object)theEObj)) {
            fromClause = new n(TransformationSqlHelper.createGroupSymbol(eObject));
        } else if (TransformationHelper.isSqlProcedure((Object)theEObj)) {
            fromClause = TransformationSqlHelper.createSubqueryFromClause(eObject);
        }
        return fromClause;
    }

    private static List createGroupSymbols(List groupEObjs) {
        ArrayList<f> result = new ArrayList<f>(groupEObjs.size());
        Iterator iter = groupEObjs.iterator();
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            f gSymbol = TransformationSqlHelper.createGroupSymbol(eObj);
            if (gSymbol == null) continue;
            result.add(gSymbol);
        }
        return result;
    }

    private static com.metamatrix.query.o.j.b createSubqueryFromClause(EObject eObj) {
        u storedProc;
        ArgCheck.isNotNull((Object)eObj);
        com.metamatrix.query.o.j.b subqueryFromClause = null;
        String aliasName = null;
        if (eObj instanceof SqlAlias) {
            SqlAlias sqlAlias = (SqlAlias)eObj;
            aliasName = sqlAlias.getAlias();
            eObj = sqlAlias.getAliasedObject();
        }
        if ((storedProc = TransformationSqlHelper.createStoredProc(eObj)) != null) {
            subqueryFromClause = aliasName != null ? new com.metamatrix.query.o.j.b(aliasName, (com.metamatrix.query.o.j.k)storedProc) : new com.metamatrix.query.o.j.b("Proc", (com.metamatrix.query.o.j.k)storedProc);
        }
        return subqueryFromClause;
    }

    public static u createStoredProc(EObject eObj) {
        ArgCheck.isNotNull((Object)eObj);
        u storedProc = null;
        if (eObj instanceof SqlAlias) {
            SqlAlias sqlAlias = (SqlAlias)eObj;
            eObj = sqlAlias.getAliasedObject();
        }
        if (TransformationHelper.isSqlProcedure((Object)eObj)) {
            SqlColumnSetAspect rsAspect;
            List rsCols;
            SqlProcedureAspect procedureAspect = (SqlProcedureAspect)AspectManager.getSqlAspect((EObject)eObj);
            String procFullName = procedureAspect.getFullName(eObj);
            storedProc = new u();
            storedProc.hy(procFullName);
            List procParams = procedureAspect.getParameters(eObj);
            List spParams = TransformationSqlHelper.createSPParams(procParams);
            Iterator iter = spParams.iterator();
            while (iter.hasNext()) {
                storedProc.ib((al)iter.next());
            }
            EObject results = (EObject)procedureAspect.getResult(eObj);
            if (SqlAspectHelper.isProcedureResultSet((EObject)results) && (rsCols = (rsAspect = (SqlColumnSetAspect)SqlAspectHelper.getSqlAspect((EObject)results)).getColumns(results)).size() > 0) {
                al param = new al(spParams.size(), 5, "RESULT");
                param.g("RESULT", class$java$lang$String == null ? (class$java$lang$String = TransformationSqlHelper.class$("java.lang.String")) : class$java$lang$String, (Object)"RESULT");
                storedProc.ib(param);
            }
        }
        return storedProc;
    }

    public static f createGroupSymbol(EObject groupEObj) {
        f gSymbol = null;
        String aliasName = null;
        if (groupEObj instanceof SqlAlias) {
            SqlAlias sqlAlias = (SqlAlias)groupEObj;
            aliasName = sqlAlias.getAlias();
            groupEObj = sqlAlias.getAliasedObject();
        }
        if (SqlAspectHelper.isTable((EObject)groupEObj)) {
            SqlTableAspect tableAspect = (SqlTableAspect)AspectManager.getSqlAspect((EObject)groupEObj);
            boolean hasResource = groupEObj.eResource() != null;
            String tableFullName = tableAspect.getName(groupEObj);
            if (hasResource) {
                tableFullName = tableAspect.getFullName(groupEObj);
            }
            String tableShortName = tableAspect.getName(groupEObj);
            Object groupID = null;
            if (hasResource) {
                groupID = TransformationSqlHelper.getGroupID(tableFullName, groupEObj);
            }
            gSymbol = aliasName != null && !aliasName.equalsIgnoreCase(tableShortName) ? new f(aliasName, tableFullName) : new f(tableFullName);
            if (groupID != null) {
                gSymbol.au(groupID);
            }
        } else if (groupEObj instanceof InputSet) {
            String inputSetFullName = "InputSet";
            String inputSetShortName = "InputSet";
            gSymbol = aliasName != null && !aliasName.equalsIgnoreCase(inputSetShortName) ? new f(aliasName, inputSetFullName) : new f(inputSetFullName);
        }
        return gSymbol;
    }

    private static Object getElementID(String elementFullName, EObject elmntObj) {
        ColumnRecordImpl elemID = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)elmntObj);
        elemID = new ColumnRecordImpl(sqlAspect, elmntObj);
        return elemID;
    }

    private static Object getGroupID(String groupFullName, EObject grpObj) {
        TableRecordImpl groupID = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)grpObj);
        groupID = new TableRecordImpl(sqlAspect, grpObj);
        return groupID;
    }

    private static com.metamatrix.query.m.a getProcInfo(String procFullName, EObject procObj) {
        com.metamatrix.query.m.a procInfo = null;
        try {
            com.metamatrix.query.m.e resolver = TransformationMetadataFactory.getInstance().getModelerMetadata(procObj);
            procInfo = resolver.getStoredProcedureInfoForProcedure(procFullName);
        }
        catch (QueryMetadataException e2) {
            String message = TransformationPlugin.Util.getString("TransformationSqlHelper.groupIDNotFoundError", (Object)procFullName);
            TransformationPlugin.Util.log(2, (Throwable)e2, message);
        }
        catch (MetaMatrixComponentException e3) {
            String message = TransformationPlugin.Util.getString("TransformationSqlHelper.groupIDNotFoundError", (Object)procFullName);
            TransformationPlugin.Util.log(2, (Throwable)e3, message);
        }
        return procInfo;
    }

    private static List createElemSymbols(List sqlAliasGroups) {
        ArrayList result = new ArrayList();
        Iterator iter = sqlAliasGroups.iterator();
        while (iter.hasNext()) {
            SqlAlias groupSqlAlias = (SqlAlias)iter.next();
            result.addAll(TransformationSqlHelper.createElemSymbols(groupSqlAlias));
        }
        return result;
    }

    private static List createElemSymbols(SqlAlias groupSqlAlias) {
        ArrayList<com.metamatrix.query.o.i.j> result = new ArrayList<com.metamatrix.query.o.i.j>();
        f groupSymbol = TransformationSqlHelper.createGroupSymbol((EObject)groupSqlAlias);
        EObject groupEObj = groupSqlAlias.getAliasedObject();
        if (SqlAspectHelper.isTable((EObject)groupEObj)) {
            SqlTableAspect tableAspect = (SqlTableAspect)AspectManager.getSqlAspect((EObject)groupEObj);
            List columns = tableAspect.getColumns(groupEObj);
            Iterator columnIter = columns.iterator();
            com.metamatrix.query.o.i.j seSymbol = null;
            while (columnIter.hasNext()) {
                EObject columnEObj = (EObject)columnIter.next();
                seSymbol = TransformationSqlHelper.createElemSymbol(columnEObj, groupSymbol);
                result.add(seSymbol);
            }
        }
        return result;
    }

    public static com.metamatrix.query.o.i.j createElemSymbol(EObject elemEObj, f parentGroupSymbol) {
        InputParameterSqlAspect aspect;
        a seSymbol = null;
        boolean isUUIDGroup = false;
        String tableName = parentGroupSymbol.ak();
        if (tableName == null) {
            tableName = "";
        } else if (SqlConverter.isStringifiedUUID((String)tableName)) {
            isUUIDGroup = true;
        }
        String columnAliasName = null;
        if (elemEObj instanceof SqlAlias) {
            SqlAlias columnAlias = (SqlAlias)elemEObj;
            columnAliasName = columnAlias.getAlias();
            elemEObj = columnAlias.getAliasedObject();
        }
        if (TransformationHelper.isSqlInputParameter((Object)elemEObj)) {
            aspect = (InputParameterSqlAspect)AspectManager.getSqlAspect((EObject)elemEObj);
            String fullName = null;
            fullName = isUUIDGroup ? TransformationHelper.getSqlEObjectUUID((EObject)elemEObj) : tableName + "." + aspect.getName(elemEObj);
            a element = new a(fullName);
            element.bm(parentGroupSymbol);
            if (aspect != null) {
                String rtType = aspect.getRuntimeType(elemEObj);
                if (rtType != null) {
                    Class clazz = DataTypeManager.getDataTypeClass((String)rtType);
                    element.bb((Object)new com.metamatrix.query.m.d(fullName.toUpperCase(), clazz));
                    element.bh(clazz);
                } else {
                    element.bb((Object)new com.metamatrix.query.m.d(fullName.toUpperCase(), DataTypeManager.DefaultDataClasses.NULL));
                    element.bh(DataTypeManager.DefaultDataClasses.NULL);
                }
            } else {
                element.bb((Object)new com.metamatrix.query.m.d(fullName.toUpperCase(), DataTypeManager.DefaultDataClasses.NULL));
                element.bh(DataTypeManager.DefaultDataClasses.NULL);
            }
            seSymbol = element;
        } else if (SqlAspectHelper.isColumn((EObject)elemEObj)) {
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)elemEObj);
            String colShortName = columnAspect.getName(elemEObj);
            String colUUID = TransformationHelper.getSqlEObjectUUID((EObject)elemEObj);
            Object elemID = TransformationSqlHelper.getElementID(colUUID, elemEObj);
            if (columnAliasName != null) {
                a elemSymbol = null;
                elemSymbol = isUUIDGroup ? new a(colUUID) : new a(tableName + "." + colShortName);
                elemSymbol.bm(parentGroupSymbol);
                if (elemID != null) {
                    elemSymbol.bb(elemID);
                }
                seSymbol = new d(columnAliasName, (com.metamatrix.query.o.i.j)elemSymbol);
            } else {
                a elemSymbol = null;
                elemSymbol = isUUIDGroup ? new a(colUUID) : new a(tableName + "." + colShortName);
                elemSymbol.bm(parentGroupSymbol);
                if (elemID != null) {
                    elemSymbol.bb(elemID);
                }
                seSymbol = elemSymbol;
            }
        } else if (TransformationHelper.isSqlProcedureParameter((Object)elemEObj)) {
            aspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)elemEObj);
            String paramName = null;
            paramName = isUUIDGroup ? TransformationHelper.getSqlEObjectUUID((EObject)elemEObj) : TransformationHelper.getSqlEObjectFullName((EObject)elemEObj);
            a element = new a(paramName);
            element.bm(parentGroupSymbol);
            if (aspect != null) {
                String rtType = aspect.getRuntimeType(elemEObj);
                if (rtType != null) {
                    Class clazz = DataTypeManager.getDataTypeClass((String)rtType);
                    element.bb((Object)new com.metamatrix.query.m.d(paramName.toUpperCase(), clazz));
                    element.bh(clazz);
                } else {
                    element.bb((Object)new com.metamatrix.query.m.d(paramName.toUpperCase(), DataTypeManager.DefaultDataClasses.NULL));
                    element.bh(DataTypeManager.DefaultDataClasses.NULL);
                }
            } else {
                element.bb((Object)new com.metamatrix.query.m.d(paramName.toUpperCase(), DataTypeManager.DefaultDataClasses.NULL));
                element.bh(DataTypeManager.DefaultDataClasses.NULL);
            }
            seSymbol = element;
        }
        return seSymbol;
    }

    public static List renameConflictingSymbols(List seSymbols) {
        ArrayList<Object> newSymbols = new ArrayList<Object>();
        Map renamedSymbolsMap = TransformationSqlHelper.getRenamedSymbolsMap(seSymbols);
        if (renamedSymbolsMap.size() != 0) {
            HashMap workingRenSymMap = new HashMap(renamedSymbolsMap);
            for (int i2 = 0; i2 < seSymbols.size(); ++i2) {
                b currentSelectSymbol = (b)seSymbols.get(i2);
                if (currentSelectSymbol instanceof com.metamatrix.query.o.i.i) {
                    boolean shouldExpand = TransformationSqlHelper.shouldExpand((com.metamatrix.query.o.i.i)currentSelectSymbol, workingRenSymMap);
                    if (shouldExpand) {
                        List multiElemSymbols = ((com.metamatrix.query.o.i.i)currentSelectSymbol).az();
                        Iterator iter = multiElemSymbols.iterator();
                        while (iter.hasNext()) {
                            com.metamatrix.query.o.i.j renamedSymbol = TransformationSqlHelper.renameSymbolUsingMap((com.metamatrix.query.o.i.j)iter.next(), workingRenSymMap);
                            newSymbols.add(renamedSymbol);
                        }
                        continue;
                    }
                    newSymbols.add(currentSelectSymbol);
                    continue;
                }
                if (!(currentSelectSymbol instanceof com.metamatrix.query.o.i.j)) continue;
                com.metamatrix.query.o.i.j renamedSymbol = TransformationSqlHelper.renameSymbolUsingMap((com.metamatrix.query.o.i.j)currentSelectSymbol, workingRenSymMap);
                newSymbols.add(renamedSymbol);
            }
        } else {
            newSymbols.addAll(seSymbols);
        }
        return newSymbols;
    }

    private static boolean shouldExpand(com.metamatrix.query.o.i.i multiElemSymbol, Map renamedSymbolsMap) {
        boolean shouldExpand = false;
        List multiElemSymbols = multiElemSymbol.az();
        Collection renamedSymbols = renamedSymbolsMap.values();
        Iterator iter = renamedSymbols.iterator();
        while (iter.hasNext()) {
            if (!multiElemSymbols.contains(iter.next())) continue;
            shouldExpand = true;
            break;
        }
        return shouldExpand;
    }

    private static com.metamatrix.query.o.i.j renameSymbolUsingMap(com.metamatrix.query.o.i.j seSymbol, Map renamedSymbolsMap) {
        com.metamatrix.query.o.i.j resultSymbol = seSymbol;
        if (seSymbol != null) {
            Iterator renamedIter = renamedSymbolsMap.keySet().iterator();
            while (renamedIter.hasNext()) {
                String newName = (String)renamedIter.next();
                com.metamatrix.query.o.i.j renamedSymbol = (com.metamatrix.query.o.i.j)renamedSymbolsMap.get(newName);
                if (!renamedSymbol.equals((Object)seSymbol)) continue;
                if (seSymbol instanceof d) {
                    seSymbol.ai(newName);
                    resultSymbol = seSymbol;
                } else {
                    resultSymbol = new d(newName, seSymbol);
                }
                renamedSymbolsMap.remove(newName);
                break;
            }
        }
        return resultSymbol;
    }

    private static List createSPParams(List procParams) {
        ArrayList<al> spparams = new ArrayList<al>(procParams.size());
        int index = 0;
        block6: for (int i2 = 0; i2 < procParams.size(); ++i2) {
            EObject paramObject = (EObject)procParams.get(i2);
            SqlAspect sqlAspect = SqlAspectHelper.getSqlAspect((EObject)paramObject);
            if (!(sqlAspect instanceof SqlProcedureParameterAspect)) continue;
            SqlProcedureParameterAspect paramAspect = (SqlProcedureParameterAspect)sqlAspect;
            int direction = paramAspect.getType(paramObject);
            String name = paramAspect.getName(paramObject);
            switch (direction) {
                case 0: {
                    al spparam1 = new al(index, (s)new a(name));
                    spparam1.o(name);
                    spparam1.v(1);
                    spparams.add(spparam1);
                    ++index;
                    continue block6;
                }
                case 2: {
                    al spparam2 = new al(index, (s)new a(name));
                    spparam2.o(name);
                    spparam2.v(3);
                    spparams.add(spparam2);
                    ++index;
                    continue block6;
                }
                case 1: {
                    al spparam3 = new al(index, (s)new a(name));
                    spparam3.o(name);
                    spparam3.v(2);
                    spparams.add(spparam3);
                    ++index;
                    continue block6;
                }
                case 3: {
                    al spparam4 = new al(index, (s)new a(name));
                    spparam4.o(name);
                    spparam4.v(4);
                    spparams.add(spparam4);
                    ++index;
                }
            }
        }
        return spparams;
    }

    public static String getGroupSymbolShortName(f gSymbol) {
        String shortName = null;
        if (gSymbol != null) {
            String symbolDefn = gSymbol.ar();
            String symbolName = gSymbol.ak();
            if (symbolDefn != null) {
                shortName = symbolName;
            } else {
                EObject eObj = TransformationSqlHelper.getGroupSymbolEObject(gSymbol);
                shortName = TransformationHelper.getSqlEObjectName((EObject)eObj);
            }
        }
        return shortName;
    }

    public static Collection getGroupSymbols(com.metamatrix.query.o.j.k command) {
        Collection allGrps = com.metamatrix.query.o.h.d.eb((com.metamatrix.query.o.d)command, (boolean)false);
        ArrayList<f> result = new ArrayList<f>(allGrps.size());
        Iterator iter = allGrps.iterator();
        while (iter.hasNext()) {
            f gSymbol = (f)iter.next();
            if (TransformationSqlHelper.containsGroupSymbol(result, gSymbol)) continue;
            result.add(gSymbol);
        }
        return result;
    }

    private static boolean containsGroupSymbol(Collection symbols, f gSymbol) {
        boolean result = false;
        String gSymbName = gSymbol.am();
        String gSymbDefn = gSymbol.ar();
        Iterator iter = symbols.iterator();
        while (iter.hasNext()) {
            f listSymbol = (f)iter.next();
            String lSymbName = listSymbol.am();
            String lSymbDefn = listSymbol.ar();
            if (lSymbDefn == null && gSymbDefn == null) {
                if (!lSymbName.equals(gSymbName)) continue;
                result = true;
                break;
            }
            if (lSymbDefn == null || gSymbDefn == null || !lSymbDefn.equalsIgnoreCase(gSymbDefn) || !lSymbName.equals(gSymbName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static int getReferenceCount(Object transMappingRoot, int type) {
        com.metamatrix.query.o.j.k command = TransformationHelper.getCommand((Object)transMappingRoot, (int)type);
        int refCount = 0;
        if (command != null) {
            ArrayList refs = new ArrayList();
            g.eo((com.metamatrix.query.o.d)command, refs);
            refCount = refs.size();
        }
        return refCount;
    }

    public static EObject getElementSymbolEObject(a symbol) {
        Object elemObj;
        EObject result = null;
        if (symbol != null && (elemObj = symbol.bf()) != null) {
            if (elemObj instanceof MetadataRecord) {
                result = ((MetadataRecord)elemObj).getEObject();
            } else if (TransformationHelper.isSqlColumn((Object)elemObj)) {
                result = (EObject)elemObj;
            }
        }
        return result;
    }

    public static EObject getElementSymbolEObject(a symbol, com.metamatrix.query.o.j.k command) {
        Object elemObj;
        EObject result = null;
        if (symbol != null && (elemObj = symbol.bf()) != null) {
            if (elemObj instanceof MetadataRecord) {
                result = ((MetadataRecord)elemObj).getEObject();
            } else if (elemObj instanceof com.metamatrix.query.m.d) {
                String elemSymbolName = symbol.a3();
                f elemGrpSymbol = symbol.bc();
                List subQryFromClauses = com.metamatrix.query.o.h.a.d4((com.metamatrix.query.o.d)command);
                Iterator sqFromIter = subQryFromClauses.iterator();
                block0: while (sqFromIter.hasNext()) {
                    com.metamatrix.query.o.j.k sqCommand;
                    com.metamatrix.query.o.j.b clause = (com.metamatrix.query.o.j.b)sqFromIter.next();
                    f sqGrpSymbol = clause.c2();
                    if (sqGrpSymbol == null || elemGrpSymbol == null || !sqGrpSymbol.ak().equals(elemGrpSymbol.ak()) || !((sqCommand = clause.r()) instanceof u)) continue;
                    List resultSetParams = TransformationHelper.getProcedureResultSetParameters((u)((u)sqCommand));
                    Iterator paramIter = resultSetParams.iterator();
                    while (paramIter.hasNext()) {
                        SqlColumnAspect sqlColAspect;
                        String colName;
                        Object param = paramIter.next();
                        if (!TransformationHelper.isSqlColumn(param) || (colName = (sqlColAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect((EObject)((EObject)param))).getName((EObject)param)) == null || !colName.equalsIgnoreCase(elemSymbolName)) continue;
                        result = (EObject)param;
                        continue block0;
                    }
                }
            }
        }
        return result;
    }

    public static Object getElementSymbolType(com.metamatrix.query.o.i.j symbol) {
        Class datatype = null;
        if (symbol instanceof d) {
            symbol = ((d)symbol).a4();
        }
        if (symbol instanceof a) {
            a eSymbol = (a)symbol;
            Object idObj = eSymbol.bf();
            if (idObj instanceof MetadataRecord) {
                EObject recordEObj = ((MetadataRecord)idObj).getEObject();
                if (recordEObj != null && TransformationHelper.isSqlColumn((Object)recordEObj)) {
                    SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)recordEObj);
                    datatype = columnAspect.getDatatype(recordEObj);
                }
            } else if (idObj instanceof com.metamatrix.query.m.d) {
                datatype = ((com.metamatrix.query.m.d)idObj).e();
            } else if (idObj == null) {
                datatype = eSymbol.ag();
            }
        } else if (symbol instanceof com.metamatrix.query.o.i.n) {
            com.metamatrix.query.o.i.n exSymbol = (com.metamatrix.query.o.i.n)symbol;
            datatype = exSymbol.ag();
        }
        return datatype;
    }

    public static int getElementSymbolLength(com.metamatrix.query.o.i.j symbol) {
        a eSymbol;
        EObject eObj;
        int length = -1;
        if (symbol instanceof d) {
            symbol = ((d)symbol).a4();
        }
        if (symbol instanceof a && (eObj = TransformationSqlHelper.getElementSymbolEObject(eSymbol = (a)symbol)) != null) {
            length = TransformationHelper.getSqlColumnLength((EObject)eObj);
        }
        return length;
    }

    public static List getElementSymbolEObjects(Collection elemSymbols, com.metamatrix.query.o.j.k command) {
        ArrayList<EObject> result = Collections.EMPTY_LIST;
        if (elemSymbols != null) {
            result = new ArrayList<EObject>(elemSymbols.size());
            Iterator iter = elemSymbols.iterator();
            while (iter.hasNext()) {
                a eSymbol = (a)iter.next();
                EObject elemEObj = TransformationSqlHelper.getElementSymbolEObject(eSymbol, command);
                if (elemEObj == null) continue;
                result.add(elemEObj);
            }
        }
        return result;
    }

    public static EObject getGroupSymbolEObject(f symbol) {
        Object groupObj;
        EObject result = null;
        if (symbol != null && (groupObj = symbol.aq()) != null) {
            if (groupObj instanceof MetadataRecord) {
                result = ((MetadataRecord)groupObj).getEObject();
            } else if (TransformationHelper.isSqlProcedureResultSet((Object)groupObj)) {
                result = (EObject)groupObj;
            }
        }
        return result;
    }

    public static List getGroupSymbolEObjects(Collection groupSymbols) {
        ArrayList<EObject> result = Collections.EMPTY_LIST;
        if (groupSymbols != null) {
            result = new ArrayList<EObject>(groupSymbols.size());
            Iterator iter = groupSymbols.iterator();
            while (iter.hasNext()) {
                f gSymbol = (f)iter.next();
                EObject grpEObj = TransformationSqlHelper.getGroupSymbolEObject(gSymbol);
                if (grpEObj == null) continue;
                result.add(grpEObj);
            }
        }
        return result;
    }

    public static EObject getStoredProcedureEObject(u storedProc) {
        Object procID;
        EObject result = null;
        if (storedProc != null && (procID = storedProc.h8()) != null && procID instanceof MetadataRecord) {
            result = ((MetadataRecord)procID).getEObject();
        }
        return result;
    }

    public static boolean hasSqlAliasGroupAttributes(ad query, List sqlAliasGroups) {
        boolean result = false;
        List aliasGroupSymbols = TransformationSqlHelper.createGroupSymbols(sqlAliasGroups);
        if (!TransformationSqlHelper.isSelectStar(query.i9())) {
            Collection selectElements = k.e4((com.metamatrix.query.o.d)query.i9(), (boolean)true);
            Iterator iter = selectElements.iterator();
            while (iter.hasNext()) {
                a selectElem = (a)iter.next();
                Collection symbolGroups = aa.gz((com.metamatrix.query.o.d)selectElem);
                Iterator symbolGroupIter = symbolGroups.iterator();
                while (symbolGroupIter.hasNext()) {
                    f groupSymbol = (f)symbolGroupIter.next();
                    if (!aliasGroupSymbols.contains(groupSymbol)) continue;
                    result = true;
                    break;
                }
                if (!result) continue;
                break;
            }
        }
        return result;
    }

    public static boolean hasSqlElemSymbols(ad query, List elemEObjs) {
        boolean result = false;
        List projSymbolNames = TransformationSqlHelper.getProjectedSymbolNames((com.metamatrix.query.o.j.k)query);
        Iterator iter = elemEObjs.iterator();
        while (iter.hasNext()) {
            SqlColumnAspect columnAspect;
            Object elem = iter.next();
            if (!(elem instanceof EObject) || !SqlAspectHelper.isColumn((EObject)((EObject)elem)) || !projSymbolNames.contains((columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)((EObject)elem))).getName((EObject)elem))) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isSelectStar(q select) {
        b singleSelectSymbol;
        boolean result = false;
        List currentSelectSymbols = select.j9();
        if (currentSelectSymbols.size() == 1 && (singleSelectSymbol = (b)currentSelectSymbols.get(0)) instanceof com.metamatrix.query.o.i.q) {
            result = true;
        }
        return result;
    }

    public static com.metamatrix.query.o.i.n convert(com.metamatrix.query.o.i.n exprSymbol, String newTypeName) {
        com.metamatrix.query.o.i.n newExpressionSymbol = (com.metamatrix.query.o.i.n)exprSymbol.clone();
        s expr = exprSymbol.a6();
        Class originalTypeClass = expr.ag();
        String originalTypeName = DataTypeManager.getDataTypeName((Class)originalTypeClass);
        if (!originalTypeName.equalsIgnoreCase(newTypeName)) {
            if (TransformationSqlHelper.isConvertFunction(exprSymbol)) {
                s convExpr = TransformationSqlHelper.getConvertedExpr(exprSymbol);
                Class convExprTypeClass = convExpr.ag();
                String convExprTypeName = DataTypeManager.getDataTypeName((Class)convExprTypeClass);
                boolean isExplicit = DataTypeManager.isExplicitConversion((String)convExprTypeName, (String)newTypeName);
                boolean isImplicit = DataTypeManager.isImplicitConversion((String)convExprTypeName, (String)newTypeName);
                if (isExplicit || isImplicit) {
                    e func = TransformationSqlHelper.getConversion(convExprTypeName, newTypeName, convExpr);
                    newExpressionSymbol.a7((s)func);
                } else {
                    e convertFunction = TransformationSqlHelper.getConversion(originalTypeName, newTypeName, expr);
                    newExpressionSymbol.a7((s)convertFunction);
                }
            } else {
                e convertFunction = TransformationSqlHelper.getConversion(originalTypeName, newTypeName, expr);
                newExpressionSymbol.a7((s)convertFunction);
            }
        }
        return newExpressionSymbol;
    }

    public static d convert(a elementSymbol, String newTypeName, String aliasName) {
        Class originalTypeClass = elementSymbol.ag();
        String originalTypeName = DataTypeManager.getDataTypeName((Class)originalTypeClass);
        e convertFunction = TransformationSqlHelper.getConversion(originalTypeName, newTypeName, (s)elementSymbol);
        com.metamatrix.query.o.i.n exprSymbol = new com.metamatrix.query.o.i.n(NEW_CONVERSION_NAME, (s)convertFunction);
        d newSymbol = null;
        newSymbol = aliasName != null ? new d(aliasName, (com.metamatrix.query.o.i.j)exprSymbol) : new d(elementSymbol.a3(), (com.metamatrix.query.o.i.j)exprSymbol);
        return newSymbol;
    }

    public static e getConversion(String originalTypeName, String newTypeName, s expression) {
        Class originalType = DataTypeManager.getDataTypeClass((String)originalTypeName);
        com.metamatrix.query.function.b library = com.metamatrix.query.function.g.b();
        com.metamatrix.query.function.a fd = library.f("convert", new Class[]{originalType, DataTypeManager.DefaultDataClasses.STRING});
        e conversion = new e(fd.b(), new s[]{expression, new c((Object)newTypeName)});
        conversion.bu(DataTypeManager.getDataTypeClass((String)newTypeName));
        conversion.bt(fd);
        return conversion;
    }

    public static boolean isConvertFunction(com.metamatrix.query.o.i.n exprSymbol) {
        String fName;
        s expr = exprSymbol.a6();
        return expr instanceof e && (fName = ((e)expr).bx()).equalsIgnoreCase("CONVERT");
    }

    public static s getConvertedExpr(com.metamatrix.query.o.i.n exprSymbol) {
        if (TransformationSqlHelper.isConvertFunction(exprSymbol)) {
            s expr = exprSymbol.a6();
            s fExp = ((e)expr).bw(0);
            return fExp;
        }
        return null;
    }

    public static d convertElementSymbol(a symbol, String targetTypeStr, String aliasName) {
        return TransformationSqlHelper.convert(symbol, targetTypeStr, aliasName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static com.metamatrix.query.o.i.n convertExpressionSymbol(com.metamatrix.query.o.i.n symbol, String targetTypeStr) {
        d aSymbol;
        com.metamatrix.query.o.i.j aseSymbol;
        if (!TransformationSqlHelper.isConvertFunction(symbol)) return TransformationSqlHelper.convert(symbol, targetTypeStr);
        s cExpr = TransformationSqlHelper.getConvertedExpr(symbol);
        if (!(cExpr instanceof com.metamatrix.query.o.i.j)) return null;
        com.metamatrix.query.o.i.j seSymbol = (com.metamatrix.query.o.i.j)cExpr;
        String seSymbolTypeStr = DataTypeManager.getDataTypeName((Class)seSymbol.ag());
        boolean isExplicitConv = DataTypeManager.isExplicitConversion((String)seSymbolTypeStr, (String)targetTypeStr);
        boolean isImplicitConv = DataTypeManager.isImplicitConversion((String)seSymbolTypeStr, (String)targetTypeStr);
        if (!isImplicitConv && !isExplicitConv) return TransformationSqlHelper.convert(symbol, targetTypeStr);
        if (seSymbol instanceof com.metamatrix.query.o.i.n) {
            return TransformationSqlHelper.convertExpressionSymbol((com.metamatrix.query.o.i.n)seSymbol, targetTypeStr);
        }
        if (!(seSymbol instanceof a) || !((aseSymbol = (aSymbol = TransformationSqlHelper.convertElementSymbol((a)seSymbol, targetTypeStr, null)).a4()) instanceof com.metamatrix.query.o.i.n)) return null;
        return (com.metamatrix.query.o.i.n)aseSymbol;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

